/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class TreeReference
implements Externalizable {
    public static final int DEFAULT_MUTLIPLICITY = 0;
    public static final int INDEX_UNBOUND = -1;
    public static final int INDEX_TEMPLATE = -2;
    public static final int INDEX_ATTRIBUTE = -4;
    public static final int INDEX_REPEAT_JUNCTURE = -10;
    public static final int REF_ABSOLUTE = -1;
    public static final String NAME_WILDCARD = "*";
    private int refLevel;
    private Vector names = new Vector(0);
    private Vector multiplicity = new Vector(0);

    public static TreeReference rootRef() {
        TreeReference treeReference = new TreeReference();
        treeReference.refLevel = -1;
        return treeReference;
    }

    public static TreeReference selfRef() {
        TreeReference treeReference = new TreeReference();
        treeReference.refLevel = 0;
        return treeReference;
    }

    public int getMultiplicity(int n) {
        return (Integer)this.multiplicity.elementAt(n);
    }

    public String getName(int n) {
        return (String)this.names.elementAt(n);
    }

    public int getMultLast() {
        return (Integer)this.multiplicity.lastElement();
    }

    public String getNameLast() {
        return (String)this.names.lastElement();
    }

    public void setMultiplicity(int n, int n2) {
        this.multiplicity.setElementAt(new Integer(n2), n);
    }

    public int size() {
        return this.names.size();
    }

    public void add(String string, int n) {
        this.names.addElement(string);
        this.multiplicity.addElement(new Integer(n));
    }

    public int getRefLevel() {
        return this.refLevel;
    }

    public void setRefLevel(int n) {
        this.refLevel = n;
    }

    public void incrementRefLevel() {
        if (!this.isAbsolute()) {
            ++this.refLevel;
        }
    }

    public boolean isAbsolute() {
        return this.refLevel == -1;
    }

    public boolean isAmbiguous() {
        for (int i = 1; i < this.size(); ++i) {
            if (this.getMultiplicity(i) != -1) continue;
            return true;
        }
        return false;
    }

    public TreeReference clone() {
        TreeReference treeReference = new TreeReference();
        treeReference.setRefLevel(this.refLevel);
        for (int i = 0; i < this.size(); ++i) {
            treeReference.add(this.getName(i), this.getMultiplicity(i));
        }
        return treeReference;
    }

    public boolean removeLastLevel() {
        int n = this.size();
        if (n == 0) {
            if (this.isAbsolute()) {
                return false;
            }
            ++this.refLevel;
            return true;
        }
        this.names.removeElementAt(n - 1);
        this.multiplicity.removeElementAt(n - 1);
        return true;
    }

    public TreeReference getParentRef() {
        TreeReference treeReference = this.clone();
        if (treeReference.removeLastLevel()) {
            return treeReference;
        }
        return null;
    }

    public TreeReference parent(TreeReference treeReference) {
        if (this.isAbsolute()) {
            return this;
        }
        TreeReference treeReference2 = treeReference.clone();
        if (this.refLevel > 0) {
            if (!treeReference.isAbsolute() && treeReference.size() == 0) {
                treeReference.refLevel += this.refLevel;
            } else {
                return null;
            }
        }
        for (int i = 0; i < this.names.size(); ++i) {
            treeReference2.add(this.getName(i), this.getMultiplicity(i));
        }
        return treeReference2;
    }

    public TreeReference anchor(TreeReference treeReference) {
        int n;
        if (this.isAbsolute()) {
            return this.clone();
        }
        if (!treeReference.isAbsolute()) {
            return null;
        }
        TreeReference treeReference2 = treeReference.clone();
        int n2 = treeReference.size();
        if (this.refLevel > n2) {
            return null;
        }
        for (n = 0; n < this.refLevel; ++n) {
            treeReference2.removeLastLevel();
        }
        for (n = 0; n < this.size(); ++n) {
            treeReference2.add(this.getName(n), this.getMultiplicity(n));
        }
        return treeReference2;
    }

    public TreeReference contextualize(TreeReference treeReference) {
        if (!treeReference.isAbsolute()) {
            return null;
        }
        TreeReference treeReference2 = this.anchor(treeReference);
        for (int i = 0; i < treeReference.size() && i < treeReference2.size(); ++i) {
            if (NAME_WILDCARD.equals(treeReference2.getName(i)) && !NAME_WILDCARD.equals(treeReference.getName(i))) {
                treeReference2.names.setElementAt(treeReference.getName(i), i);
            }
            if (!treeReference.getName(i).equals(treeReference2.getName(i))) break;
            treeReference2.setMultiplicity(i, treeReference.getMultiplicity(i));
        }
        return treeReference2;
    }

    public TreeReference relativize(TreeReference treeReference) {
        if (treeReference.isParentOf(this, false)) {
            TreeReference treeReference2 = TreeReference.selfRef();
            for (int i = treeReference.size(); i < this.size(); ++i) {
                treeReference2.add(this.getName(i), -1);
            }
            return treeReference2;
        }
        return null;
    }

    public TreeReference genericize() {
        TreeReference treeReference = this.clone();
        for (int i = 0; i < treeReference.size(); ++i) {
            treeReference.setMultiplicity(i, -1);
        }
        return treeReference;
    }

    public boolean isParentOf(TreeReference treeReference, boolean bl) {
        if (this.refLevel != treeReference.refLevel) {
            return false;
        }
        if (treeReference.size() < this.size() + (bl ? 1 : 0)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getName(i).equals(treeReference.getName(i))) {
                return false;
            }
            int n = this.getMultiplicity(i);
            int n2 = treeReference.getMultiplicity(i);
            if (n == -1 || n == n2 || i == 0 && n == 0 && n2 == -1) continue;
            return false;
        }
        return true;
    }

    public TreeReference extendRef(String string, int n) {
        TreeReference treeReference = this.clone();
        treeReference.add(string, n);
        return treeReference;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TreeReference) {
            TreeReference treeReference = (TreeReference)object;
            if (this.refLevel == treeReference.refLevel && this.size() == treeReference.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    String string = this.getName(i);
                    String string2 = treeReference.getName(i);
                    int n = this.getMultiplicity(i);
                    int n2 = treeReference.getMultiplicity(i);
                    if (!string.equals(string2)) {
                        return false;
                    }
                    if (n == n2 || i == 0 && (n == 0 || n == -1) && (n2 == 0 || n2 == -1)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = new Integer(this.refLevel).hashCode();
        for (int i = 0; i < this.size(); ++i) {
            Integer n2 = new Integer(this.getMultiplicity(i));
            if (i == 0 && n2 == -1) {
                n2 = new Integer(0);
            }
            n ^= this.getName(i).hashCode();
            n ^= n2.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAbsolute()) {
            stringBuffer.append("/");
        } else {
            for (n = 0; n < this.refLevel; ++n) {
                stringBuffer.append("../");
            }
        }
        for (n = 0; n < this.size(); ++n) {
            String string = this.getName(n);
            int n2 = this.getMultiplicity(n);
            if (n2 == -4) {
                stringBuffer.append("@");
            }
            stringBuffer.append(string);
            if (bl) {
                switch (n2) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        stringBuffer.append("[@template]");
                        break;
                    }
                    case -10: {
                        stringBuffer.append("[@juncture]");
                        break;
                    }
                    default: {
                        if (n <= 0 && n2 == 0) break;
                        stringBuffer.append("[" + (n2 + 1) + "]");
                    }
                }
            }
            if (n >= this.size() - 1) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.refLevel = ExtUtil.readInt(dataInputStream);
        this.names = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(String.class), prototypeFactory);
        this.multiplicity = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(Integer.class), prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.refLevel);
        ExtUtil.write(dataOutputStream, new ExtWrapList(this.names));
        ExtUtil.write(dataOutputStream, new ExtWrapList(this.multiplicity));
    }
}

