/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.InstanceTemplateManager;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.services.storage.WrappingStorageUtility;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class CompactInstanceWrapper
implements WrappingStorageUtility.SerializationWrapper {
    public static final int CHOICE_VALUE = 0;
    public static final int CHOICE_INDEX = 1;
    public static final int CHOICE_MODE = 1;
    private InstanceTemplateManager templateMgr;
    private FormInstance instance;

    public CompactInstanceWrapper() {
        this(null);
    }

    public CompactInstanceWrapper(InstanceTemplateManager instanceTemplateManager) {
        this.templateMgr = instanceTemplateManager;
    }

    public Class baseType() {
        return FormInstance.class;
    }

    public void setData(Externalizable externalizable) {
        this.instance = (FormInstance)externalizable;
    }

    public Externalizable getData() {
        return this.instance;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        int n = ExtUtil.readInt(dataInputStream);
        this.instance = this.getTemplateInstance(n).clone();
        this.instance.setID(ExtUtil.readInt(dataInputStream));
        this.instance.setDateSaved((Date)ExtUtil.read(dataInputStream, new ExtWrapNullable(Date.class)));
        TreeElement treeElement = this.instance.getRoot();
        this.readTreeElement(treeElement, dataInputStream, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        if (this.instance == null) {
            throw new RuntimeException("instance has not yet been set via setData()");
        }
        ExtUtil.writeNumeric(dataOutputStream, this.instance.getFormId());
        ExtUtil.writeNumeric(dataOutputStream, this.instance.getID());
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.instance.getDateSaved()));
        this.writeTreeElement(dataOutputStream, this.instance.getRoot());
    }

    private FormInstance getTemplateInstance(int n) {
        if (this.templateMgr != null) {
            return this.templateMgr.getTemplateInstance(n);
        }
        FormInstance formInstance = CompactInstanceWrapper.loadTemplateInstance(n);
        if (formInstance == null) {
            throw new RuntimeException("no formdef found for form id [" + n + "]");
        }
        return formInstance;
    }

    public static FormInstance loadTemplateInstance(int n) {
        IStorageUtility iStorageUtility = StorageManager.getStorage("FORMDEF");
        FormDef formDef = (FormDef)iStorageUtility.read(n);
        return formDef != null ? formDef.getInstance() : null;
    }

    private void readTreeElement(TreeElement treeElement, DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        boolean bl;
        TreeElement treeElement2 = this.instance.getTemplatePath(treeElement.getRef());
        boolean bl2 = bl = !treeElement2.isLeaf();
        if (bl) {
            String string;
            int n;
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < treeElement2.getNumChildren(); ++n) {
                string = treeElement2.getChildAt(n).getName();
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
            for (n = 0; n < vector.size(); ++n) {
                boolean bl3;
                string = (String)vector.elementAt(n);
                TreeReference treeReference = treeElement.getRef().extendRef(string, 0);
                TreeElement treeElement3 = this.instance.getTemplatePath(treeReference);
                boolean bl4 = treeElement3.repeatable;
                int n2 = ExtUtil.readInt(dataInputStream);
                boolean bl5 = bl3 = n2 > 0;
                if (!bl4 && n2 > 1) {
                    throw new DeserializationException("Detected repeated instances of a non-repeatable node");
                }
                if (bl4) {
                    int n3;
                    int n4 = treeElement.getChildMultiplicity(string);
                    for (n3 = n4 - 1; n3 >= 0; --n3) {
                        treeElement.removeChild(string, n3);
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        TreeReference treeReference2 = treeElement.getRef().extendRef(string, n3);
                        try {
                            this.instance.copyNode(treeElement3, treeReference2);
                        }
                        catch (InvalidReferenceException invalidReferenceException) {
                            TreeReference treeReference3 = invalidReferenceException.getInvalidReference();
                            if (treeReference3 == null) {
                                throw new DeserializationException("Null Reference while attempting to deserialize! " + invalidReferenceException.getMessage());
                            }
                            throw new DeserializationException("Invalid Reference while attemtping to deserialize! Reference: " + treeReference3.toString(true) + " | " + invalidReferenceException.getMessage());
                        }
                        TreeElement treeElement4 = treeElement.getChild(string, n3);
                        treeElement4.setRelevant(true);
                        this.readTreeElement(treeElement4, dataInputStream, prototypeFactory);
                    }
                    continue;
                }
                TreeElement treeElement5 = treeElement.getChild(string, 0);
                treeElement5.setRelevant(bl3);
                if (!bl3) continue;
                this.readTreeElement(treeElement5, dataInputStream, prototypeFactory);
            }
        } else {
            treeElement.setValue((IAnswerData)ExtUtil.read(dataInputStream, new ExtWrapAnswerData(treeElement.dataType)));
        }
    }

    private void writeTreeElement(DataOutputStream dataOutputStream, TreeElement treeElement) throws IOException {
        boolean bl;
        TreeElement treeElement2 = this.instance.getTemplatePath(treeElement.getRef());
        boolean bl2 = bl = !treeElement2.isLeaf();
        if (bl) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < treeElement2.getNumChildren(); ++i) {
                String string = treeElement2.getChildAt(i).getName();
                if (vector.contains(string)) continue;
                vector.addElement(string);
                int n = treeElement.getChildMultiplicity(string);
                if (n > 0 && !treeElement.getChild(string, 0).isRelevant()) {
                    n = 0;
                }
                ExtUtil.writeNumeric(dataOutputStream, n);
                for (int j = 0; j < n; ++j) {
                    this.writeTreeElement(dataOutputStream, treeElement.getChild(string, j));
                }
            }
        } else {
            ExtUtil.write(dataOutputStream, new ExtWrapAnswerData(treeElement.dataType, treeElement.getValue()));
        }
    }

    private Object compactSelectOne(SelectOneData selectOneData) {
        Selection selection = (Selection)selectOneData.getValue();
        return this.extractSelection(selection);
    }

    private Vector compactSelectMulti(SelectMultiData selectMultiData) {
        Vector vector = (Vector)selectMultiData.getValue();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.extractSelection((Selection)vector.elementAt(i)));
        }
        return vector2;
    }

    private SelectOneData getSelectOne(Object object) {
        return new SelectOneData(this.makeSelection(object));
    }

    private SelectMultiData getSelectMulti(Vector vector) {
        Vector<Selection> vector2 = new Vector<Selection>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.makeSelection(vector.elementAt(i)));
        }
        return new SelectMultiData(vector2);
    }

    private Object extractSelection(Selection selection) {
        switch (1) {
            case 0: {
                return selection.getValue();
            }
            case 1: {
                if (selection.index == -1) {
                    throw new RuntimeException("trying to serialize in choice-index mode but selections do not have indexes set!");
                }
                return new Integer(selection.index);
            }
        }
        throw new IllegalArgumentException();
    }

    private Selection makeSelection(Object object) {
        if (object instanceof String) {
            return new Selection((String)object);
        }
        if (object instanceof Integer) {
            return new Selection((Integer)object);
        }
        throw new RuntimeException();
    }

    public static Class classForDataType(int n) {
        switch (n) {
            case 0: {
                return StringData.class;
            }
            case 1: {
                return StringData.class;
            }
            case 2: {
                return IntegerData.class;
            }
            case 3: {
                return DecimalData.class;
            }
            case 9: {
                return BooleanData.class;
            }
            case 4: {
                return DateData.class;
            }
            case 5: {
                return TimeData.class;
            }
            case 6: {
                return DateTimeData.class;
            }
            case 7: {
                return SelectOneData.class;
            }
            case 8: {
                return SelectMultiData.class;
            }
            case 10: {
                return GeoPointData.class;
            }
        }
        return null;
    }

    private class ExtWrapAnswerData
    extends ExternalizableWrapper {
        int dataType;

        public ExtWrapAnswerData(int n, IAnswerData iAnswerData) {
            this.val = iAnswerData;
            this.dataType = n;
        }

        public ExtWrapAnswerData(int n) {
            this.dataType = n;
        }

        public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
            byte by = dataInputStream.readByte();
            if (by == 0) {
                this.val = null;
            } else {
                Class clazz = CompactInstanceWrapper.classForDataType(this.dataType);
                if (clazz == null) {
                    this.val = ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
                } else if (clazz == SelectOneData.class) {
                    this.val = CompactInstanceWrapper.this.getSelectOne(ExtUtil.read(dataInputStream, Integer.class));
                } else if (clazz == SelectMultiData.class) {
                    this.val = CompactInstanceWrapper.this.getSelectMulti((Vector)ExtUtil.read(dataInputStream, new ExtWrapList(Integer.class)));
                } else {
                    switch (by) {
                        case 64: {
                            clazz = StringData.class;
                            break;
                        }
                        case 65: {
                            clazz = IntegerData.class;
                            break;
                        }
                        case 66: {
                            clazz = DecimalData.class;
                            break;
                        }
                        case 67: {
                            clazz = DateData.class;
                            break;
                        }
                        case 68: {
                            clazz = BooleanData.class;
                        }
                    }
                    this.val = (IAnswerData)ExtUtil.read(dataInputStream, clazz);
                }
            }
        }

        public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
            if (this.val == null) {
                dataOutputStream.writeByte(0);
            } else {
                Externalizable externalizable;
                int n = 1;
                if (this.dataType < 0 || this.dataType >= 100) {
                    externalizable = new ExtWrapTagged(this.val);
                } else if (this.val instanceof SelectOneData) {
                    externalizable = new ExtWrapBase(CompactInstanceWrapper.this.compactSelectOne((SelectOneData)this.val));
                } else if (this.val instanceof SelectMultiData) {
                    externalizable = new ExtWrapList(CompactInstanceWrapper.this.compactSelectMulti((SelectMultiData)this.val));
                } else {
                    externalizable = (IAnswerData)this.val;
                    if (this.val.getClass() != CompactInstanceWrapper.classForDataType(this.dataType)) {
                        if (this.val instanceof StringData) {
                            n = 64;
                        } else if (this.val instanceof IntegerData) {
                            n = 65;
                        } else if (this.val instanceof DecimalData) {
                            n = 66;
                        } else if (this.val instanceof DateData) {
                            n = 67;
                        } else if (this.val instanceof BooleanData) {
                            n = 68;
                        } else {
                            throw new RuntimeException("divergent data type not allowed");
                        }
                    }
                }
                dataOutputStream.writeByte(n);
                ExtUtil.write(dataOutputStream, externalizable);
            }
        }

        public ExternalizableWrapper clone(Object object) {
            throw new RuntimeException("not supported");
        }

        public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
            throw new RuntimeException("not supported");
        }

        public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
            throw new RuntimeException("not supported");
        }
    }
}

