/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage;

import java.util.Enumeration;
import java.util.Hashtable;
import org.javarosa.core.services.storage.IStorageFactory;
import org.javarosa.core.services.storage.IStorageUtility;

public class StorageManager {
    private static Hashtable<String, IStorageUtility> storageRegistry = new Hashtable();
    private static IStorageFactory storageFactory;

    public static void setStorageFactory(IStorageFactory iStorageFactory) {
        storageFactory = iStorageFactory;
    }

    public static void registerStorage(String string, Class clazz) {
        StorageManager.registerStorage(string, string, clazz);
    }

    public static void registerStorage(String string, String string2, Class clazz) {
        if (storageFactory == null) {
            throw new RuntimeException("No storage factory has been set; I don't know what kind of storage utility to create. Either set a storage factory, or register your StorageUtilitys directly.");
        }
        StorageManager.registerStorage(string, storageFactory.newStorage(string2, clazz));
    }

    public static void registerStorage(String string, IStorageUtility iStorageUtility) {
        storageRegistry.put(string, iStorageUtility);
    }

    public static IStorageUtility getStorage(String string) {
        if (storageRegistry.containsKey(string)) {
            return storageRegistry.get(string);
        }
        throw new RuntimeException("No storage utility has been registered to handle \"" + string + "\"; you must register one first with StorageManager.registerStorage()");
    }

    public static void repairAll() {
        Enumeration<IStorageUtility> enumeration = storageRegistry.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().repair();
        }
    }

    public static String[] listRegisteredUtilities() {
        String[] stringArray = new String[storageRegistry.size()];
        int n = 0;
        Enumeration<String> enumeration = storageRegistry.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static void halt() {
        Enumeration<IStorageUtility> enumeration = storageRegistry.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().close();
        }
    }
}

