/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.transport.payload;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ByteArrayPayload
implements IDataPayload {
    byte[] payload;
    String id;
    int type;

    public ByteArrayPayload() {
    }

    public ByteArrayPayload(byte[] byArray, String string, int n) {
        this.payload = byArray;
        this.id = string;
        this.type = n;
    }

    public InputStream getPayloadStream() {
        return new ByteArrayInputStream(this.payload);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        int n = dataInputStream.readInt();
        if (n > 0) {
            this.payload = new byte[n];
            dataInputStream.read(this.payload);
        }
        this.id = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.payload.length);
        if (this.payload.length > 0) {
            dataOutputStream.write(this.payload);
        }
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.id));
    }

    public Object accept(IDataPayloadVisitor iDataPayloadVisitor) {
        return iDataPayloadVisitor.visit(this);
    }

    public String getPayloadId() {
        return this.id;
    }

    public int getPayloadType() {
        return this.type;
    }

    public long getLength() {
        return this.payload.length;
    }

    public int getTransportId() {
        return -1;
    }
}

