/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.transport.payload;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DataPointerPayload
implements IDataPayload {
    IDataPointer pointer;

    public DataPointerPayload() {
    }

    public DataPointerPayload(IDataPointer iDataPointer) {
        this.pointer = iDataPointer;
    }

    public Object accept(IDataPayloadVisitor iDataPayloadVisitor) {
        return iDataPayloadVisitor.visit(this);
    }

    public long getLength() {
        return this.pointer.getLength();
    }

    public String getPayloadId() {
        return this.pointer.getDisplayText();
    }

    public InputStream getPayloadStream() {
        return this.pointer.getDataStream();
    }

    public int getPayloadType() {
        return 2;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.pointer = (IDataPointer)ExtUtil.read(dataInputStream, new ExtWrapTagged());
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.pointer));
    }

    public int getTransportId() {
        return -1;
    }
}

