/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamsUtil {
    private StreamsUtil() {
    }

    public static void writeFromInputToOutput(InputStream inputStream, OutputStream outputStream, long[] lArray) throws IOException {
        int n = inputStream.read();
        while (n != -1) {
            outputStream.write(n);
            StreamsUtil.incr(lArray);
            n = inputStream.read();
        }
        inputStream.close();
    }

    public static void writeFromInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamsUtil.writeFromInputToOutput(inputStream, outputStream, null);
    }

    public static void writeToOutput(byte[] byArray, OutputStream outputStream, long[] lArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            outputStream.write(byArray[i]);
            StreamsUtil.incr(lArray);
        }
    }

    public static void writeToOutput(byte[] byArray, OutputStream outputStream) throws IOException {
        StreamsUtil.writeToOutput(byArray, outputStream, null);
    }

    private static void incr(long[] lArray) {
        if (lArray != null) {
            lArray[0] = lArray[0] + 1L;
        }
    }

    public static byte[] readFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray;
        if (n >= 0) {
            int n3;
            byArray = new byte[n];
            for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
            }
        } else {
            int n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n4 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n4);
            }
            byArray = byteArrayOutputStream.toByteArray();
            n2 = byArray.length;
        }
        if (n > 0 && n2 < n) {
            throw new RuntimeException("expected: " + n + " bytes but read " + n2);
        }
        return byArray;
    }
}

