/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtWrapIntEncoding;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingUniform;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtUtil {
    public static byte[] serialize(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ExtUtil.write(new DataOutputStream(byteArrayOutputStream), object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException writing to ByteArrayOutputStream; shouldn't happen!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray, Class clazz) throws DeserializationException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return ExtUtil.read(new DataInputStream(byteArrayInputStream), clazz);
        }
        catch (EOFException eOFException) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unknown IOException reading from ByteArrayInputStream; shouldn't happen!");
        }
    }

    public static Object deserialize(byte[] byArray, ExternalizableWrapper externalizableWrapper) throws DeserializationException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return ExtUtil.read(new DataInputStream(byteArrayInputStream), externalizableWrapper);
        }
        catch (EOFException eOFException) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unknown IOException reading from ByteArrayInputStream; shouldn't happen!");
        }
    }

    public static int getSize(Object object) {
        return ExtUtil.serialize(object).length;
    }

    public static PrototypeFactory defaultPrototypes() {
        return new PrototypeFactory(PrototypeManager.getPrototypes());
    }

    public static void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object instanceof Externalizable) {
            ((Externalizable)object).writeExternal(dataOutputStream);
        } else if (object instanceof Byte) {
            ExtUtil.writeNumeric(dataOutputStream, ((Byte)object).byteValue());
        } else if (object instanceof Short) {
            ExtUtil.writeNumeric(dataOutputStream, ((Short)object).shortValue());
        } else if (object instanceof Integer) {
            ExtUtil.writeNumeric(dataOutputStream, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            ExtUtil.writeNumeric(dataOutputStream, (Long)object);
        } else if (object instanceof Character) {
            ExtUtil.writeChar(dataOutputStream, ((Character)object).charValue());
        } else if (object instanceof Float) {
            ExtUtil.writeDecimal(dataOutputStream, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            ExtUtil.writeDecimal(dataOutputStream, (Double)object);
        } else if (object instanceof Boolean) {
            ExtUtil.writeBool(dataOutputStream, (Boolean)object);
        } else if (object instanceof String) {
            ExtUtil.writeString(dataOutputStream, (String)object);
        } else if (object instanceof Date) {
            ExtUtil.writeDate(dataOutputStream, (Date)object);
        } else if (object instanceof byte[]) {
            ExtUtil.writeBytes(dataOutputStream, (byte[])object);
        } else {
            throw new ClassCastException("Not a serializable datatype: " + object.getClass().getName());
        }
    }

    public static void writeNumeric(DataOutputStream dataOutputStream, long l) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, l, new ExtWrapIntEncodingUniform());
    }

    public static void writeNumeric(DataOutputStream dataOutputStream, long l, ExtWrapIntEncoding extWrapIntEncoding) throws IOException {
        ExtUtil.write(dataOutputStream, extWrapIntEncoding.clone(new Long(l)));
    }

    public static void writeChar(DataOutputStream dataOutputStream, char c) throws IOException {
        dataOutputStream.writeChar(c);
    }

    public static void writeDecimal(DataOutputStream dataOutputStream, double d) throws IOException {
        dataOutputStream.writeDouble(d);
    }

    public static void writeBool(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
    }

    public static void writeDate(DataOutputStream dataOutputStream, Date date) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, date.getTime());
    }

    public static void writeBytes(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, byArray.length);
        if (byArray.length > 0) {
            dataOutputStream.write(byArray);
        }
    }

    public static void writeInts(DataOutputStream dataOutputStream, int[] nArray) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, nArray.length);
        for (int n : nArray) {
            ExtUtil.writeNumeric(dataOutputStream, n);
        }
    }

    public static Object read(DataInputStream dataInputStream, Class clazz) throws IOException, DeserializationException {
        return ExtUtil.read(dataInputStream, clazz, null);
    }

    public static Object read(DataInputStream dataInputStream, Class clazz, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        if (Externalizable.class.isAssignableFrom(clazz)) {
            Externalizable externalizable = (Externalizable)PrototypeFactory.getInstance(clazz);
            externalizable.readExternal(dataInputStream, prototypeFactory == null ? ExtUtil.defaultPrototypes() : prototypeFactory);
            return externalizable;
        }
        if (clazz == Byte.class) {
            return new Byte(ExtUtil.readByte(dataInputStream));
        }
        if (clazz == Short.class) {
            return new Short(ExtUtil.readShort(dataInputStream));
        }
        if (clazz == Integer.class) {
            return new Integer(ExtUtil.readInt(dataInputStream));
        }
        if (clazz == Long.class) {
            return new Long(ExtUtil.readNumeric(dataInputStream));
        }
        if (clazz == Character.class) {
            return new Character(ExtUtil.readChar(dataInputStream));
        }
        if (clazz == Float.class) {
            return new Float((float)ExtUtil.readDecimal(dataInputStream));
        }
        if (clazz == Double.class) {
            return new Double(ExtUtil.readDecimal(dataInputStream));
        }
        if (clazz == Boolean.class) {
            return new Boolean(ExtUtil.readBool(dataInputStream));
        }
        if (clazz == String.class) {
            return ExtUtil.readString(dataInputStream);
        }
        if (clazz == Date.class) {
            return ExtUtil.readDate(dataInputStream);
        }
        if (clazz == byte[].class) {
            return ExtUtil.readBytes(dataInputStream);
        }
        throw new ClassCastException("Not a deserializable datatype: " + clazz.getName());
    }

    public static Object read(DataInputStream dataInputStream, ExternalizableWrapper externalizableWrapper) throws IOException, DeserializationException {
        return ExtUtil.read(dataInputStream, externalizableWrapper, null);
    }

    public static Object read(DataInputStream dataInputStream, ExternalizableWrapper externalizableWrapper, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        externalizableWrapper.readExternal(dataInputStream, prototypeFactory == null ? ExtUtil.defaultPrototypes() : prototypeFactory);
        return externalizableWrapper.val;
    }

    public static long readNumeric(DataInputStream dataInputStream) throws IOException {
        return ExtUtil.readNumeric(dataInputStream, new ExtWrapIntEncodingUniform());
    }

    public static long readNumeric(DataInputStream dataInputStream, ExtWrapIntEncoding extWrapIntEncoding) throws IOException {
        try {
            return (Long)ExtUtil.read(dataInputStream, extWrapIntEncoding);
        }
        catch (DeserializationException deserializationException) {
            throw new RuntimeException("Shouldn't happen: Base-type encoding wrappers should never touch prototypes");
        }
    }

    public static int readInt(DataInputStream dataInputStream) throws IOException {
        return ExtUtil.toInt(ExtUtil.readNumeric(dataInputStream));
    }

    public static short readShort(DataInputStream dataInputStream) throws IOException {
        return ExtUtil.toShort(ExtUtil.readNumeric(dataInputStream));
    }

    public static byte readByte(DataInputStream dataInputStream) throws IOException {
        return ExtUtil.toByte(ExtUtil.readNumeric(dataInputStream));
    }

    public static char readChar(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readChar();
    }

    public static double readDecimal(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readDouble();
    }

    public static boolean readBool(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readBoolean();
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUTF();
    }

    public static Date readDate(DataInputStream dataInputStream) throws IOException {
        return new Date(ExtUtil.readNumeric(dataInputStream));
    }

    public static byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        int n = (int)ExtUtil.readNumeric(dataInputStream);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = n;
        while (n2 != n) {
            n2 = dataInputStream.read(byArray, 0, n3);
            n3 -= n2;
        }
        return byArray;
    }

    public static int[] readInts(DataInputStream dataInputStream) throws IOException {
        int n = (int)ExtUtil.readNumeric(dataInputStream);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)ExtUtil.readNumeric(dataInputStream);
        }
        return nArray;
    }

    public static int toInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into int");
        }
        return (int)l;
    }

    public static short toShort(long l) {
        if (l < -32768L || l > 32767L) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into short");
        }
        return (short)l;
    }

    public static byte toByte(long l) {
        if (l < -128L || l > 127L) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into byte");
        }
        return (byte)l;
    }

    public static long toLong(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new ClassCastException();
    }

    public static byte[] nullIfEmpty(byte[] byArray) {
        return byArray == null ? null : (byArray.length == 0 ? null : byArray);
    }

    public static String nullIfEmpty(String string) {
        return string == null ? null : (string.length() == 0 ? null : string);
    }

    public static Vector nullIfEmpty(Vector vector) {
        return vector == null ? null : (vector.size() == 0 ? null : vector);
    }

    public static Hashtable nullIfEmpty(Hashtable hashtable) {
        return hashtable == null ? null : (hashtable.size() == 0 ? null : hashtable);
    }

    public static byte[] emptyIfNull(byte[] byArray) {
        return byArray == null ? new byte[]{} : byArray;
    }

    public static String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    public static Vector emptyIfNull(Vector vector) {
        return vector == null ? new Vector() : vector;
    }

    public static Hashtable emptyIfNull(Hashtable hashtable) {
        return hashtable == null ? new Hashtable() : hashtable;
    }

    public static Object unwrap(Object object) {
        return object instanceof ExternalizableWrapper ? ((ExternalizableWrapper)object).baseValue() : object;
    }

    public static boolean equals(Object object, Object object2) {
        object = ExtUtil.unwrap(object);
        object2 = ExtUtil.unwrap(object2);
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Vector) {
            return object2 instanceof Vector && ExtUtil.vectorEquals((Vector)object, (Vector)object2);
        }
        if (object instanceof Hashtable) {
            return object2 instanceof Hashtable && ExtUtil.hashtableEquals((Hashtable)object, (Hashtable)object2);
        }
        return object.equals(object2);
    }

    public static boolean vectorEquals(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (ExtUtil.equals(vector.elementAt(i), vector2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (ExtUtil.equals(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hashtableEquals(Hashtable hashtable, Hashtable hashtable2) {
        Object object;
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        if (hashtable instanceof OrderedHashtable != hashtable2 instanceof OrderedHashtable) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (ExtUtil.equals(hashtable.get(object), hashtable2.get(object))) continue;
            return false;
        }
        if (hashtable instanceof OrderedHashtable && hashtable2 instanceof OrderedHashtable) {
            enumeration = hashtable.keys();
            object = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object e;
                Object k = enumeration.nextElement();
                if (k.equals(e = object.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    public static String printBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i]);
            string = string.length() == 1 ? "0" + string : string.substring(string.length() - 2);
            stringBuffer.append(string);
            if (i >= byArray.length - 1) continue;
            if ((i + 1) % 30 == 0) {
                stringBuffer.append("\n ");
                continue;
            }
            if ((i + 1) % 10 == 0) {
                stringBuffer.append("  ");
                continue;
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void deserialize(byte[] byArray, Externalizable externalizable) throws IOException, DeserializationException {
        externalizable.readExternal(new DataInputStream(new ByteArrayInputStream(byArray)), ExtUtil.defaultPrototypes());
    }

    public static Object deserialize(byte[] byArray, Class clazz, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        return ExtUtil.read(new DataInputStream(new ByteArrayInputStream(byArray)), clazz, prototypeFactory);
    }
}

