/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapNullable
extends ExternalizableWrapper {
    public ExternalizableWrapper type;

    public ExtWrapNullable(Object object) {
        this.val = object;
    }

    public ExtWrapNullable() {
    }

    public ExtWrapNullable(Class clazz) {
        this.type = new ExtWrapBase(clazz);
    }

    public ExtWrapNullable(ExternalizableWrapper externalizableWrapper) {
        if (externalizableWrapper instanceof ExtWrapNullable) {
            throw new IllegalArgumentException("Wrapping nullable with nullable is redundant");
        }
        if (externalizableWrapper != null && externalizableWrapper.isEmpty()) {
            this.type = externalizableWrapper;
        } else {
            this.val = externalizableWrapper;
        }
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapNullable(object);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.val = dataInputStream.readBoolean() ? ExtUtil.read(dataInputStream, this.type, prototypeFactory) : null;
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        if (this.val != null) {
            dataOutputStream.writeBoolean(true);
            ExtUtil.write(dataOutputStream, this.val);
        } else {
            dataOutputStream.writeBoolean(false);
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.type = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtWrapTagged.writeTag(dataOutputStream, this.val == null ? new Object() : this.val);
    }
}

