/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.util.Date;
import java.util.Vector;
import org.javarosa.core.util.MD5;
import org.javarosa.core.util.PrefixTree;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.ExtWrapTagged;

public class PrototypeFactory {
    public static final int CLASS_HASH_SIZE = 4;
    private Vector classes;
    private Vector hashes;
    private PrefixTree classNames;
    private boolean initialized;

    public PrototypeFactory() {
        this(null);
    }

    public PrototypeFactory(PrefixTree prefixTree) {
        this.classNames = prefixTree;
        this.initialized = false;
    }

    private void lazyInit() {
        this.initialized = true;
        this.classes = new Vector();
        this.hashes = new Vector();
        this.addDefaultClasses();
        if (this.classNames != null) {
            Vector vector = this.classNames.getStrings();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                try {
                    this.addClass(Class.forName(string));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CannotCreateObjectException(string + ": not found");
                }
            }
            this.classNames = null;
        }
    }

    private void addDefaultClasses() {
        Class[] classArray = new Class[]{Object.class, Integer.class, Long.class, Short.class, Byte.class, Character.class, Boolean.class, Float.class, Double.class, String.class, Date.class};
        for (int i = 0; i < classArray.length; ++i) {
            this.addClass(classArray[i]);
        }
    }

    public void addClass(Class clazz) {
        byte[] byArray;
        if (!this.initialized) {
            this.lazyInit();
        }
        if (PrototypeFactory.compareHash(byArray = PrototypeFactory.getClassHash(clazz), ExtWrapTagged.WRAPPER_TAG)) {
            throw new Error("Hash collision! " + clazz.getName() + " and reserved wrapper tag");
        }
        Class clazz2 = this.getClass(byArray);
        if (clazz2 != null && clazz2 != clazz) {
            throw new Error("Hash collision! " + clazz.getName() + " and " + clazz2.getName());
        }
        this.classes.addElement(clazz);
        this.hashes.addElement(byArray);
    }

    public Class getClass(byte[] byArray) {
        if (!this.initialized) {
            this.lazyInit();
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            if (!PrototypeFactory.compareHash(byArray, (byte[])this.hashes.elementAt(i))) continue;
            return (Class)this.classes.elementAt(i);
        }
        return null;
    }

    public Object getInstance(byte[] byArray) {
        return PrototypeFactory.getInstance(this.getClass(byArray));
    }

    public static Object getInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CannotCreateObjectException(clazz.getName() + ": not accessible or no empty constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new CannotCreateObjectException(clazz.getName() + ": not instantiable");
        }
    }

    public static byte[] getClassHash(Class clazz) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = MD5.hash(clazz.getName().getBytes());
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byArray2[i];
        }
        return byArray;
    }

    public static boolean compareHash(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

