/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.formmanager.view.IQuestionWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEntryCaption
implements FormElementStateListener {
    FormDef form;
    FormIndex index;
    protected IFormElement element;
    private String textID;
    public static final String TEXT_FORM_LONG = "long";
    public static final String TEXT_FORM_SHORT = "short";
    public static final String TEXT_FORM_AUDIO = "audio";
    public static final String TEXT_FORM_IMAGE = "image";
    protected IQuestionWidget viewWidget;

    public FormEntryCaption() {
    }

    public FormEntryCaption(FormDef formDef, FormIndex formIndex) {
        this.form = formDef;
        this.index = formIndex;
        this.element = formDef.getChild(formIndex);
        this.viewWidget = null;
        this.textID = this.element.getTextID();
    }

    public String getLongText() {
        return this.getQuestionText(this.getTextID());
    }

    public String getShortText() {
        String string = this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_SHORT);
        if (string == null) {
            string = this.getLongText();
        }
        return string;
    }

    public String getAudioText() {
        return this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_AUDIO);
    }

    public String getImageText() {
        return this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_IMAGE);
    }

    public String getQuestionText(String string) {
        String string2 = string;
        if (string2 == "") {
            string2 = null;
        }
        if (string2 == null) {
            return this.substituteStringArgs(this.element.getLabelInnerText());
        }
        String string3 = this.getIText(string2, TEXT_FORM_LONG);
        if (string3 == null) {
            string3 = this.getIText(string2, null);
        }
        return this.substituteStringArgs(string3);
    }

    public String getQuestionText() {
        return this.getQuestionText(this.getTextID());
    }

    public String getSpecialFormQuestionText(String string, String string2) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string3 = this.getIText(string, string2);
        return this.substituteStringArgs(string3);
    }

    public String getSpecialFormQuestionText(String string) {
        return this.getSpecialFormQuestionText(this.getTextID(), string);
    }

    protected String getIText(String string, String string2) {
        String string3 = null;
        if (string == null || string.equals("")) {
            return null;
        }
        if (string2 != null && !string2.equals("")) {
            try {
                string3 = this.localizer().getRawText(this.localizer().getLocale(), string + ";" + string2);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                string3 = this.localizer().getRawText(this.localizer().getLocale(), string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return string3;
    }

    public String getRepeatText(String string) {
        GroupDef groupDef = (GroupDef)this.element;
        if (!groupDef.getRepeat()) {
            throw new RuntimeException("not a repeat");
        }
        String string2 = this.getLongText();
        int n = this.getNumRepetitions();
        String string3 = null;
        if ("mainheader".equals(string)) {
            string3 = groupDef.mainHeader;
            if (string3 == null) {
                return string2;
            }
        } else if ("add".equals(string)) {
            string3 = groupDef.addCaption;
            if (string3 == null) {
                return "Add another " + string2;
            }
        } else if ("add-empty".equals(string)) {
            string3 = groupDef.addEmptyCaption;
            if (string3 == null) {
                string3 = groupDef.addCaption;
            }
            if (string3 == null) {
                return "None - Add " + string2;
            }
        } else if ("del".equals(string)) {
            string3 = groupDef.delCaption;
            if (string3 == null) {
                return "Delete " + string2;
            }
        } else if ("done".equals(string)) {
            string3 = groupDef.doneCaption;
            if (string3 == null) {
                return "Done";
            }
        } else if ("done-empty".equals(string)) {
            string3 = groupDef.doneEmptyCaption;
            if (string3 == null) {
                string3 = groupDef.doneCaption;
            }
            if (string3 == null) {
                return "Skip";
            }
        } else if ("delheader".equals(string) && (string3 = groupDef.delHeader) == null) {
            return "Delete which " + string2 + "?";
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", string2);
        hashtable.put("n", new Integer(n));
        return this.form.fillTemplateString(string3, this.index.getReference(), hashtable);
    }

    public int getNumRepetitions() {
        return this.form.getNumRepetitions(this.index);
    }

    public String getRepetitionText(boolean bl) {
        return this.getRepetitionText("header", this.index, bl);
    }

    private String getRepetitionText(String string, FormIndex formIndex, boolean bl) {
        if (this.element instanceof GroupDef && ((GroupDef)this.element).getRepeat() && formIndex.getElementMultiplicity() >= 0) {
            GroupDef groupDef = (GroupDef)this.element;
            String string2 = this.getLongText();
            int n = formIndex.getElementMultiplicity() + 1;
            int n2 = this.getNumRepetitions();
            String string3 = null;
            if ("header".equals(string)) {
                string3 = groupDef.entryHeader;
            } else if ("choose".equals(string) && (string3 = groupDef.chooseCaption) == null) {
                string3 = groupDef.entryHeader;
            }
            if (string3 == null) {
                return string2 + " " + n + "/" + n2;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string2);
            hashtable.put("i", new Integer(n));
            hashtable.put("n", new Integer(n2));
            hashtable.put("new", new Boolean(bl));
            return this.form.fillTemplateString(string3, formIndex.getReference(), hashtable);
        }
        return null;
    }

    public Vector<String> getRepetitionsText() {
        GroupDef groupDef = (GroupDef)this.element;
        if (!groupDef.getRepeat()) {
            throw new RuntimeException("not a repeat");
        }
        int n = this.getNumRepetitions();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.getRepetitionText("choose", this.form.descendIntoRepeat(this.index, i), false));
        }
        return vector;
    }

    public RepeatOptions getRepeatOptions() {
        RepeatOptions repeatOptions = new RepeatOptions();
        boolean bl = this.getNumRepetitions() > 0;
        repeatOptions.header = this.getRepeatText("mainheader");
        repeatOptions.add = null;
        if (this.form.canCreateRepeat(this.form.getChildInstanceRef(this.index))) {
            repeatOptions.add = this.getRepeatText(bl ? "add" : "add-empty");
        }
        repeatOptions.delete = null;
        repeatOptions.delete_header = null;
        if (bl) {
            repeatOptions.delete = this.getRepeatText("del");
            repeatOptions.delete_header = this.getRepeatText("delheader");
        }
        repeatOptions.done = this.getRepeatText(bl ? "done" : "done-empty");
        return repeatOptions;
    }

    public String getAppearanceHint() {
        return this.element.getAppearanceAttr();
    }

    protected String substituteStringArgs(String string) {
        if (string == null) {
            return null;
        }
        return this.form.fillTemplateString(string, this.index.getReference());
    }

    public int getMultiplicity() {
        return this.index.getElementMultiplicity();
    }

    public IFormElement getFormElement() {
        return this.element;
    }

    public boolean repeats() {
        if (this.element instanceof GroupDef) {
            return ((GroupDef)this.element).getRepeat();
        }
        return false;
    }

    public FormIndex getIndex() {
        return this.index;
    }

    protected Localizer localizer() {
        return this.form.getLocalizer();
    }

    public void register(IQuestionWidget iQuestionWidget) {
        this.viewWidget = iQuestionWidget;
        this.element.registerStateObserver(this);
    }

    public void unregister() {
        this.viewWidget = null;
        this.element.unregisterStateObserver(this);
    }

    @Override
    public void formElementStateChanged(IFormElement iFormElement, int n) {
        if (this.element != iFormElement) {
            throw new IllegalStateException("Widget received event from foreign question");
        }
        if (this.viewWidget != null) {
            this.viewWidget.refreshWidget(n);
        }
    }

    @Override
    public void formElementStateChanged(TreeElement treeElement, int n) {
        throw new RuntimeException("cannot happen");
    }

    protected String getTextID() {
        return this.textID;
    }

    public class RepeatOptions {
        public String header;
        public String add;
        public String delete;
        public String done;
        public String delete_header;
    }
}

