/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.form.api.FormEntryModel;

public class FormEntryController {
    public static final int ANSWER_OK = 0;
    public static final int ANSWER_REQUIRED_BUT_EMPTY = 1;
    public static final int ANSWER_CONSTRAINT_VIOLATED = 2;
    public static final int EVENT_BEGINNING_OF_FORM = 0;
    public static final int EVENT_END_OF_FORM = 1;
    public static final int EVENT_PROMPT_NEW_REPEAT = 2;
    public static final int EVENT_QUESTION = 4;
    public static final int EVENT_GROUP = 8;
    public static final int EVENT_REPEAT = 16;
    public static final int EVENT_REPEAT_JUNCTURE = 32;
    FormEntryModel model;

    public FormEntryController(FormEntryModel formEntryModel) {
        this.model = formEntryModel;
    }

    public FormEntryModel getModel() {
        return this.model;
    }

    public int answerQuestion(IAnswerData iAnswerData) {
        return this.answerQuestion(this.model.getFormIndex(), iAnswerData);
    }

    public int answerQuestion(FormIndex formIndex, IAnswerData iAnswerData) {
        QuestionDef questionDef = this.model.getQuestionPrompt(formIndex).getQuestion();
        if (this.model.getEvent(formIndex) != 4) {
            throw new RuntimeException("Non-Question object at the form index.");
        }
        TreeElement treeElement = this.model.getTreeElement(formIndex);
        boolean bl = questionDef.isComplex();
        boolean bl2 = false;
        if (treeElement.required && iAnswerData == null) {
            return 1;
        }
        if (!bl && !this.model.getForm().evaluateConstraint(formIndex.getReference(), iAnswerData)) {
            return 2;
        }
        if (!bl) {
            this.commitAnswer(treeElement, formIndex, iAnswerData);
            return 0;
        }
        if (bl && bl2) {
            throw new RuntimeException("Itemsets do not currently evaluate constraints. Your constraint will not work, please remove it before proceeding.");
        }
        try {
            this.model.getForm().copyItemsetAnswer(questionDef, treeElement, iAnswerData);
        }
        catch (InvalidReferenceException invalidReferenceException) {
            invalidReferenceException.printStackTrace();
            throw new RuntimeException("Invalid reference while copying itemset answer: " + invalidReferenceException.getMessage());
        }
        return 0;
    }

    public boolean saveAnswer(FormIndex formIndex, IAnswerData iAnswerData) {
        if (this.model.getEvent(formIndex) != 4) {
            throw new RuntimeException("Non-Question object at the form index.");
        }
        TreeElement treeElement = this.model.getTreeElement(formIndex);
        return this.commitAnswer(treeElement, formIndex, iAnswerData);
    }

    public boolean saveAnswer(IAnswerData iAnswerData) {
        return this.saveAnswer(this.model.getFormIndex(), iAnswerData);
    }

    private boolean commitAnswer(TreeElement treeElement, FormIndex formIndex, IAnswerData iAnswerData) {
        if (iAnswerData != null || treeElement.getValue() != null) {
            this.model.getForm().setValue(iAnswerData, formIndex.getReference(), treeElement);
            return true;
        }
        return false;
    }

    public int stepToNextEvent() {
        return this.stepEvent(true);
    }

    public int stepToPreviousEvent() {
        return this.stepEvent(false);
    }

    private int stepEvent(boolean bl) {
        FormIndex formIndex = this.model.getFormIndex();
        while ((formIndex = bl ? this.model.incrementIndex(formIndex) : this.model.decrementIndex(formIndex)).isInForm() && !this.model.isIndexRelevant(formIndex)) {
        }
        return this.jumpToIndex(formIndex);
    }

    public int jumpToIndex(FormIndex formIndex) {
        this.model.setQuestionIndex(formIndex);
        return this.model.getEvent(formIndex);
    }

    public FormIndex descendIntoRepeat(int n) {
        this.jumpToIndex(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), n));
        return this.model.getFormIndex();
    }

    public FormIndex descendIntoNewRepeat() {
        this.jumpToIndex(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), -1));
        this.newRepeat(this.model.getFormIndex());
        return this.model.getFormIndex();
    }

    public void newRepeat(FormIndex formIndex) {
        try {
            this.model.getForm().createNewRepeat(formIndex);
        }
        catch (InvalidReferenceException invalidReferenceException) {
            throw new RuntimeException("Invalid reference while copying itemset answer: " + invalidReferenceException.getMessage());
        }
    }

    public void newRepeat() {
        this.newRepeat(this.model.getFormIndex());
    }

    public FormIndex deleteRepeat(FormIndex formIndex) {
        return this.model.getForm().deleteRepeat(formIndex);
    }

    public FormIndex deleteRepeat() {
        return this.deleteRepeat(this.model.getFormIndex());
    }

    public void deleteRepeat(int n) {
        this.deleteRepeat(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), n));
    }

    public void setLanguage(String string) {
        this.model.setLanguage(string);
    }
}

