/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.form.api.FormEntryCaption;
import org.javarosa.form.api.FormEntryPrompt;

public class FormEntryModel {
    private FormDef form;
    private FormIndex currentFormIndex;
    private int repeatStructure = -1;
    public static final int REPEAT_STRUCTURE_LINEAR = 1;
    public static final int REPEAT_STRUCTURE_NON_LINEAR = 2;

    public FormEntryModel(FormDef formDef) {
        this(formDef, 1);
    }

    public FormEntryModel(FormDef formDef, int n) {
        this.form = formDef;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(n + ": does not correspond to a valid repeat structure");
        }
        this.repeatStructure = n;
        this.currentFormIndex = FormIndex.createBeginningOfFormIndex();
    }

    public int getEvent(FormIndex formIndex) {
        if (formIndex.isBeginningOfFormIndex()) {
            return 0;
        }
        if (formIndex.isEndOfFormIndex()) {
            return 1;
        }
        IFormElement iFormElement = this.form.getChild(formIndex);
        if (iFormElement instanceof GroupDef) {
            if (((GroupDef)iFormElement).getRepeat()) {
                if (this.repeatStructure != 2 && this.form.getInstance().resolveReference(this.form.getChildInstanceRef(formIndex)) == null) {
                    return 2;
                }
                if (this.repeatStructure == 2 && formIndex.getElementMultiplicity() == -10) {
                    return 32;
                }
                return 16;
            }
            return 8;
        }
        return 4;
    }

    protected TreeElement getTreeElement(FormIndex formIndex) {
        return this.form.getInstance().resolveReference(formIndex.getReference());
    }

    public int getEvent() {
        return this.getEvent(this.currentFormIndex);
    }

    public String getFormTitle() {
        return this.form.getTitle();
    }

    public FormEntryPrompt getQuestionPrompt(FormIndex formIndex) {
        if (this.form.getChild(formIndex) instanceof QuestionDef) {
            return new FormEntryPrompt(this.form, formIndex);
        }
        throw new RuntimeException("Invalid query for Question prompt. Non-Question object at the form index");
    }

    public FormEntryPrompt getQuestionPrompt() {
        return this.getQuestionPrompt(this.currentFormIndex);
    }

    public FormEntryCaption getCaptionPrompt(FormIndex formIndex) {
        return new FormEntryCaption(this.form, formIndex);
    }

    public FormEntryCaption getCaptionPrompt() {
        return this.getCaptionPrompt(this.currentFormIndex);
    }

    public String[] getLanguages() {
        if (this.form.getLocalizer() != null) {
            return this.form.getLocalizer().getAvailableLocales();
        }
        return null;
    }

    public int getCompletedRelevantQuestionCount() {
        return 0;
    }

    public int getTotalRelevantQuestionCount() {
        return 0;
    }

    public int getNumQuestions() {
        return this.form.getDeepChildCount();
    }

    public FormIndex getFormIndex() {
        return this.currentFormIndex;
    }

    protected void setLanguage(String string) {
        if (this.form.getLocalizer() != null) {
            this.form.getLocalizer().setLocale(string);
        }
    }

    public String getLanguage() {
        return this.form.getLocalizer().getLocale();
    }

    public void setQuestionIndex(FormIndex formIndex) {
        if (!this.currentFormIndex.equals(formIndex)) {
            this.createModelIfNecessary(formIndex);
            this.currentFormIndex = formIndex;
        }
    }

    public FormDef getForm() {
        return this.form;
    }

    public FormEntryCaption[] getCaptionHierarchy(FormIndex formIndex) {
        Object object;
        Vector<FormEntryCaption> vector = new Vector<FormEntryCaption>();
        FormIndex formIndex2 = formIndex;
        while (formIndex2 != null) {
            object = formIndex.diff(formIndex2 = formIndex2.getNextLevel());
            IFormElement iFormElement = this.form.getChild((FormIndex)object);
            if (iFormElement == null) continue;
            FormEntryCaption formEntryCaption = null;
            if (iFormElement instanceof GroupDef) {
                formEntryCaption = new FormEntryCaption(this.getForm(), (FormIndex)object);
            } else if (iFormElement instanceof QuestionDef) {
                formEntryCaption = new FormEntryPrompt(this.getForm(), (FormIndex)object);
            }
            if (formEntryCaption == null) continue;
            vector.addElement(formEntryCaption);
        }
        object = new FormEntryCaption[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public FormEntryCaption[] getCaptionHierarchy() {
        return this.getCaptionHierarchy(this.currentFormIndex);
    }

    public boolean isIndexReadonly(FormIndex formIndex) {
        boolean bl;
        if (formIndex.isBeginningOfFormIndex() || formIndex.isEndOfFormIndex()) {
            return true;
        }
        TreeReference treeReference = this.form.getChildInstanceRef(formIndex);
        boolean bl2 = bl = this.getEvent(formIndex) == 2 || this.getEvent(formIndex) == 32;
        if (bl) {
            return false;
        }
        TreeElement treeElement = this.form.getInstance().resolveReference(treeReference);
        return !treeElement.isEnabled();
    }

    public boolean isIndexReadonly() {
        return this.isIndexReadonly(this.currentFormIndex);
    }

    public boolean isIndexRelevant(FormIndex formIndex) {
        Object object;
        boolean bl;
        boolean bl2;
        TreeReference treeReference = this.form.getChildInstanceRef(formIndex);
        boolean bl3 = this.getEvent(formIndex) == 2;
        boolean bl4 = bl2 = this.getEvent(formIndex) == 32;
        if (bl3) {
            bl = this.form.isRepeatRelevant(treeReference) && this.form.canCreateRepeat(treeReference);
        } else if (bl2) {
            bl = this.form.isRepeatRelevant(treeReference);
        } else {
            object = this.form.getInstance().resolveReference(treeReference);
            bl = ((TreeElement)object).isRelevant();
        }
        if (bl) {
            object = formIndex;
            while (!((FormIndex)object).isTerminal()) {
                TreeElement treeElement = this.form.getInstance().resolveReference(((FormIndex)object).getLocalReference());
                if (!treeElement.isRelevant()) {
                    bl = false;
                    break;
                }
                object = ((FormIndex)object).getNextLevel();
            }
        }
        return bl;
    }

    public boolean isIndexRelevant() {
        return this.isIndexRelevant(this.currentFormIndex);
    }

    private void createModelIfNecessary(FormIndex formIndex) {
        IAnswerData iAnswerData;
        GroupDef groupDef;
        IFormElement iFormElement;
        if (formIndex.isInForm() && (iFormElement = this.getForm().getChild(formIndex)) instanceof GroupDef && (groupDef = (GroupDef)iFormElement).getRepeat() && groupDef.getCountReference() != null && (iAnswerData = this.getForm().getInstance().getDataValue(groupDef.getCountReference())) != null) {
            int n = (Integer)iAnswerData.getValue();
            TreeReference treeReference = this.getForm().getChildInstanceRef(formIndex);
            TreeElement treeElement = this.getForm().getInstance().resolveReference(treeReference);
            if (treeElement == null && formIndex.getInstanceIndex() < n) {
                try {
                    this.getForm().createNewRepeat(formIndex);
                }
                catch (InvalidReferenceException invalidReferenceException) {
                    invalidReferenceException.printStackTrace();
                    throw new RuntimeException("Invalid Reference while creting new repeat!" + invalidReferenceException.getMessage());
                }
            }
        }
    }

    public boolean isIndexCompoundContainer() {
        return this.isIndexCompoundContainer(this.getFormIndex());
    }

    public boolean isIndexCompoundContainer(FormIndex formIndex) {
        FormEntryCaption formEntryCaption = this.getCaptionPrompt(formIndex);
        return this.getEvent(formIndex) == 8 && formEntryCaption.getAppearanceHint() != null && formEntryCaption.getAppearanceHint().toLowerCase().equals("full");
    }

    public boolean isIndexCompoundElement() {
        return this.isIndexCompoundElement(this.getFormIndex());
    }

    public boolean isIndexCompoundElement(FormIndex formIndex) {
        FormEntryCaption[] formEntryCaptionArray;
        if (this.getEvent(formIndex) != 4) {
            return false;
        }
        for (FormEntryCaption formEntryCaption : formEntryCaptionArray = this.getCaptionHierarchy(formIndex)) {
            if (!this.isIndexCompoundContainer(formEntryCaption.getIndex())) continue;
            return true;
        }
        return false;
    }

    public FormIndex[] getCompoundIndices() {
        return this.getCompoundIndices(this.getFormIndex());
    }

    public FormIndex[] getCompoundIndices(FormIndex formIndex) {
        Vector<FormIndex> vector = new Vector<FormIndex>();
        FormIndex formIndex2 = this.incrementIndex(formIndex);
        while (FormIndex.isSubElement(formIndex, formIndex2)) {
            if (this.isIndexRelevant(formIndex2)) {
                vector.addElement(formIndex2);
            }
            formIndex2 = this.incrementIndex(formIndex2);
        }
        FormIndex[] formIndexArray = new FormIndex[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            formIndexArray[i] = (FormIndex)vector.elementAt(i);
        }
        return formIndexArray;
    }

    public int getRepeatStructure() {
        return this.repeatStructure;
    }

    public FormIndex incrementIndex(FormIndex formIndex) {
        return this.incrementIndex(formIndex, true);
    }

    public FormIndex incrementIndex(FormIndex formIndex, boolean bl) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (formIndex.isEndOfFormIndex()) {
            return formIndex;
        }
        if (formIndex.isBeginningOfFormIndex()) {
            if (this.form.getChildren() == null || this.form.getChildren().size() == 0) {
                return FormIndex.createEndOfFormIndex();
            }
        } else {
            this.form.collapseIndex(formIndex, vector, vector2, vector3);
        }
        this.incrementHelper(vector, vector2, vector3, bl);
        if (vector.size() == 0) {
            return FormIndex.createEndOfFormIndex();
        }
        return this.form.buildIndex(vector, vector2, vector3);
    }

    private void incrementHelper(Vector vector, Vector vector2, Vector vector3, boolean bl) {
        IFormElement iFormElement;
        int n = vector.size() - 1;
        boolean bl2 = false;
        if (n == -1 || vector3.elementAt(n) instanceof GroupDef) {
            if (n >= 0 && ((GroupDef)(iFormElement = (GroupDef)vector3.elementAt(n))).getRepeat()) {
                if (this.repeatStructure == 2) {
                    if ((Integer)vector2.lastElement() == -10) {
                        bl = false;
                        bl2 = true;
                    }
                } else if (this.form.getInstance().resolveReference(this.form.getChildInstanceRef(vector3, vector2)) == null) {
                    bl = false;
                    bl2 = true;
                }
            }
            if (bl) {
                vector.addElement(new Integer(0));
                vector2.addElement(new Integer(0));
                vector3.addElement((n == -1 ? this.form : (IFormElement)vector3.elementAt(n)).getChild(0));
                if (this.repeatStructure == 2 && vector3.lastElement() instanceof GroupDef && ((GroupDef)vector3.lastElement()).getRepeat()) {
                    vector2.setElementAt(new Integer(-10), vector2.size() - 1);
                }
                return;
            }
        }
        while (n >= 0) {
            if (!bl2 && vector3.elementAt(n) instanceof GroupDef && ((GroupDef)vector3.elementAt(n)).getRepeat()) {
                if (this.repeatStructure == 2) {
                    vector2.setElementAt(new Integer(-10), n);
                } else {
                    vector2.setElementAt(new Integer((Integer)vector2.elementAt(n) + 1), n);
                }
                return;
            }
            iFormElement = n == 0 ? this.form : (IFormElement)vector3.elementAt(n - 1);
            int n2 = (Integer)vector.elementAt(n);
            if (n2 + 1 >= iFormElement.getChildren().size()) {
                vector.removeElementAt(n);
                vector2.removeElementAt(n);
                vector3.removeElementAt(n);
                --n;
                bl2 = false;
                continue;
            }
            vector.setElementAt(new Integer(n2 + 1), n);
            vector2.setElementAt(new Integer(0), n);
            vector3.setElementAt(iFormElement.getChild(n2 + 1), n);
            if (this.repeatStructure == 2 && vector3.lastElement() instanceof GroupDef && ((GroupDef)vector3.lastElement()).getRepeat()) {
                vector2.setElementAt(new Integer(-10), vector2.size() - 1);
            }
            return;
        }
    }

    public FormIndex decrementIndex(FormIndex formIndex) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (formIndex.isBeginningOfFormIndex()) {
            return formIndex;
        }
        if (formIndex.isEndOfFormIndex()) {
            if (this.form.getChildren() == null || this.form.getChildren().size() == 0) {
                return FormIndex.createBeginningOfFormIndex();
            }
        } else {
            this.form.collapseIndex(formIndex, vector, vector2, vector3);
        }
        this.decrementHelper(vector, vector2, vector3);
        if (vector.size() == 0) {
            return FormIndex.createBeginningOfFormIndex();
        }
        return this.form.buildIndex(vector, vector2, vector3);
    }

    private void decrementHelper(Vector vector, Vector vector2, Vector vector3) {
        IFormElement iFormElement;
        int n;
        int n2 = vector.size() - 1;
        if (n2 != -1) {
            int n3 = (Integer)vector.elementAt(n2);
            n = (Integer)vector2.elementAt(n2);
            if (this.repeatStructure == 2 && vector3.lastElement() instanceof GroupDef && ((GroupDef)vector3.lastElement()).getRepeat() && (Integer)vector2.lastElement() != -10) {
                vector2.setElementAt(new Integer(-10), n2);
                return;
            }
            if (this.repeatStructure != 2 && n > 0) {
                vector2.setElementAt(new Integer(n - 1), n2);
            } else if (n3 > 0) {
                vector.setElementAt(new Integer(n3 - 1), n2);
                vector2.setElementAt(new Integer(0), n2);
                vector3.setElementAt((n2 == 0 ? this.form : (IFormElement)vector3.elementAt(n2 - 1)).getChild(n3 - 1), n2);
                if (this.setRepeatNextMultiplicity(vector3, vector2)) {
                    return;
                }
            } else {
                vector.removeElementAt(n2);
                vector2.removeElementAt(n2);
                vector3.removeElementAt(n2);
                return;
            }
        }
        IFormElement iFormElement2 = iFormElement = n2 < 0 ? this.form : (IFormElement)vector3.elementAt(n2);
        while (!(iFormElement instanceof QuestionDef)) {
            n = iFormElement.getChildren().size() - 1;
            iFormElement = iFormElement.getChild(n);
            vector.addElement(new Integer(n));
            vector2.addElement(new Integer(0));
            vector3.addElement(iFormElement);
            if (!this.setRepeatNextMultiplicity(vector3, vector2)) continue;
            return;
        }
    }

    private boolean setRepeatNextMultiplicity(Vector vector, Vector vector2) {
        TreeReference treeReference = this.form.getChildInstanceRef(vector, vector2);
        TreeElement treeElement = this.form.getInstance().resolveReference(treeReference);
        if (treeElement == null || treeElement.repeatable) {
            int n;
            if (treeElement == null) {
                n = 0;
            } else {
                String string = treeElement.getName();
                TreeElement treeElement2 = this.form.getInstance().resolveReference(treeReference.getParentRef());
                n = treeElement2.getChildMultiplicity(string);
            }
            vector2.setElementAt(new Integer(this.repeatStructure == 2 ? -10 : n), vector2.size() - 1);
            return true;
        }
        return false;
    }
}

