/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.kxml2.kdom.Element;

public class SMSSerializingVisitor
implements IInstanceSerializingVisitor {
    private String theSmsStr = null;
    private String nodeSet = null;
    private String xmlns = null;
    private String delimeter = null;
    private String prefix = null;
    private String method = null;
    private TreeReference rootRef;
    IAnswerDataSerializer serializer;
    FormDef schema;
    Vector dataPointers;

    private void init() {
        this.theSmsStr = null;
        this.schema = null;
        this.dataPointers = new Vector();
        this.theSmsStr = "";
    }

    public byte[] serializeInstance(FormInstance formInstance, FormDef formDef) throws IOException {
        this.init();
        this.schema = formDef;
        return this.serializeInstance(formInstance);
    }

    public byte[] serializeInstance(FormInstance formInstance) throws IOException {
        return this.serializeInstance(formInstance, new XPathReference("/"));
    }

    public byte[] serializeInstance(FormInstance formInstance, IDataReference iDataReference) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(iDataReference);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        formInstance.accept(this);
        if (this.theSmsStr != null) {
            return this.theSmsStr.getBytes("UTF-8");
        }
        return null;
    }

    public IDataPayload createSerializedPayload(FormInstance formInstance) throws IOException {
        return this.createSerializedPayload(formInstance, new XPathReference("/"));
    }

    public IDataPayload createSerializedPayload(FormInstance formInstance, IDataReference iDataReference) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(iDataReference);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        formInstance.accept(this);
        if (this.theSmsStr != null) {
            byte[] byArray = this.theSmsStr.getBytes("UTF-8");
            return new ByteArrayPayload(byArray, null, 5);
        }
        return null;
    }

    public void visit(FormInstance formInstance) {
        this.nodeSet = new String();
        TreeElement treeElement = formInstance.resolveReference(this.rootRef);
        this.xmlns = treeElement.getAttributeValue("", "xmlns");
        this.delimeter = treeElement.getAttributeValue("", "delimeter");
        this.prefix = treeElement.getAttributeValue("", "prefix");
        this.xmlns = this.xmlns != null ? this.xmlns : " ";
        this.delimeter = this.delimeter != null ? this.delimeter : " ";
        this.theSmsStr = this.prefix = this.prefix != null ? this.prefix : " ";
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            TreeElement treeElement2 = treeElement.getChildAt(i);
            String string = this.serializeNode(treeElement2);
            if (string == null) continue;
            this.theSmsStr = this.theSmsStr + string;
        }
        this.theSmsStr = this.theSmsStr.trim();
    }

    public String serializeNode(TreeElement treeElement) {
        String string = "";
        if (!treeElement.isRelevant() || treeElement.getMult() == -2) {
            return null;
        }
        if (treeElement.getValue() != null) {
            IDataPointer[] iDataPointerArray;
            Object object = this.serializer.serializeAnswerData(treeElement.getValue(), treeElement.dataType);
            if (object instanceof Element) {
                throw new RuntimeException("Can't handle serialized output for" + treeElement.getValue().toString() + ", " + object);
            }
            if (object instanceof String) {
                iDataPointerArray = new Element();
                iDataPointerArray.addChild(4, (String)object);
                String string2 = treeElement.getAttributeValue("", "tag");
                string = string + (string2 != null ? string2 + this.delimeter : this.delimeter);
                for (int i = 0; i < iDataPointerArray.getChildCount(); ++i) {
                    string = string + iDataPointerArray.getChild(i).toString() + this.delimeter;
                }
            } else {
                throw new RuntimeException("Can't handle serialized output for" + treeElement.getValue().toString() + ", " + object);
            }
            if (this.serializer.containsExternalData(treeElement.getValue()).booleanValue()) {
                iDataPointerArray = this.serializer.retrieveExternalDataPointer(treeElement.getValue());
                for (int i = 0; i < iDataPointerArray.length; ++i) {
                    this.dataPointers.addElement(iDataPointerArray[i]);
                }
            }
        }
        return string;
    }

    public void setAnswerDataSerializer(IAnswerDataSerializer iAnswerDataSerializer) {
        this.serializer = iAnswerDataSerializer;
    }

    public IInstanceSerializingVisitor newInstance() {
        XFormSerializingVisitor xFormSerializingVisitor = new XFormSerializingVisitor();
        xFormSerializingVisitor.setAnswerDataSerializer(this.serializer);
        return xFormSerializingVisitor;
    }
}

