/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import org.javarosa.core.api.IModule;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.IXFormyFactory;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormAnswerDataParser;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathPathExpr;

public class XFormsModule
implements IModule {
    public void registerModule() {
        String[] stringArray = new String[]{"org.javarosa.model.xform.XPathReference", "org.javarosa.xpath.XPathConditional"};
        PrototypeManager.registerPrototypes(stringArray);
        PrototypeManager.registerPrototypes(XPathParseTool.xpathClasses);
        RestoreUtils.xfFact = new IXFormyFactory(){

            public TreeReference ref(String string) {
                return FormInstance.unpackReference(new XPathReference(string));
            }

            public IDataPayload serializeInstance(FormInstance formInstance) {
                try {
                    return new XFormSerializingVisitor().createSerializedPayload(formInstance);
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            public FormInstance parseRestore(byte[] byArray, Class clazz) {
                return XFormParser.restoreDataModel(byArray, clazz);
            }

            public IAnswerData parseData(String string, int n, TreeReference treeReference, FormDef formDef) {
                return XFormAnswerDataParser.getAnswerData(string, n, XFormParser.ghettoGetQuestionDef(n, formDef, treeReference));
            }

            public String serializeData(IAnswerData iAnswerData) {
                return (String)new XFormAnswerDataSerializer().serializeAnswerData(iAnswerData);
            }

            public IConditionExpr refToPathExpr(TreeReference treeReference) {
                return new XPathConditional(XPathPathExpr.fromRef(treeReference));
            }
        };
    }
}

