/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.model.DataBinding;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.SubmissionProfile;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.Restorable;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.locale.TableLocaleSource;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.core.util.externalizable.PrototypeFactoryDeprecated;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.IElementHandler;
import org.javarosa.xform.parse.SubmissionParser;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.util.IXFormBindHandler;
import org.javarosa.xform.util.XFormAnswerDataParser;
import org.javarosa.xform.util.XFormSerializer;
import org.javarosa.xform.util.XFormUtils;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.kxml2.io.KXmlParser;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFormParser {
    private static final String ID_ATTR = "id";
    private static final String FORM_ATTR = "form";
    private static final String APPEARANCE_ATTR = "appearance";
    private static final String NODESET_ATTR = "nodeset";
    private static final String LABEL_ELEMENT = "label";
    private static final String VALUE = "value";
    private static final String ITEXT_CLOSE = "')";
    private static final String ITEXT_OPEN = "jr:itext('";
    private static final String BIND_ATTR = "bind";
    private static final String REF_ATTR = "ref";
    private static final String SELECTONE = "select1";
    private static final String SELECT = "select";
    public static final String NAMESPACE_JAVAROSA = "http://openrosa.org/javarosa";
    public static final String NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
    private static Hashtable topLevelHandlers;
    private static Hashtable groupLevelHandlers;
    private static Hashtable typeMappings;
    private static PrototypeFactoryDeprecated modelPrototypes;
    private static Vector bindHandlers;
    private static boolean modelFound;
    private static Hashtable bindingsByID;
    private static Vector bindings;
    private static Vector repeats;
    private static Vector itemsets;
    private static Vector selectOnes;
    private static Vector selectMultis;
    private static Vector<SubmissionParser> submissionParsers;
    private static Element instanceNode;
    private static String defaultNamespace;
    private static FormInstance repeatTree;
    private static final int CONTAINER_GROUP = 1;
    private static final int CONTAINER_REPEAT = 2;
    private static int serialQuestionID;
    private static String[] guesses;

    private static void initProcessingRules() {
        IElementHandler iElementHandler = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseTitle(formDef, element);
            }
        };
        IElementHandler iElementHandler2 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseMeta(formDef, element);
            }
        };
        IElementHandler iElementHandler3 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseModel(formDef, element);
            }
        };
        IElementHandler iElementHandler4 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, 1);
            }
        };
        IElementHandler iElementHandler5 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, 5);
            }
        };
        IElementHandler iElementHandler6 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, 3);
            }
        };
        IElementHandler iElementHandler7 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, 2);
            }
        };
        IElementHandler iElementHandler8 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseGroup((IFormElement)object, element, formDef, 1);
            }
        };
        IElementHandler iElementHandler9 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseGroup((IFormElement)object, element, formDef, 2);
            }
        };
        IElementHandler iElementHandler10 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseGroupLabel(formDef, (GroupDef)object, element);
            }
        };
        IElementHandler iElementHandler11 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, 9);
            }
        };
        IElementHandler iElementHandler12 = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseUpload((IFormElement)object, element, formDef, 7);
            }
        };
        groupLevelHandlers = new Hashtable();
        groupLevelHandlers.put("input", iElementHandler4);
        groupLevelHandlers.put("secret", iElementHandler5);
        groupLevelHandlers.put(SELECT, iElementHandler6);
        groupLevelHandlers.put(SELECTONE, iElementHandler7);
        groupLevelHandlers.put("group", iElementHandler8);
        groupLevelHandlers.put("repeat", iElementHandler9);
        groupLevelHandlers.put("trigger", iElementHandler11);
        groupLevelHandlers.put("upload", iElementHandler12);
        topLevelHandlers = new Hashtable();
        Enumeration enumeration = groupLevelHandlers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            topLevelHandlers.put(string, groupLevelHandlers.get(string));
        }
        topLevelHandlers.put("model", iElementHandler3);
        topLevelHandlers.put("title", iElementHandler);
        topLevelHandlers.put("meta", iElementHandler2);
        groupLevelHandlers.put(LABEL_ELEMENT, iElementHandler10);
    }

    private static void initTypeMappings() {
        typeMappings = new Hashtable();
        typeMappings.put("string", new Integer(1));
        typeMappings.put("integer", new Integer(2));
        typeMappings.put("int", new Integer(2));
        typeMappings.put("decimal", new Integer(3));
        typeMappings.put("double", new Integer(3));
        typeMappings.put("float", new Integer(3));
        typeMappings.put("dateTime", new Integer(6));
        typeMappings.put("date", new Integer(4));
        typeMappings.put("time", new Integer(5));
        typeMappings.put("gYear", new Integer(-1));
        typeMappings.put("gMonth", new Integer(-1));
        typeMappings.put("gDay", new Integer(-1));
        typeMappings.put("gYearMonth", new Integer(-1));
        typeMappings.put("gMonthDay", new Integer(-1));
        typeMappings.put("boolean", new Integer(9));
        typeMappings.put("base64Binary", new Integer(-1));
        typeMappings.put("hexBinary", new Integer(-1));
        typeMappings.put("anyURI", new Integer(-1));
        typeMappings.put("listItem", new Integer(7));
        typeMappings.put("listItems", new Integer(8));
        typeMappings.put(SELECTONE, new Integer(7));
        typeMappings.put(SELECT, new Integer(8));
        typeMappings.put("geopoint", new Integer(10));
        typeMappings.put("barcode", new Integer(11));
        typeMappings.put("binary", new Integer(12));
    }

    private static void initBindHandlers() {
        Enumeration enumeration = bindHandlers.elements();
        while (enumeration.hasMoreElements()) {
            IXFormBindHandler iXFormBindHandler = (IXFormBindHandler)enumeration.nextElement();
            iXFormBindHandler.init();
        }
    }

    private static void processBindHandlers(FormDef formDef) {
        Enumeration enumeration = bindHandlers.elements();
        while (enumeration.hasMoreElements()) {
            IXFormBindHandler iXFormBindHandler = (IXFormBindHandler)enumeration.nextElement();
            iXFormBindHandler.postProcess(formDef);
        }
    }

    private static void initStateVars() {
        modelFound = false;
        bindingsByID = new Hashtable();
        bindings = new Vector();
        repeats = new Vector();
        itemsets = new Vector();
        selectOnes = new Vector();
        selectMultis = new Vector();
        instanceNode = null;
        repeatTree = null;
        defaultNamespace = null;
    }

    public static FormDef getFormDef(Reader reader) {
        System.out.println("Parsing form...");
        Document document = XFormParser.getXMLDocument(reader);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing reader");
            iOException.printStackTrace();
        }
        return XFormParser.getFormDef(document);
    }

    public static Document getXMLDocument(Reader reader) {
        Document document = new Document();
        try {
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setInput(reader);
            kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            document.parse(kXmlParser);
        }
        catch (XmlPullParserException xmlPullParserException) {
            String string = "XML Syntax Error at Line: " + xmlPullParserException.getLineNumber() + ", Column: " + xmlPullParserException.getColumnNumber() + "!";
            System.err.println(string);
            xmlPullParserException.printStackTrace();
            throw new XFormParseException(string);
        }
        catch (Exception exception) {
            String string = "Unhandled Exception while Parsing XForm";
            System.err.println(string);
            exception.printStackTrace();
            throw new XFormParseException(string);
        }
        return document;
    }

    public static FormDef getFormDef(Document document) {
        FormDef formDef = new FormDef();
        XFormParser.initBindHandlers();
        XFormParser.initStateVars();
        defaultNamespace = document.getRootElement().getNamespaceUri(null);
        XFormParser.parseElement(formDef, document.getRootElement(), formDef, topLevelHandlers);
        XFormParser.collapseRepeatGroups(formDef);
        if (instanceNode != null) {
            XFormParser.parseInstance(formDef, instanceNode);
        }
        XFormParser.initStateVars();
        XFormParser.processBindHandlers(formDef);
        return formDef;
    }

    private static void parseElement(FormDef formDef, Element element, Object object, Hashtable hashtable) {
        String string = element.getName();
        String[] stringArray = new String[]{"html", "head", "body", "xform", "chooseCaption", "addCaption", "addEmptyCaption", "delCaption", "doneCaption", "doneEmptyCaption", "mainHeader", "entryHeader", "delHeader"};
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        IElementHandler iElementHandler = (IElementHandler)hashtable.get(string);
        if (iElementHandler != null) {
            iElementHandler.handle(formDef, element, object);
        } else {
            if (!vector.contains(string)) {
                System.err.println("XForm Parse: Unrecognized element [" + string + "]. Ignoring and processing children..." + XFormParser.getVagueLocation(element));
            }
            for (int i = 0; i < element.getChildCount(); ++i) {
                if (element.getType(i) != 2) continue;
                XFormParser.parseElement(formDef, element.getElement(i), object, hashtable);
            }
        }
    }

    private static void parseTitle(FormDef formDef, Element element) {
        Vector vector = new Vector();
        String string = XFormParser.getXMLText(element, true);
        System.out.println("Title: \"" + string + "\"");
        formDef.setTitle(string);
        if (formDef.getName() == null) {
            formDef.setName(string);
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static void parseMeta(FormDef formDef, Element element) {
        Vector<String> vector = new Vector<String>();
        int n = element.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = element.getAttributeName(i);
            String string2 = element.getAttributeValue(i);
            if (!"name".equals(string)) continue;
            formDef.setName(string2);
        }
        vector.addElement("name");
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static void parseModel(FormDef formDef, Element element) {
        Vector vector = new Vector();
        Vector<Element> vector2 = new Vector<Element>();
        if (modelFound) {
            System.err.println("Multiple models not supported. Ignoring subsequent models." + XFormParser.getVagueLocation(element));
            return;
        }
        modelFound = true;
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        for (int i = 0; i < element.getChildCount(); ++i) {
            String string;
            int n = element.getType(i);
            Element element2 = n == 2 ? element.getElement(i) : null;
            String string2 = string = element2 != null ? element2.getName() : null;
            if ("itext".equals(string)) {
                XFormParser.parseIText(formDef, element2);
            } else if ("instance".equals(string)) {
                XFormParser.saveInstanceNode(element2);
            } else if (BIND_ATTR.equals(string)) {
                XFormParser.parseBind(formDef, element2);
            } else if ("submission".equals(string)) {
                vector2.addElement(element2);
            } else {
                if (n == 2) {
                    throw new XFormParseException("Unrecognized top-level tag [" + string + "] found within <model>", element2);
                }
                if (n == 4 && XFormParser.getXMLText(element, i, true).length() != 0) {
                    throw new XFormParseException("Unrecognized text content found within <model>: \"" + XFormParser.getXMLText(element, i, true) + "\"", element2);
                }
            }
            if (element2 != null && !BIND_ATTR.equals(string) && !"itext".equals(string)) continue;
            element.removeChild(i);
            --i;
        }
        for (Element element3 : vector2) {
            XFormParser.parseSubmission(formDef, element3);
        }
    }

    private static void parseSubmission(FormDef formDef, Element element) {
        Externalizable externalizable;
        String string = element.getAttributeValue(null, ID_ATTR);
        String string2 = element.getAttributeValue(null, "method");
        String string3 = element.getAttributeValue(null, "action");
        SubmissionParser submissionParser = new SubmissionParser();
        for (SubmissionParser object2 : submissionParsers) {
            if (!object2.matchesCustomMethod(string2)) continue;
            submissionParser = object2;
        }
        String string4 = element.getAttributeValue(null, REF_ATTR);
        String string5 = element.getAttributeValue(null, BIND_ATTR);
        IDataReference iDataReference = null;
        boolean bl = false;
        if (string5 != null) {
            externalizable = (DataBinding)bindingsByID.get(string5);
            if (externalizable == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID in submit'" + string5 + "'", element);
            }
            iDataReference = externalizable.getReference();
            bl = true;
        } else {
            iDataReference = string4 != null ? new XPathReference(string4) : new XPathReference("/");
        }
        if (iDataReference != null && !bl) {
            iDataReference = XFormParser.getAbsRef(iDataReference, TreeReference.rootRef());
        }
        externalizable = submissionParser.parseSubmission(string2, string3, iDataReference, element);
        if (string == null) {
            formDef.setDefaultSubmission((SubmissionProfile)externalizable);
        } else {
            formDef.addSubmissionProfile(string, (SubmissionProfile)externalizable);
        }
    }

    private static void saveInstanceNode(Element element) {
        if (instanceNode != null) {
            System.err.println("Multiple instances not supported. Ignoring subsequent instances." + XFormParser.getVagueLocation(element));
            return;
        }
        for (int i = 0; i < element.getChildCount(); ++i) {
            if (element.getType(i) != 2) continue;
            if (instanceNode != null) {
                throw new XFormParseException("XForm Parse: <instance> has more than one child element", element);
            }
            instanceNode = element.getElement(i);
        }
    }

    protected static QuestionDef parseUpload(IFormElement iFormElement, Element element, FormDef formDef, int n) {
        Vector<String> vector = new Vector<String>();
        QuestionDef questionDef = XFormParser.parseControl(iFormElement, element, formDef, n);
        String string = element.getAttributeValue(null, "mediatype");
        if ("image/*".equals(string)) {
            questionDef.setControlType(10);
        } else if ("audio/*".equals(string)) {
            questionDef.setControlType(12);
        } else if ("video/*".equals(string)) {
            questionDef.setControlType(13);
        }
        vector.addElement("mediatype");
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        return questionDef;
    }

    protected static QuestionDef parseControl(IFormElement iFormElement, Element element, FormDef formDef, int n) {
        QuestionDef questionDef = new QuestionDef();
        questionDef.setID(serialQuestionID++);
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        vector.addElement(BIND_ATTR);
        vector.addElement(APPEARANCE_ATTR);
        IDataReference iDataReference = null;
        boolean bl = false;
        String string = element.getAttributeValue(null, REF_ATTR);
        String string2 = element.getAttributeValue(null, BIND_ATTR);
        if (string2 != null) {
            DataBinding dataBinding = (DataBinding)bindingsByID.get(string2);
            if (dataBinding == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID '" + string2 + "'", element);
            }
            iDataReference = dataBinding.getReference();
            bl = true;
        } else if (string != null) {
            iDataReference = new XPathReference(string);
        } else if (n != 9) {
            throw new XFormParseException("XForm Parse: input control with neither 'ref' nor 'bind'", element);
        }
        if (iDataReference != null) {
            if (!bl) {
                iDataReference = XFormParser.getAbsRef(iDataReference, iFormElement);
            }
            questionDef.setBind(iDataReference);
            if (n == 2) {
                selectOnes.addElement((TreeReference)iDataReference.getReference());
            } else if (n == 3) {
                selectMultis.addElement((TreeReference)iDataReference.getReference());
            }
        }
        boolean bl2 = n == 3 || n == 2;
        questionDef.setControlType(n);
        questionDef.setAppearanceAttr(element.getAttributeValue(null, APPEARANCE_ATTR));
        for (int i = 0; i < element.getChildCount(); ++i) {
            String string3;
            int n2 = element.getType(i);
            Element element2 = n2 == 2 ? element.getElement(i) : null;
            String string4 = string3 = element2 != null ? element2.getName() : null;
            if (LABEL_ELEMENT.equals(string3)) {
                XFormParser.parseQuestionLabel(formDef, questionDef, element2);
                continue;
            }
            if ("hint".equals(string3)) {
                XFormParser.parseHint(formDef, questionDef, element2);
                continue;
            }
            if (bl2 && "item".equals(string3)) {
                XFormParser.parseItem(formDef, questionDef, element2);
                continue;
            }
            if (!bl2 || !"itemset".equals(string3)) continue;
            XFormParser.parseItemset(formDef, questionDef, element2, iFormElement);
        }
        if (bl2) {
            if (questionDef.getNumChoices() > 0 && questionDef.getDynamicChoices() != null) {
                throw new XFormParseException("Select question contains both literal choices and <itemset>");
            }
            if (questionDef.getNumChoices() == 0 && questionDef.getDynamicChoices() == null) {
                throw new XFormParseException("Select question has no choices");
            }
        }
        iFormElement.addChild(questionDef);
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        return questionDef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseQuestionLabel(FormDef formDef, QuestionDef questionDef, Element element) {
        String string = XFormParser.getLabel(element, formDef);
        String string2 = element.getAttributeValue("", REF_ATTR);
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        if (string2 != null) {
            if (!string2.startsWith(ITEXT_OPEN) || !string2.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + string2 + "] for <label>");
            String string3 = string2.substring(ITEXT_OPEN.length(), string2.indexOf(ITEXT_CLOSE));
            XFormParser.verifyTextMappings(formDef, string3, "Question <label>", true);
            questionDef.setTextID(string3);
        } else {
            questionDef.setLabelInnerText(string);
        }
        if (!XFormUtils.showUnusedAttributeWarning(element, vector)) return;
        System.out.println(XFormUtils.unusedAttWarning(element, vector));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseGroupLabel(FormDef formDef, GroupDef groupDef, Element element) {
        if (groupDef.getRepeat()) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        String string = XFormParser.getLabel(element, formDef);
        String string2 = element.getAttributeValue("", REF_ATTR);
        if (string2 != null) {
            if (!string2.startsWith(ITEXT_OPEN) || !string2.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + string2 + "] for <label>");
            String string3 = string2.substring(ITEXT_OPEN.length(), string2.indexOf(ITEXT_CLOSE));
            XFormParser.verifyTextMappings(formDef, string3, "Group <label>", true);
            groupDef.setTextID(string3);
        } else {
            groupDef.setLabelInnerText(string);
        }
        if (!XFormUtils.showUnusedAttributeWarning(element, vector)) return;
        System.out.println(XFormUtils.unusedAttWarning(element, vector));
    }

    private static String getLabel(Element element, FormDef formDef) {
        if (element.getChildCount() == 0) {
            return null;
        }
        XFormParser.recurseForOutput(element, formDef);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < element.getChildCount(); ++i) {
            if (element.getType(i) != 4 && !(element.getChild(i) instanceof String)) {
                Object object = element.getChild(i);
                Element element2 = (Element)object;
                if (NAMESPACE_HTML.equals(element2.getNamespace())) {
                    stringBuffer.append(XFormSerializer.elementToString(element2));
                    continue;
                }
                System.out.println("Unrecognized tag inside of text: <" + element2.getName() + ">. " + "Did you intend to use HTML markup? If so, ensure that the element is defined in " + "the HTML namespace.");
                continue;
            }
            stringBuffer.append(element.getText(i));
        }
        String string = stringBuffer.toString().trim();
        return string;
    }

    private static void recurseForOutput(Element element, FormDef formDef) {
        if (element.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < element.getChildCount(); ++i) {
            int n = element.getType(i);
            if (n == 4 || element.getChild(i) instanceof String) continue;
            Element element2 = (Element)element.getChild(i);
            if (n == 2 && XFormUtils.isOutput(element2)) {
                String string = "${" + XFormParser.parseOutput(element2, formDef) + "}";
                element.removeChild(i);
                element.addChild(i, 4, string);
                continue;
            }
            if (element2.getChildCount() == 0) continue;
            XFormParser.recurseForOutput(element2, formDef);
        }
    }

    private static String parseOutput(Element element, FormDef formDef) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        vector.addElement(VALUE);
        String string = element.getAttributeValue(null, REF_ATTR);
        if (string == null) {
            string = element.getAttributeValue(null, VALUE);
        }
        if (string == null) {
            throw new XFormParseException("XForm Parse: <output> without 'ref' or 'value'", element);
        }
        XPathConditional xPathConditional = null;
        try {
            xPathConditional = new XPathConditional(string);
        }
        catch (XPathSyntaxException xPathSyntaxException) {
            System.err.println("Invalid XPath expression [" + string + "]!");
            return "";
        }
        int n = -1;
        if (formDef.getOutputFragments().contains(xPathConditional)) {
            n = formDef.getOutputFragments().indexOf(xPathConditional);
        } else {
            n = formDef.getOutputFragments().size();
            formDef.getOutputFragments().addElement(xPathConditional);
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        return String.valueOf(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseHint(FormDef formDef, QuestionDef questionDef, Element element) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        String string = XFormParser.getXMLText(element, true);
        String string2 = element.getAttributeValue("", REF_ATTR);
        if (string2 != null) {
            if (!string2.startsWith(ITEXT_OPEN) || !string2.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + string2 + "] for <hint>");
            String string3 = string2.substring(ITEXT_OPEN.length(), string2.indexOf(ITEXT_CLOSE));
            XFormParser.verifyTextMappings(formDef, string3, "<hint>", false);
            questionDef.setHelpTextID(string3);
        } else {
            questionDef.setHelpText(string);
        }
        if (!XFormUtils.showUnusedAttributeWarning(element, vector)) return;
        System.out.println(XFormUtils.unusedAttWarning(element, vector));
    }

    private static void parseItem(FormDef formDef, QuestionDef questionDef, Element element) {
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector2.addElement(REF_ATTR);
        vector3.addElement(FORM_ATTR);
        String string = null;
        String string2 = null;
        String string3 = null;
        block0: for (int i = 0; i < element.getChildCount(); ++i) {
            String string4;
            int n = element.getType(i);
            Element element2 = n == 2 ? element.getElement(i) : null;
            String string5 = string4 = element2 != null ? element2.getName() : null;
            if (LABEL_ELEMENT.equals(string4)) {
                if (XFormUtils.showUnusedAttributeWarning(element2, vector2)) {
                    System.out.println(XFormUtils.unusedAttWarning(element2, vector2));
                }
                string = XFormParser.getXMLText(element2, true);
                String string6 = element2.getAttributeValue("", REF_ATTR);
                if (string6 == null) continue;
                if (string6.startsWith(ITEXT_OPEN) && string6.endsWith(ITEXT_CLOSE)) {
                    string2 = string6.substring(ITEXT_OPEN.length(), string6.indexOf(ITEXT_CLOSE));
                    XFormParser.verifyTextMappings(formDef, string2, "Item <label>", true);
                    continue;
                }
                throw new XFormParseException("malformed ref [" + string6 + "] for <item>", element2);
            }
            if (!VALUE.equals(string4)) continue;
            string3 = XFormParser.getXMLText(element2, true);
            if (XFormUtils.showUnusedAttributeWarning(element2, vector3)) {
                System.out.println(XFormUtils.unusedAttWarning(element2, vector3));
            }
            if (string3.length() > 32) {
                System.err.println("WARNING: choice value [" + string3 + "] is too long; max. suggested length " + 32 + " chars" + XFormParser.getVagueLocation(element2));
            }
            for (int j = 0; j < string3.length(); ++j) {
                char c = string3.charAt(j);
                if (" \n\t\f\r'\"`".indexOf(c) < 0) continue;
                boolean bl = questionDef.getControlType() == 3;
                System.err.println("XForm Parse WARNING: " + (bl ? SELECT : SELECTONE) + " question <value>s [" + string3 + "] " + (bl ? "cannot" : "should not") + " contain spaces, and are recommended not to contain apostraphes/quotation marks" + XFormParser.getVagueLocation(element2));
                continue block0;
            }
        }
        if (string2 == null && string == null) {
            throw new XFormParseException("<item> without proper <label>", element);
        }
        if (string3 == null) {
            throw new XFormParseException("<item> without proper <value>", element);
        }
        if (string2 != null) {
            questionDef.addSelectChoice(new SelectChoice(string2, string3));
        } else {
            questionDef.addSelectChoice(new SelectChoice(null, string, string3, false));
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static void parseItemset(FormDef formDef, QuestionDef questionDef, Element element, IFormElement iFormElement) {
        ItemsetBinding itemsetBinding = new ItemsetBinding();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(NODESET_ATTR);
        vector2.addElement(REF_ATTR);
        vector3.addElement(REF_ATTR);
        vector3.addElement(FORM_ATTR);
        vector4.addElement(REF_ATTR);
        String string = element.getAttributeValue("", NODESET_ATTR);
        if (string == null) {
            throw new RuntimeException("No nodeset attribute in element: [" + element.getName() + "]. This is required. (Element Printout:" + XFormSerializer.elementToString(element) + ")");
        }
        XPathPathExpr xPathPathExpr = XPathReference.getPathExpr(string);
        itemsetBinding.nodesetExpr = new XPathConditional(xPathPathExpr);
        itemsetBinding.contextRef = XFormParser.getFormElementRef(iFormElement);
        itemsetBinding.nodesetRef = FormInstance.unpackReference(XFormParser.getAbsRef((IDataReference)new XPathReference(xPathPathExpr.getReference(true)), itemsetBinding.contextRef));
        for (int i = 0; i < element.getChildCount(); ++i) {
            String string2;
            String string3;
            int n = element.getType(i);
            Element element2 = n == 2 ? element.getElement(i) : null;
            String string4 = string3 = element2 != null ? element2.getName() : null;
            if (LABEL_ELEMENT.equals(string3)) {
                string2 = element2.getAttributeValue("", REF_ATTR);
                boolean bl = false;
                if (XFormUtils.showUnusedAttributeWarning(element2, vector2)) {
                    System.out.println(XFormUtils.unusedAttWarning(element2, vector2));
                }
                if (string2 != null) {
                    if (string2.startsWith("jr:itext(") && string2.endsWith(")")) {
                        string2 = string2.substring("jr:itext(".length(), string2.indexOf(")"));
                        bl = true;
                    }
                } else {
                    throw new XFormParseException("<label> in <itemset> requires 'ref'");
                }
                XPathPathExpr xPathPathExpr2 = XPathReference.getPathExpr(string2);
                itemsetBinding.labelRef = FormInstance.unpackReference(XFormParser.getAbsRef((IDataReference)new XPathReference(xPathPathExpr2), itemsetBinding.nodesetRef));
                itemsetBinding.labelExpr = new XPathConditional(xPathPathExpr2);
                itemsetBinding.labelIsItext = bl;
                continue;
            }
            if ("copy".equals(string3)) {
                string2 = element2.getAttributeValue("", REF_ATTR);
                if (XFormUtils.showUnusedAttributeWarning(element2, vector4)) {
                    System.out.println(XFormUtils.unusedAttWarning(element2, vector4));
                }
                if (string2 == null) {
                    throw new XFormParseException("<copy> in <itemset> requires 'ref'");
                }
                itemsetBinding.copyRef = FormInstance.unpackReference(XFormParser.getAbsRef((IDataReference)new XPathReference(string2), itemsetBinding.nodesetRef));
                itemsetBinding.copyMode = true;
                continue;
            }
            if (!VALUE.equals(string3)) continue;
            string2 = element2.getAttributeValue("", REF_ATTR);
            if (XFormUtils.showUnusedAttributeWarning(element2, vector3)) {
                System.out.println(XFormUtils.unusedAttWarning(element2, vector3));
            }
            if (string2 == null) {
                throw new XFormParseException("<value> in <itemset> requires 'ref'");
            }
            XPathPathExpr xPathPathExpr3 = XPathReference.getPathExpr(string2);
            itemsetBinding.valueRef = FormInstance.unpackReference(XFormParser.getAbsRef((IDataReference)new XPathReference(xPathPathExpr3), itemsetBinding.nodesetRef));
            itemsetBinding.valueExpr = new XPathConditional(xPathPathExpr3);
            itemsetBinding.copyMode = false;
        }
        if (itemsetBinding.labelRef == null) {
            throw new XFormParseException("<itemset> requires <label>");
        }
        if (itemsetBinding.copyRef == null && itemsetBinding.valueRef == null) {
            throw new XFormParseException("<itemset> requires <copy> or <value>");
        }
        if (itemsetBinding.copyRef != null) {
            if (itemsetBinding.valueRef == null) {
                System.err.println("WARNING: <itemset>s with <copy> are STRONGLY recommended to have <value> as well; pre-selecting, default answers, and display of answers will not work properly otherwise");
            } else if (!itemsetBinding.copyRef.isParentOf(itemsetBinding.valueRef, false)) {
                throw new XFormParseException("<value> is outside <copy>");
            }
        }
        questionDef.setDynamicChoices(itemsetBinding);
        itemsets.addElement(itemsetBinding);
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseGroup(IFormElement iFormElement, Element element, FormDef formDef, int n) {
        int n2;
        Object object;
        GroupDef groupDef = new GroupDef();
        groupDef.setID(serialQuestionID++);
        IDataReference iDataReference = null;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        vector.addElement(REF_ATTR);
        vector.addElement(NODESET_ATTR);
        vector.addElement(BIND_ATTR);
        vector.addElement(APPEARANCE_ATTR);
        vector.addElement("count");
        vector.addElement("noAddRemove");
        if (n == 2) {
            groupDef.setRepeat(true);
        }
        String string = element.getAttributeValue(null, REF_ATTR);
        String string2 = element.getAttributeValue(null, NODESET_ATTR);
        String string3 = element.getAttributeValue(null, BIND_ATTR);
        groupDef.setAppearanceAttr(element.getAttributeValue(null, APPEARANCE_ATTR));
        if (string3 != null) {
            object = (DataBinding)bindingsByID.get(string3);
            if (object == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID [" + string3 + "]", element);
            }
            iDataReference = ((DataBinding)object).getReference();
            bl = true;
        } else if (groupDef.getRepeat()) {
            if (string2 == null) throw new XFormParseException("XForm Parse: <repeat> with no binding ('bind' or 'nodeset')", element);
            iDataReference = new XPathReference(string2);
        } else if (string != null) {
            iDataReference = new XPathReference(string);
        }
        if (!bl) {
            iDataReference = XFormParser.getAbsRef(iDataReference, iFormElement);
        }
        groupDef.setBind(iDataReference);
        if (groupDef.getRepeat()) {
            repeats.addElement((TreeReference)iDataReference.getReference());
            object = element.getAttributeValue(NAMESPACE_JAVAROSA, "count");
            if (object != null) {
                groupDef.count = XFormParser.getAbsRef((IDataReference)new XPathReference((String)object), iFormElement);
                groupDef.noAddRemove = true;
            } else {
                groupDef.noAddRemove = element.getAttributeValue(NAMESPACE_JAVAROSA, "noAddRemove") != null;
            }
        }
        for (n2 = 0; n2 < element.getChildCount(); ++n2) {
            String string4;
            int n3 = element.getType(n2);
            Element element2 = n3 == 2 ? element.getElement(n2) : null;
            String string5 = element2 != null ? element2.getName() : null;
            String string6 = string4 = element2 != null ? element2.getNamespace() : null;
            if (!groupDef.getRepeat() || !NAMESPACE_JAVAROSA.equals(string4)) continue;
            if ("chooseCaption".equals(string5)) {
                groupDef.chooseCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("addCaption".equals(string5)) {
                groupDef.addCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("delCaption".equals(string5)) {
                groupDef.delCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("doneCaption".equals(string5)) {
                groupDef.doneCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("addEmptyCaption".equals(string5)) {
                groupDef.addEmptyCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("doneEmptyCaption".equals(string5)) {
                groupDef.doneEmptyCaption = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("entryHeader".equals(string5)) {
                groupDef.entryHeader = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if ("delHeader".equals(string5)) {
                groupDef.delHeader = XFormParser.getLabel(element2, formDef);
                continue;
            }
            if (!"mainHeader".equals(string5)) continue;
            groupDef.mainHeader = XFormParser.getLabel(element2, formDef);
        }
        for (n2 = 0; n2 < element.getChildCount(); ++n2) {
            if (element.getType(n2) != 2) continue;
            XFormParser.parseElement(formDef, element.getElement(n2), groupDef, groupLevelHandlers);
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        iFormElement.addChild(groupDef);
    }

    private static TreeReference getFormElementRef(IFormElement iFormElement) {
        if (iFormElement instanceof FormDef) {
            TreeReference treeReference = TreeReference.rootRef();
            treeReference.add(instanceNode.getName(), 0);
            return treeReference;
        }
        return (TreeReference)iFormElement.getBind().getReference();
    }

    private static IDataReference getAbsRef(IDataReference iDataReference, IFormElement iFormElement) {
        return XFormParser.getAbsRef(iDataReference, XFormParser.getFormElementRef(iFormElement));
    }

    private static IDataReference getAbsRef(IDataReference iDataReference, TreeReference treeReference) {
        if (!treeReference.isAbsolute()) {
            throw new RuntimeException("XFormParser.getAbsRef: parentRef must be absolute");
        }
        TreeReference treeReference2 = iDataReference != null ? (TreeReference)iDataReference.getReference() : TreeReference.selfRef();
        if ((treeReference2 = treeReference2.parent(treeReference)) == null) {
            throw new XFormParseException("Binding path [" + treeReference2 + "] not allowed with parent binding of [" + treeReference + "]");
        }
        return new XPathReference(treeReference2);
    }

    private static void collapseRepeatGroups(IFormElement iFormElement) {
        if (iFormElement.getChildren() == null) {
            return;
        }
        for (int i = 0; i < iFormElement.getChildren().size(); ++i) {
            IFormElement iFormElement2 = iFormElement.getChild(i);
            GroupDef groupDef = null;
            if (iFormElement2 instanceof GroupDef) {
                groupDef = (GroupDef)iFormElement2;
            }
            if (groupDef == null) continue;
            if (!groupDef.getRepeat() && groupDef.getChildren().size() == 1) {
                IFormElement iFormElement3 = (IFormElement)groupDef.getChildren().elementAt(0);
                GroupDef groupDef2 = null;
                if (iFormElement3 instanceof GroupDef) {
                    groupDef2 = (GroupDef)iFormElement3;
                }
                if (groupDef2 != null && groupDef2.getRepeat()) {
                    groupDef2.setLabelInnerText(groupDef.getLabelInnerText());
                    groupDef2.setTextID(groupDef.getTextID());
                    iFormElement.getChildren().setElementAt(groupDef2, i);
                    groupDef = groupDef2;
                }
            }
            XFormParser.collapseRepeatGroups(groupDef);
        }
    }

    private static void parseIText(FormDef formDef, Element element) {
        Localizer localizer = new Localizer(true, true);
        formDef.setLocalizer(localizer);
        localizer.registerLocalizable(formDef);
        Vector vector = new Vector();
        for (int i = 0; i < element.getChildCount(); ++i) {
            Element element2 = element.getElement(i);
            if (element2 == null || !element2.getName().equals("translation")) continue;
            XFormParser.parseTranslation(localizer, element2, formDef);
        }
        if (localizer.getAvailableLocales().length == 0) {
            throw new XFormParseException("no <translation>s defined", element);
        }
        if (localizer.getDefaultLocale() == null) {
            localizer.setDefaultLocale(localizer.getAvailableLocales()[0]);
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static void parseTranslation(Localizer localizer, Element element, FormDef formDef) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("lang");
        vector.addElement("default");
        String string = element.getAttributeValue("", "lang");
        if (string == null || string.length() == 0) {
            throw new XFormParseException("no language specified for <translation>", element);
        }
        String string2 = element.getAttributeValue("", "default");
        if (!localizer.addAvailableLocale(string)) {
            throw new XFormParseException("duplicate <translation> for language '" + string + "'", element);
        }
        if (string2 != null) {
            if (localizer.getDefaultLocale() != null) {
                throw new XFormParseException("more than one <translation> set as default", element);
            }
            localizer.setDefaultLocale(string);
        }
        TableLocaleSource tableLocaleSource = new TableLocaleSource();
        for (int i = 0; i < element.getChildCount(); ++i) {
            Element element2 = element.getElement(i);
            if (element2 == null || !element2.getName().equals("text")) continue;
            XFormParser.parseTextHandle(tableLocaleSource, element2, formDef);
            element.removeChild(i);
            --i;
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        localizer.registerLocaleResource(string, tableLocaleSource);
    }

    private static void parseTextHandle(TableLocaleSource tableLocaleSource, Element element, FormDef formDef) {
        String string = element.getAttributeValue("", ID_ATTR);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(ID_ATTR);
        vector.addElement(FORM_ATTR);
        vector2.addElement(FORM_ATTR);
        vector2.addElement(ID_ATTR);
        if (string == null || string.length() == 0) {
            throw new XFormParseException("no id defined for <text>", element);
        }
        for (int i = 0; i < element.getChildCount(); ++i) {
            String string2;
            String string3;
            Element element2 = element.getElement(i);
            if (element2 == null) continue;
            if (!element2.getName().equals(VALUE)) {
                throw new XFormParseException("Unrecognized element [" + element2.getName() + "] in Itext->translation->text");
            }
            String string4 = element2.getAttributeValue("", FORM_ATTR);
            if (string4 != null && string4.length() == 0) {
                string4 = null;
            }
            if ((string3 = XFormParser.getLabel(element2, formDef)) == null) {
                string3 = "";
            }
            String string5 = string2 = string4 == null ? string : string + ";" + string4;
            if (tableLocaleSource.hasMapping(string2)) {
                throw new XFormParseException("duplicate definition for text ID \"" + string + "\" and form \"" + string4 + "\"" + ". Can only have one definition for each text form.", element);
            }
            tableLocaleSource.setLocaleMapping(string2, string3);
            if (!XFormUtils.showUnusedAttributeWarning(element2, vector2)) continue;
            System.out.println(XFormUtils.unusedAttWarning(element2, vector2));
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static boolean hasITextMapping(FormDef formDef, String string, String string2) {
        Localizer localizer = formDef.getLocalizer();
        return localizer.hasMapping(string2 == null ? localizer.getDefaultLocale() : string2, string);
    }

    private static void verifyTextMappings(FormDef formDef, String string, String string2, boolean bl) {
        Localizer localizer = formDef.getLocalizer();
        String[] stringArray = localizer.getAvailableLocales();
        for (int i = 0; i < stringArray.length; ++i) {
            if (XFormParser.hasITextMapping(formDef, string, stringArray[i]) || bl && XFormParser.hasSpecialFormMapping(formDef, string, stringArray[i])) continue;
            if (stringArray[i].equals(localizer.getDefaultLocale())) {
                throw new XFormParseException(string2 + " '" + string + "': text is not localizable for default locale [" + localizer.getDefaultLocale() + "]!");
            }
            System.err.println("Warning: " + string2 + " '" + string + "': text is not localizable for locale " + stringArray[i] + ".");
        }
    }

    private static boolean hasSpecialFormMapping(FormDef formDef, String string, String string2) {
        for (String string3 : guesses) {
            if (!XFormParser.hasITextMapping(formDef, string + ";" + string3, string2)) continue;
            return true;
        }
        OrderedHashtable orderedHashtable = formDef.getLocalizer().getLocaleData(string2);
        Enumeration enumeration = orderedHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string + ";")) continue;
            string3 = string4.substring(string4.indexOf(";") + 1, string4.length());
            System.out.println("adding unexpected special itext form: " + string3 + " to list of expected forms");
            String[] stringArray = new String[guesses.length + 1];
            for (int i = 0; i < guesses.length; ++i) {
                stringArray[i] = guesses[i];
            }
            stringArray[stringArray.length - 1] = string3;
            guesses = stringArray;
            return true;
        }
        return false;
    }

    private static void parseBind(FormDef formDef, Element element) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        DataBinding dataBinding = new DataBinding();
        Vector<String> vector = new Vector<String>();
        vector.addElement(ID_ATTR);
        vector.addElement(NODESET_ATTR);
        vector.addElement("type");
        vector.addElement("relevant");
        vector.addElement("required");
        vector.addElement("readonly");
        vector.addElement("constraint");
        vector.addElement("constraintMsg");
        vector.addElement("calculate");
        vector.addElement("preload");
        vector.addElement("preloadParams");
        dataBinding.setId(element.getAttributeValue("", ID_ATTR));
        String string2 = element.getAttributeValue(null, NODESET_ATTR);
        if (string2 == null) {
            throw new XFormParseException("XForm Parse: <bind> without nodeset", element);
        }
        IDataReference iDataReference = new XPathReference(string2);
        iDataReference = XFormParser.getAbsRef(iDataReference, formDef);
        dataBinding.setReference(iDataReference);
        dataBinding.setDataType(XFormParser.getDataType(element.getAttributeValue(null, "type")));
        String string3 = element.getAttributeValue(null, "relevant");
        if (string3 != null) {
            if ("true()".equals(string3)) {
                dataBinding.relevantAbsolute = true;
            } else if ("false()".equals(string3)) {
                dataBinding.relevantAbsolute = false;
            } else {
                object4 = XFormParser.buildCondition(string3, "relevant", iDataReference);
                dataBinding.relevancyCondition = object4 = (Condition)formDef.addTriggerable((Triggerable)object4);
            }
        }
        if ((object4 = element.getAttributeValue(null, "required")) != null) {
            if ("true()".equals(object4)) {
                dataBinding.requiredAbsolute = true;
            } else if ("false()".equals(object4)) {
                dataBinding.requiredAbsolute = false;
            } else {
                object3 = XFormParser.buildCondition((String)object4, "required", iDataReference);
                dataBinding.requiredCondition = object3 = (Condition)formDef.addTriggerable((Triggerable)object3);
            }
        }
        if ((object3 = element.getAttributeValue(null, "readonly")) != null) {
            if ("true()".equals(object3)) {
                dataBinding.readonlyAbsolute = true;
            } else if ("false()".equals(object3)) {
                dataBinding.readonlyAbsolute = false;
            } else {
                object2 = XFormParser.buildCondition((String)object3, "readonly", iDataReference);
                dataBinding.readonlyCondition = object2 = (Condition)formDef.addTriggerable((Triggerable)object2);
            }
        }
        if ((object2 = element.getAttributeValue(null, "constraint")) != null) {
            try {
                dataBinding.constraint = new XPathConditional((String)object2);
            }
            catch (XPathSyntaxException xPathSyntaxException) {
                System.err.println("Invalid XPath expression [" + (String)object2 + "]!" + XFormParser.getVagueLocation(element));
            }
            dataBinding.constraintMessage = element.getAttributeValue(NAMESPACE_JAVAROSA, "constraintMsg");
        }
        if ((string = element.getAttributeValue(null, "calculate")) != null) {
            object = XFormParser.buildCalculate(string, iDataReference);
            object = (Recalculate)formDef.addTriggerable((Triggerable)object);
            dataBinding.calculate = object;
        }
        dataBinding.setPreload(element.getAttributeValue(NAMESPACE_JAVAROSA, "preload"));
        dataBinding.setPreloadParams(element.getAttributeValue(NAMESPACE_JAVAROSA, "preloadParams"));
        object = bindHandlers.elements();
        while (object.hasMoreElements()) {
            ((IXFormBindHandler)object.nextElement()).handle(element, dataBinding);
        }
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
        XFormParser.addBinding(dataBinding);
    }

    private static Condition buildCondition(String string, String string2, IDataReference iDataReference) {
        XPathConditional xPathConditional;
        int n = -1;
        int n2 = -1;
        if ("relevant".equals(string2)) {
            n = 1;
            n2 = 2;
        } else if ("required".equals(string2)) {
            n = 7;
            n2 = 8;
        } else if ("readonly".equals(string2)) {
            n = 4;
            n2 = 3;
        }
        try {
            xPathConditional = new XPathConditional(string);
        }
        catch (XPathSyntaxException xPathSyntaxException) {
            System.err.println("Invalid XPath expression [" + string + "]!");
            return null;
        }
        Condition condition = new Condition(xPathConditional, n, n2, FormInstance.unpackReference(iDataReference));
        return condition;
    }

    private static Recalculate buildCalculate(String string, IDataReference iDataReference) {
        XPathConditional xPathConditional;
        try {
            xPathConditional = new XPathConditional(string);
        }
        catch (XPathSyntaxException xPathSyntaxException) {
            System.err.println("Invalid XPath expression [" + string + "]!");
            return null;
        }
        Recalculate recalculate = new Recalculate(xPathConditional, FormInstance.unpackReference(iDataReference));
        return recalculate;
    }

    private static void addBinding(DataBinding dataBinding) {
        bindings.addElement(dataBinding);
        if (dataBinding.getId() != null && bindingsByID.put(dataBinding.getId(), dataBinding) != null) {
            throw new XFormParseException("XForm Parse: <bind>s with duplicate ID: '" + dataBinding.getId() + "'");
        }
    }

    private static void parseInstance(FormDef formDef, Element element) {
        TreeElement treeElement = XFormParser.buildInstanceStructure(element, null);
        FormInstance formInstance = new FormInstance(treeElement);
        formInstance.setName(formDef.getTitle());
        Vector<String> vector = new Vector<String>();
        vector.addElement("version");
        vector.addElement("uiVersion");
        String string = element.getNamespace();
        if (string != null && string.length() > 0 && !string.equals(defaultNamespace)) {
            formInstance.schema = string;
        }
        formInstance.formVersion = element.getAttributeValue(null, "version");
        formInstance.uiVersion = element.getAttributeValue(null, "uiVersion");
        XFormParser.loadNamespaces(element, formInstance);
        XFormParser.processRepeats(formInstance);
        XFormParser.verifyBindings(formDef, formInstance);
        XFormParser.applyInstanceProperties(formInstance);
        XFormParser.loadInstanceData(element, treeElement, formDef);
        XFormParser.checkDependencyCycles(formDef);
        formDef.setInstance(formInstance);
        formDef.finalizeTriggerables();
        if (XFormUtils.showUnusedAttributeWarning(element, vector)) {
            System.out.println(XFormUtils.unusedAttWarning(element, vector));
        }
    }

    private static Hashtable loadNamespaces(Element element, FormInstance formInstance) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < element.getNamespaceCount(); ++i) {
            String string = element.getNamespaceUri(i);
            String string2 = element.getNamespacePrefix(i);
            if (string == null || string2 == null) continue;
            formInstance.addNamespace(string2, string);
        }
        return hashtable;
    }

    public static TreeElement buildInstanceStructure(Element element, TreeElement treeElement) {
        int n;
        String string;
        int n2;
        TreeElement treeElement2 = null;
        int n3 = element.getChildCount();
        boolean bl = false;
        boolean bl2 = false;
        block4: for (int i = 0; i < n3; ++i) {
            switch (element.getType(i)) {
                case 2: {
                    bl2 = true;
                    continue block4;
                }
                case 4: {
                    if (element.getText(i).trim().length() <= 0) continue block4;
                    bl = true;
                }
            }
        }
        if (bl2 && bl) {
            System.out.println("Warning: instance node '" + element.getName() + "' contains both elements and text as children; text ignored");
        }
        String string2 = element.getName();
        if (element.getAttributeValue(NAMESPACE_JAVAROSA, "template") != null) {
            n2 = -2;
            if (treeElement != null && treeElement.getChild(string2, -2) != null) {
                throw new XFormParseException("More than one node declared as the template for the same repeated set [" + string2 + "]", element);
            }
        } else {
            int n4 = n2 = treeElement == null ? 0 : treeElement.getChildMultiplicity(string2);
        }
        if ((string = element.getAttributeValue(NAMESPACE_JAVAROSA, "modeltype")) == null) {
            treeElement2 = new TreeElement(string2, n2);
        } else {
            if (typeMappings.get(string) == null) {
                throw new XFormParseException("ModelType " + string + " is not recognized.", element);
            }
            treeElement2 = (TreeElement)modelPrototypes.getNewInstance(((Integer)typeMappings.get(string)).toString());
            if (treeElement2 == null) {
                treeElement2 = new TreeElement(string2, n2);
                System.out.println("No model type prototype available for " + string);
            } else {
                treeElement2.setName(string2);
                treeElement2.setMult(n2);
            }
        }
        if (bl2) {
            for (n = 0; n < n3; ++n) {
                if (element.getType(n) != 2) continue;
                treeElement2.addChild(XFormParser.buildInstanceStructure(element.getElement(n), treeElement2));
            }
        }
        if (element.getAttributeCount() > 0) {
            for (n = 0; n < element.getAttributeCount(); ++n) {
                String string3 = element.getAttributeNamespace(n);
                String string4 = element.getAttributeName(n);
                if (string3.equals(NAMESPACE_JAVAROSA) && string4.equals("template") || string3.equals(NAMESPACE_JAVAROSA) && string4.equals("recordset")) continue;
                treeElement2.setAttribute(string3, string4, element.getAttributeValue(n));
            }
        }
        return treeElement2;
    }

    private static Vector<TreeReference> getRepeatableRefs() {
        int n;
        Vector<TreeReference> vector = new Vector<TreeReference>();
        for (n = 0; n < repeats.size(); ++n) {
            vector.addElement((TreeReference)repeats.elementAt(n));
        }
        for (n = 0; n < itemsets.size(); ++n) {
            TreeReference treeReference;
            ItemsetBinding itemsetBinding = (ItemsetBinding)itemsets.elementAt(n);
            TreeReference treeReference2 = itemsetBinding.nodesetRef;
            if (!vector.contains(treeReference2)) {
                boolean bl = true;
                for (int i = 0; i < treeReference2.size(); ++i) {
                    if (!"*".equals(treeReference2.getName(i))) continue;
                    bl = false;
                }
                if (bl) {
                    vector.addElement(treeReference2);
                }
            }
            if (!itemsetBinding.copyMode || vector.contains(treeReference = itemsetBinding.getDestRef())) continue;
            vector.addElement(treeReference);
        }
        return vector;
    }

    private static void processRepeats(FormInstance formInstance) {
        XFormParser.flagRepeatables(formInstance);
        XFormParser.processTemplates(formInstance);
        XFormParser.checkDuplicateNodesAreRepeatable(formInstance.getRoot());
        XFormParser.checkHomogeneity(formInstance);
    }

    private static void flagRepeatables(FormInstance formInstance) {
        Vector<TreeReference> vector = XFormParser.getRepeatableRefs();
        for (int i = 0; i < vector.size(); ++i) {
            TreeReference treeReference = vector.elementAt(i);
            Vector vector2 = formInstance.expandReference(treeReference, true);
            for (int j = 0; j < vector2.size(); ++j) {
                TreeReference treeReference2 = (TreeReference)vector2.elementAt(j);
                TreeElement treeElement = formInstance.resolveReference(treeReference2);
                if (treeElement == null) continue;
                treeElement.repeatable = true;
            }
        }
    }

    private static void processTemplates(FormInstance formInstance) {
        repeatTree = XFormParser.buildRepeatTree(XFormParser.getRepeatableRefs(), formInstance.getRoot().getName());
        Vector vector = new Vector();
        XFormParser.checkRepeatsForTemplate(formInstance, repeatTree, vector);
        XFormParser.removeInvalidTemplates(formInstance, repeatTree);
        XFormParser.createMissingTemplates(formInstance, vector);
    }

    private static FormInstance buildRepeatTree(Vector vector, String string) {
        TreeElement treeElement = new TreeElement(null, 0);
        for (int i = 0; i < vector.size(); ++i) {
            TreeReference treeReference = (TreeReference)vector.elementAt(i);
            if (treeReference.size() <= 1) continue;
            TreeElement treeElement2 = treeElement;
            for (int j = 0; j < treeReference.size(); ++j) {
                String string2 = treeReference.getName(j);
                TreeElement treeElement3 = treeElement2.getChild(string2, 0);
                if (treeElement3 == null) {
                    treeElement3 = new TreeElement(string2, 0);
                    treeElement2.addChild(treeElement3);
                }
                treeElement2 = treeElement3;
            }
            treeElement2.repeatable = true;
        }
        if (treeElement.getNumChildren() == 0) {
            return null;
        }
        return new FormInstance(treeElement.getChild(string, 0));
    }

    private static void checkRepeatsForTemplate(FormInstance formInstance, FormInstance formInstance2, Vector vector) {
        if (formInstance2 != null) {
            XFormParser.checkRepeatsForTemplate(formInstance2.getRoot(), TreeReference.rootRef(), formInstance, vector);
        }
    }

    private static void checkRepeatsForTemplate(TreeElement treeElement, TreeReference treeReference, FormInstance formInstance, Vector vector) {
        TreeElement treeElement2;
        String string = treeElement.getName();
        int n = treeElement.repeatable ? -2 : 0;
        treeReference = treeReference.extendRef(string, n);
        if (treeElement.repeatable && (treeElement2 = formInstance.resolveReference(treeReference)) == null) {
            vector.addElement(treeReference);
        }
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            XFormParser.checkRepeatsForTemplate(treeElement.getChildAt(i), treeReference, formInstance, vector);
        }
    }

    private static void removeInvalidTemplates(FormInstance formInstance, FormInstance formInstance2) {
        XFormParser.removeInvalidTemplates(formInstance.getRoot(), formInstance2 == null ? null : formInstance2.getRoot(), true);
    }

    private static boolean removeInvalidTemplates(TreeElement treeElement, TreeElement treeElement2, boolean bl) {
        boolean bl2;
        int n = treeElement.getMult();
        boolean bl3 = bl2 = treeElement2 == null ? false : treeElement2.repeatable;
        if (n == -2) {
            if (!bl) {
                System.out.println("Warning: template nodes for sub-repeats must be located within the template node of the parent repeat; ignoring template... [" + treeElement.getName() + "]");
                return true;
            }
            if (!bl2) {
                System.out.println("Warning: template node found for ref that is not repeatable; ignoring... [" + treeElement.getName() + "]");
                return true;
            }
        }
        if (bl2 && n != -2) {
            bl = false;
        }
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            TreeElement treeElement3;
            TreeElement treeElement4 = treeElement.getChildAt(i);
            TreeElement treeElement5 = treeElement3 = treeElement2 == null ? null : treeElement2.getChild(treeElement4.getName(), 0);
            if (!XFormParser.removeInvalidTemplates(treeElement4, treeElement3, bl)) continue;
            treeElement.removeChildAt(i);
            --i;
        }
        return false;
    }

    private static void createMissingTemplates(FormInstance formInstance, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            TreeReference treeReference = (TreeReference)vector.elementAt(i);
            TreeReference treeReference2 = treeReference.clone();
            for (int j = 0; j < treeReference2.size(); ++j) {
                treeReference2.setMultiplicity(j, -1);
            }
            Vector vector2 = formInstance.expandReference(treeReference2);
            if (vector2.size() == 0) continue;
            TreeReference treeReference3 = (TreeReference)vector2.elementAt(0);
            try {
                formInstance.copyNode(treeReference3, treeReference);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                System.out.println("WARNING! Could not create a default repeat template; this is almost certainly a homogeneity error! Your form will not work! (Failed on " + treeReference.toString() + ")");
                invalidReferenceException.printStackTrace();
            }
            XFormParser.trimRepeatChildren(formInstance.resolveReference(treeReference));
        }
    }

    private static void trimRepeatChildren(TreeElement treeElement) {
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            TreeElement treeElement2 = treeElement.getChildAt(i);
            if (treeElement2.repeatable) {
                treeElement.removeChildAt(i);
                --i;
                continue;
            }
            XFormParser.trimRepeatChildren(treeElement2);
        }
    }

    private static void checkDuplicateNodesAreRepeatable(TreeElement treeElement) {
        int n = treeElement.getMult();
        if (n > 0 && !treeElement.repeatable) {
            System.out.println("Warning: repeated nodes [" + treeElement.getName() + "] detected that have no repeat binding in the form; DO NOT bind questions to these nodes or their children!");
        }
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            XFormParser.checkDuplicateNodesAreRepeatable(treeElement.getChildAt(i));
        }
    }

    private static void checkHomogeneity(FormInstance formInstance) {
        Vector<TreeReference> vector = XFormParser.getRepeatableRefs();
        for (int i = 0; i < vector.size(); ++i) {
            TreeReference treeReference = vector.elementAt(i);
            TreeElement treeElement = null;
            Vector vector2 = formInstance.expandReference(treeReference);
            for (int j = 0; j < vector2.size(); ++j) {
                TreeReference treeReference2 = (TreeReference)vector2.elementAt(j);
                TreeElement treeElement2 = formInstance.resolveReference(treeReference2);
                if (treeElement2 == null) continue;
                if (treeElement == null) {
                    treeElement = formInstance.getTemplate(treeReference2);
                }
                if (FormInstance.isHomogeneous(treeElement, treeElement2)) continue;
                System.out.println("WARNING! Not all repeated nodes for a given repeat binding [" + treeReference2.toString() + "] are homogeneous! This will cause serious problems!");
            }
        }
    }

    private static void verifyBindings(FormDef formDef, FormInstance formInstance) {
        Object object;
        for (int i = 0; i < bindings.size(); ++i) {
            DataBinding dataBinding = (DataBinding)bindings.elementAt(i);
            object = FormInstance.unpackReference(dataBinding.getReference());
            if (((TreeReference)object).size() == 0) {
                System.out.println("Cannot bind to '/'; ignoring bind...");
                bindings.removeElementAt(i);
                --i;
                continue;
            }
            Vector vector = formInstance.expandReference((TreeReference)object, true);
            if (vector.size() != 0) continue;
            System.out.println("WARNING: Bind [" + ((TreeReference)object).toString() + "] matches no nodes; ignoring bind...");
        }
        Vector<TreeReference> vector = XFormParser.getRepeatableRefs();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (((TreeReference)object).size() > 1) continue;
            throw new XFormParseException("Cannot bind repeat to '/' or '/" + instanceNode.getName() + "'");
        }
        Vector<String> vector2 = new Vector<String>();
        XFormParser.verifyControlBindings(formDef, formInstance, vector2);
        if (vector2.size() > 0) {
            object = "";
            for (int i = 0; i < vector2.size(); ++i) {
                object = (String)object + vector2.elementAt(i) + "\n";
            }
            throw new XFormParseException((String)object);
        }
        XFormParser.verifyRepeatMemberBindings(formDef, formInstance, null);
        XFormParser.verifyItemsetBindings(formInstance);
        XFormParser.verifyItemsetSrcDstCompatibility(formInstance);
    }

    private static void verifyControlBindings(IFormElement iFormElement, FormInstance formInstance, Vector<String> vector) {
        if (iFormElement.getChildren() == null) {
            return;
        }
        for (int i = 0; i < iFormElement.getChildren().size(); ++i) {
            IFormElement iFormElement2 = (IFormElement)iFormElement.getChildren().elementAt(i);
            IDataReference iDataReference = null;
            String string = null;
            if (iFormElement2 instanceof GroupDef) {
                iDataReference = ((GroupDef)iFormElement2).getBind();
                string = ((GroupDef)iFormElement2).getRepeat() ? "Repeat" : "Group";
            } else if (iFormElement2 instanceof QuestionDef) {
                iDataReference = ((QuestionDef)iFormElement2).getBind();
                string = "Control";
            }
            TreeReference treeReference = FormInstance.unpackReference(iDataReference);
            if (iFormElement2 instanceof QuestionDef && treeReference.size() == 0) {
                System.out.println("Warning! Cannot bind control to '/'");
            } else {
                Vector vector2 = formInstance.expandReference(treeReference, true);
                if (vector2.size() == 0) {
                    String string2 = "ERROR: " + string + " binding [" + treeReference.toString() + "] matches no nodes";
                    System.err.println(string2);
                    vector.addElement(string2);
                }
            }
            XFormParser.verifyControlBindings(iFormElement2, formInstance, vector);
        }
    }

    private static void verifyRepeatMemberBindings(IFormElement iFormElement, FormInstance formInstance, GroupDef groupDef) {
        if (iFormElement.getChildren() == null) {
            return;
        }
        for (int i = 0; i < iFormElement.getChildren().size(); ++i) {
            int n;
            TreeElement treeElement;
            TreeReference treeReference;
            IFormElement iFormElement2 = (IFormElement)iFormElement.getChildren().elementAt(i);
            boolean bl = iFormElement2 instanceof GroupDef && ((GroupDef)iFormElement2).getRepeat();
            TreeReference treeReference2 = groupDef == null ? TreeReference.rootRef() : FormInstance.unpackReference(groupDef.getBind());
            if (!treeReference2.isParentOf(treeReference = FormInstance.unpackReference(iFormElement2.getBind()), false)) {
                throw new XFormParseException("<repeat> member's binding [" + treeReference.toString() + "] is not a descendant of <repeat> binding [" + treeReference2.toString() + "]!");
            }
            if (treeReference2.equals(treeReference) && bl) {
                throw new XFormParseException("child <repeat>s [" + treeReference.toString() + "] cannot bind to the same node as their parent <repeat>; only questions/groups can");
            }
            Vector<TreeElement> vector = new Vector<TreeElement>();
            TreeElement treeElement2 = treeElement = repeatTree == null ? null : repeatTree.getRoot();
            if (treeElement != null) {
                vector.addElement(treeElement);
                for (n = 1; n < treeReference.size() && (treeElement = treeElement.getChild(treeReference.getName(n), 0)) != null; ++n) {
                    vector.addElement(treeElement);
                }
            }
            for (n = treeReference2.size(); n < treeReference.size(); ++n) {
                boolean bl2;
                TreeElement treeElement3 = n < vector.size() ? (TreeElement)vector.elementAt(n) : null;
                boolean bl3 = bl2 = treeElement3 == null ? false : treeElement3.repeatable;
                if (!bl2 || n == treeReference.size() - 1 && bl) continue;
                throw new XFormParseException("<repeat> member's binding [" + treeReference.toString() + "] is within the scope of a <repeat> that is not its closest containing <repeat>!");
            }
            XFormParser.verifyRepeatMemberBindings(iFormElement2, formInstance, bl ? (GroupDef)iFormElement2 : groupDef);
        }
    }

    private static void verifyItemsetBindings(FormInstance formInstance) {
        for (int i = 0; i < itemsets.size(); ++i) {
            ItemsetBinding itemsetBinding = (ItemsetBinding)itemsets.elementAt(i);
            if (!itemsetBinding.nodesetRef.isParentOf(itemsetBinding.labelRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of label ref");
            }
            if (itemsetBinding.copyRef != null && !itemsetBinding.nodesetRef.isParentOf(itemsetBinding.copyRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of copy ref");
            }
            if (itemsetBinding.valueRef != null && !itemsetBinding.nodesetRef.isParentOf(itemsetBinding.valueRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of value ref");
            }
            if (formInstance.getTemplatePath(itemsetBinding.labelRef) == null) {
                throw new XFormParseException("<label> node for itemset doesn't exist! [" + itemsetBinding.labelRef + "]");
            }
            if (itemsetBinding.copyRef != null && formInstance.getTemplatePath(itemsetBinding.copyRef) == null) {
                throw new XFormParseException("<copy> node for itemset doesn't exist! [" + itemsetBinding.copyRef + "]");
            }
            if (itemsetBinding.valueRef == null || formInstance.getTemplatePath(itemsetBinding.valueRef) != null) continue;
            throw new XFormParseException("<value> node for itemset doesn't exist! [" + itemsetBinding.valueRef + "]");
        }
    }

    private static void verifyItemsetSrcDstCompatibility(FormInstance formInstance) {
        for (int i = 0; i < itemsets.size(); ++i) {
            boolean bl;
            ItemsetBinding itemsetBinding = (ItemsetBinding)itemsets.elementAt(i);
            boolean bl2 = bl = formInstance.getTemplate(itemsetBinding.getDestRef()) != null;
            if (itemsetBinding.copyMode) {
                TreeElement treeElement;
                if (!bl) {
                    throw new XFormParseException("itemset copies to node(s) which are not repeatable");
                }
                TreeElement treeElement2 = formInstance.getTemplatePath(itemsetBinding.copyRef);
                if (FormInstance.isHomogeneous(treeElement2, treeElement = formInstance.getTemplate(itemsetBinding.getDestRef()))) continue;
                System.out.println("WARNING! Source [" + treeElement2.getRef().toString() + "] and dest [" + treeElement.getRef().toString() + "] of itemset appear to be incompatible!");
                continue;
            }
            if (!bl) continue;
            throw new XFormParseException("itemset sets value on repeatable nodes");
        }
    }

    private static void applyInstanceProperties(FormInstance formInstance) {
        for (int i = 0; i < bindings.size(); ++i) {
            DataBinding dataBinding = (DataBinding)bindings.elementAt(i);
            TreeReference treeReference = FormInstance.unpackReference(dataBinding.getReference());
            Vector vector = formInstance.expandReference(treeReference, true);
            if (vector.size() > 0) {
                XFormParser.attachBindGeneral(dataBinding);
            }
            for (int j = 0; j < vector.size(); ++j) {
                TreeReference treeReference2 = (TreeReference)vector.elementAt(j);
                XFormParser.attachBind(formInstance.resolveReference(treeReference2), dataBinding);
            }
        }
        XFormParser.applyControlProperties(formInstance);
    }

    private static void attachBindGeneral(DataBinding dataBinding) {
        TreeReference treeReference = FormInstance.unpackReference(dataBinding.getReference());
        if (dataBinding.relevancyCondition != null) {
            dataBinding.relevancyCondition.addTarget(treeReference);
        }
        if (dataBinding.requiredCondition != null) {
            dataBinding.requiredCondition.addTarget(treeReference);
        }
        if (dataBinding.readonlyCondition != null) {
            dataBinding.readonlyCondition.addTarget(treeReference);
        }
        if (dataBinding.calculate != null) {
            dataBinding.calculate.addTarget(treeReference);
        }
    }

    private static void attachBind(TreeElement treeElement, DataBinding dataBinding) {
        treeElement.dataType = dataBinding.getDataType();
        if (dataBinding.relevancyCondition == null) {
            treeElement.setRelevant(dataBinding.relevantAbsolute);
        }
        if (dataBinding.requiredCondition == null) {
            treeElement.setRequired(dataBinding.requiredAbsolute);
        }
        if (dataBinding.readonlyCondition == null) {
            treeElement.setEnabled(!dataBinding.readonlyAbsolute);
        }
        if (dataBinding.constraint != null) {
            treeElement.setConstraint(new Constraint(dataBinding.constraint, dataBinding.constraintMessage));
        }
        treeElement.setPreloadHandler(dataBinding.getPreload());
        treeElement.setPreloadParams(dataBinding.getPreloadParams());
    }

    private static void applyControlProperties(FormInstance formInstance) {
        for (int i = 0; i < 2; ++i) {
            Vector vector = i == 0 ? selectOnes : selectMultis;
            int n = i == 0 ? 7 : 8;
            for (int j = 0; j < vector.size(); ++j) {
                TreeReference treeReference = (TreeReference)vector.elementAt(j);
                Vector vector2 = formInstance.expandReference(treeReference, true);
                for (int k = 0; k < vector2.size(); ++k) {
                    TreeElement treeElement = formInstance.resolveReference((TreeReference)vector2.elementAt(k));
                    if (treeElement.dataType == 7 || treeElement.dataType == 8) continue;
                    if (treeElement.dataType == 0 || treeElement.dataType == 1) {
                        treeElement.dataType = n;
                        continue;
                    }
                    System.out.println("Warning! Type incompatible with select question node [" + treeReference.toString() + "] detected!");
                }
            }
        }
    }

    private static void loadInstanceData(Element element, TreeElement treeElement, FormDef formDef) {
        int n = element.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (element.getType(i) != 2) continue;
            bl = true;
        }
        if (bl) {
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (int i = 0; i < n; ++i) {
                int n2;
                boolean bl2;
                if (element.getType(i) != 2) continue;
                Element element2 = element.getElement(i);
                String string = element2.getName();
                boolean bl3 = bl2 = element2.getAttributeValue(NAMESPACE_JAVAROSA, "template") != null;
                if (bl2) {
                    n2 = -2;
                } else {
                    Integer n3 = (Integer)hashtable.get(string);
                    n2 = n3 == null ? 0 : n3 + 1;
                    hashtable.put(string, new Integer(n2));
                }
                XFormParser.loadInstanceData(element2, treeElement.getChild(string, n2), formDef);
            }
        } else {
            String string = XFormParser.getXMLText(element, false);
            if (string != null && string.trim().length() > 0) {
                treeElement.setValue(XFormAnswerDataParser.getAnswerData(string, treeElement.dataType, XFormParser.ghettoGetQuestionDef(treeElement.dataType, formDef, treeElement.getRef())));
            }
        }
    }

    public static QuestionDef ghettoGetQuestionDef(int n, FormDef formDef, TreeReference treeReference) {
        if (n == 7 || n == 8) {
            return FormDef.findQuestionByRef(treeReference, formDef);
        }
        return null;
    }

    private static void checkDependencyCycles(FormDef formDef) {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Vector<TreeReference[]> vector2 = new Vector<TreeReference[]>();
        Enumeration enumeration = formDef.triggerIndex.keys();
        while (enumeration.hasMoreElements()) {
            Externalizable externalizable;
            int n;
            object2 = (TreeReference)enumeration.nextElement();
            if (!vector.contains(object2)) {
                vector.addElement(object2);
            }
            Vector vector3 = (Vector)formDef.triggerIndex.get(object2);
            object = new Vector();
            for (n = 0; n < vector3.size(); ++n) {
                externalizable = (Triggerable)vector3.elementAt(n);
                for (int i = 0; i < ((Triggerable)externalizable).getTargets().size(); ++i) {
                    TreeReference treeReference = (TreeReference)((Triggerable)externalizable).getTargets().elementAt(i);
                    if (((Vector)object).contains(treeReference)) continue;
                    ((Vector)object).addElement(treeReference);
                }
            }
            for (n = 0; n < ((Vector)object).size(); ++n) {
                externalizable = (TreeReference)((Vector)object).elementAt(n);
                if (!vector.contains(externalizable)) {
                    vector.addElement(externalizable);
                }
                TreeReference[] treeReferenceArray = new TreeReference[]{object2, externalizable};
                vector2.addElement(treeReferenceArray);
            }
        }
        boolean bl = true;
        while (vector.size() > 0) {
            int n;
            object2 = new Vector();
            for (n = 0; n < vector.size(); ++n) {
                ((Vector)object2).addElement(vector.elementAt(n));
            }
            for (n = 0; n < vector2.size(); ++n) {
                object = (TreeReference[])vector2.elementAt(n);
                ((Vector)object2).removeElement(object[0]);
            }
            if (((Vector)object2).size() == 0) {
                bl = false;
                break;
            }
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object = (TreeReference)((Vector)object2).elementAt(n);
                vector.removeElement(object);
            }
            for (n = vector2.size() - 1; n >= 0; --n) {
                object = (TreeReference[])vector2.elementAt(n);
                if (!((Vector)object2).contains(object[1])) continue;
                vector2.removeElementAt(n);
            }
        }
        if (!bl) {
            System.err.println("XPath Dependency Cycle:");
            for (int i = 0; i < vector2.size(); ++i) {
                TreeReference[] treeReferenceArray = (TreeReference[])vector2.elementAt(i);
                System.err.println(treeReferenceArray[0].toString() + " => " + treeReferenceArray[1].toString());
            }
            throw new RuntimeException("Dependency cycles amongst the xpath expressions in relevant/calculate");
        }
    }

    public static FormInstance parseDataModelGhettoooooo(InputStream inputStream, InputStream inputStream2, String string) {
        Document document = XFormParser.getXMLDocument(new InputStreamReader(inputStream2));
        Document document2 = XFormParser.getXMLDocument(new InputStreamReader(inputStream));
        FormDef formDef = new FormDef();
        XFormParser.initBindHandlers();
        XFormParser.initStateVars();
        XFormParser.parseElement(formDef, document.getRootElement(), formDef, topLevelHandlers);
        XFormParser.collapseRepeatGroups(formDef);
        instanceNode = document2.getRootElement();
        XFormParser.parseInstance(formDef, instanceNode);
        XFormParser.initStateVars();
        if (string != null) {
            formDef.getLocalizer().setToDefault();
        } else {
            formDef.getLocalizer().setLocale(string);
        }
        return formDef.getInstance();
    }

    private static int getDataType(String string) {
        int n = 0;
        if (string != null) {
            if (string.indexOf(":") != -1) {
                string = string.substring(string.indexOf(":") + 1);
            }
            if (typeMappings.containsKey(string)) {
                n = (Integer)typeMappings.get(string);
            } else {
                n = -1;
                System.err.println("XForm Parse WARNING: unrecognized data type [" + string + "]");
            }
        }
        return n;
    }

    public static void addModelPrototype(int n, TreeElement treeElement) {
        modelPrototypes.addNewPrototype(String.valueOf(n), treeElement.getClass());
    }

    public static void addDataType(String string, int n) {
        typeMappings.put(string, new Integer(n));
    }

    public static void registerControlType(String string, final int n) {
        IElementHandler iElementHandler = new IElementHandler(){

            public void handle(FormDef formDef, Element element, Object object) {
                XFormParser.parseControl((IFormElement)object, element, formDef, n);
            }
        };
        topLevelHandlers.put(string, iElementHandler);
        groupLevelHandlers.put(string, iElementHandler);
    }

    public static void registerHandler(String string, IElementHandler iElementHandler) {
        topLevelHandlers.put(string, iElementHandler);
        groupLevelHandlers.put(string, iElementHandler);
    }

    public static void registerBindHandler(IXFormBindHandler iXFormBindHandler) {
        bindHandlers.addElement(iXFormBindHandler);
    }

    public static String getXMLText(Node node, boolean bl) {
        return node.getChildCount() == 0 ? null : XFormParser.getXMLText(node, 0, bl);
    }

    public static String getXMLText(Node node, int n, boolean bl) {
        StringBuffer stringBuffer = null;
        String string = node.getText(n);
        if (string == null) {
            return null;
        }
        ++n;
        while (n < node.getChildCount() && node.getType(n) == 4) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.append(node.getText(n));
            ++n;
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        if (bl) {
            string = string.trim();
        }
        return string;
    }

    public static FormInstance restoreDataModel(InputStream inputStream, Class clazz) {
        Restorable restorable = clazz != null ? (Restorable)PrototypeFactory.getInstance(clazz) : null;
        Document document = XFormParser.getXMLDocument(new InputStreamReader(inputStream));
        if (document == null) {
            throw new RuntimeException("syntax error in XML instance; could not parse");
        }
        Element element = document.getRootElement();
        TreeElement treeElement = XFormParser.buildInstanceStructure(element, null);
        FormInstance formInstance = new FormInstance(treeElement);
        XFormParser.loadNamespaces(element, formInstance);
        if (restorable != null) {
            RestoreUtils.templateData(restorable, formInstance, null);
        }
        XFormParser.loadInstanceData(element, treeElement, null);
        return formInstance;
    }

    public static FormInstance restoreDataModel(byte[] byArray, Class clazz) {
        return XFormParser.restoreDataModel(new ByteArrayInputStream(byArray), clazz);
    }

    public static String getVagueLocation(Element element) {
        String string;
        Object object;
        String string2 = element.getName();
        Element element2 = element;
        while (element2 != null) {
            object = element2.getParent();
            if (object instanceof Element) {
                element2 = (Element)object;
                string = element2.getName();
                for (int i = 0; i < element2.getAttributeCount(); ++i) {
                    string = string + "[@" + element2.getAttributeName(i) + "=";
                    string = string + element2.getAttributeValue(i) + "]";
                }
                string2 = string + "/" + string2;
                continue;
            }
            element2 = null;
            string2 = "/" + string2;
        }
        object = XFormParser.getVagueElementPrintout(element, 2);
        string = "\n    Problem found at nodeset: " + string2;
        string = string + "\n    With element " + (String)object + "\n";
        return string;
    }

    public static String getVagueElementPrintout(Element element, int n) {
        String string = "<" + element.getName();
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            string = string + " " + element.getAttributeName(i) + "=\"";
            string = string + element.getAttributeValue(i) + "\"";
        }
        if (element.getChildCount() > 0) {
            string = string + ">";
            if (element.getType(0) == 2) {
                string = n > 0 ? string + XFormParser.getVagueElementPrintout((Element)element.getChild(0), n - 1) : string + "...";
            }
        } else {
            string = string + "/>";
        }
        return string;
    }

    static {
        XFormParser.initProcessingRules();
        XFormParser.initTypeMappings();
        modelPrototypes = new PrototypeFactoryDeprecated();
        bindHandlers = new Vector();
        submissionParsers = new Vector();
        serialQuestionID = 1;
        guesses = new String[]{"long", "short", "image", "audio"};
    }
}

