/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathArithExpr
extends XPathBinaryOpExpr {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int MODULO = 4;
    public int op;

    public XPathArithExpr() {
    }

    public XPathArithExpr(int n, XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
        this.op = n;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        double d = XPathFuncExpr.toNumeric(this.a.eval(formInstance, evaluationContext));
        double d2 = XPathFuncExpr.toNumeric(this.b.eval(formInstance, evaluationContext));
        double d3 = 0.0;
        switch (this.op) {
            case 0: {
                d3 = d + d2;
                break;
            }
            case 1: {
                d3 = d - d2;
                break;
            }
            case 2: {
                d3 = d * d2;
                break;
            }
            case 3: {
                d3 = d / d2;
                break;
            }
            case 4: {
                d3 = d % d2;
            }
        }
        return new Double(d3);
    }

    public String toString() {
        String string = null;
        switch (this.op) {
            case 0: {
                string = "+";
                break;
            }
            case 1: {
                string = "-";
                break;
            }
            case 2: {
                string = "*";
                break;
            }
            case 3: {
                string = "/";
                break;
            }
            case 4: {
                string = "%";
            }
        }
        return super.toString(string);
    }

    public boolean equals(Object object) {
        if (object instanceof XPathArithExpr) {
            XPathArithExpr xPathArithExpr = (XPathArithExpr)object;
            return super.equals(object) && this.op == xPathArithExpr.op;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(dataInputStream);
        super.readExternal(dataInputStream, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.op);
        super.writeExternal(dataOutputStream);
    }
}

