/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathCmpExpr
extends XPathBinaryOpExpr {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LTE = 2;
    public static final int GTE = 3;
    public int op;

    public XPathCmpExpr() {
    }

    public XPathCmpExpr(int n, XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
        this.op = n;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        Object object = this.a.eval(formInstance, evaluationContext);
        Object object2 = this.b.eval(formInstance, evaluationContext);
        boolean bl = false;
        object = XPathFuncExpr.toNumeric(object);
        object2 = XPathFuncExpr.toNumeric(object2);
        double d = (Double)object;
        double d2 = (Double)object2;
        switch (this.op) {
            case 0: {
                bl = d < d2;
                break;
            }
            case 1: {
                bl = d > d2;
                break;
            }
            case 2: {
                bl = d <= d2;
                break;
            }
            case 3: {
                bl = d >= d2;
            }
        }
        return new Boolean(bl);
    }

    public String toString() {
        String string = null;
        switch (this.op) {
            case 0: {
                string = "<";
                break;
            }
            case 1: {
                string = ">";
                break;
            }
            case 2: {
                string = "<=";
                break;
            }
            case 3: {
                string = ">=";
            }
        }
        return super.toString(string);
    }

    public boolean equals(Object object) {
        if (object instanceof XPathCmpExpr) {
            XPathCmpExpr xPathCmpExpr = (XPathCmpExpr)object;
            return super.equals(object) && this.op == xPathCmpExpr.op;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(dataInputStream);
        super.readExternal(dataInputStream, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.op);
        super.writeExternal(dataOutputStream);
    }
}

