/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.xpath.expr.XPathArithExpr;
import org.javarosa.xpath.expr.XPathBoolExpr;
import org.javarosa.xpath.expr.XPathCmpExpr;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathFilterExpr;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumNegExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.javarosa.xpath.expr.XPathUnionExpr;
import org.javarosa.xpath.expr.XPathVariableReference;

public abstract class XPathExpression
implements Externalizable {
    int indent;

    public abstract Object eval(FormInstance var1, EvaluationContext var2);

    private void printStr(String string) {
        for (int i = 0; i < 2 * this.indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(string);
    }

    public void printParseTree() {
        this.indent = -1;
        this.print(this);
    }

    public void print(Object object) {
        ++this.indent;
        if (object instanceof XPathStringLiteral) {
            XPathStringLiteral xPathStringLiteral = (XPathStringLiteral)object;
            this.printStr("strlit {" + xPathStringLiteral.s + "}");
        } else if (object instanceof XPathNumericLiteral) {
            XPathNumericLiteral xPathNumericLiteral = (XPathNumericLiteral)object;
            this.printStr("numlit {" + xPathNumericLiteral.d + "}");
        } else if (object instanceof XPathVariableReference) {
            XPathVariableReference xPathVariableReference = (XPathVariableReference)object;
            this.printStr("var {" + xPathVariableReference.id.toString() + "}");
        } else if (object instanceof XPathArithExpr) {
            XPathArithExpr xPathArithExpr = (XPathArithExpr)object;
            String string = null;
            switch (xPathArithExpr.op) {
                case 0: {
                    string = "add";
                    break;
                }
                case 1: {
                    string = "subtr";
                    break;
                }
                case 2: {
                    string = "mult";
                    break;
                }
                case 3: {
                    string = "div";
                    break;
                }
                case 4: {
                    string = "mod";
                }
            }
            this.printStr(string + " {{");
            this.print(xPathArithExpr.a);
            this.printStr(" } {");
            this.print(xPathArithExpr.b);
            this.printStr("}}");
        } else if (object instanceof XPathBoolExpr) {
            XPathBoolExpr xPathBoolExpr = (XPathBoolExpr)object;
            String string = null;
            switch (xPathBoolExpr.op) {
                case 0: {
                    string = "and";
                    break;
                }
                case 1: {
                    string = "or";
                }
            }
            this.printStr(string + " {{");
            this.print(xPathBoolExpr.a);
            this.printStr(" } {");
            this.print(xPathBoolExpr.b);
            this.printStr("}}");
        } else if (object instanceof XPathCmpExpr) {
            XPathCmpExpr xPathCmpExpr = (XPathCmpExpr)object;
            String string = null;
            switch (xPathCmpExpr.op) {
                case 0: {
                    string = "lt";
                    break;
                }
                case 2: {
                    string = "lte";
                    break;
                }
                case 1: {
                    string = "gt";
                    break;
                }
                case 3: {
                    string = "gte";
                }
            }
            this.printStr(string + " {{");
            this.print(xPathCmpExpr.a);
            this.printStr(" } {");
            this.print(xPathCmpExpr.b);
            this.printStr("}}");
        } else if (object instanceof XPathEqExpr) {
            XPathEqExpr xPathEqExpr = (XPathEqExpr)object;
            String string = xPathEqExpr.equal ? "eq" : "neq";
            this.printStr(string + " {{");
            this.print(xPathEqExpr.a);
            this.printStr(" } {");
            this.print(xPathEqExpr.b);
            this.printStr("}}");
        } else if (object instanceof XPathUnionExpr) {
            XPathUnionExpr xPathUnionExpr = (XPathUnionExpr)object;
            this.printStr("union {{");
            this.print(xPathUnionExpr.a);
            this.printStr(" } {");
            this.print(xPathUnionExpr.b);
            this.printStr("}}");
        } else if (object instanceof XPathNumNegExpr) {
            XPathNumNegExpr xPathNumNegExpr = (XPathNumNegExpr)object;
            this.printStr("neg {");
            this.print(xPathNumNegExpr.a);
            this.printStr("}");
        } else if (object instanceof XPathFuncExpr) {
            XPathFuncExpr xPathFuncExpr = (XPathFuncExpr)object;
            if (xPathFuncExpr.args.length == 0) {
                this.printStr("func {" + xPathFuncExpr.id.toString() + ", args {none}}");
            } else {
                this.printStr("func {" + xPathFuncExpr.id.toString() + ", args {{");
                for (int i = 0; i < xPathFuncExpr.args.length; ++i) {
                    this.print(xPathFuncExpr.args[i]);
                    if (i >= xPathFuncExpr.args.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (object instanceof XPathPathExpr) {
            XPathPathExpr xPathPathExpr = (XPathPathExpr)object;
            String string = null;
            switch (xPathPathExpr.init_context) {
                case 0: {
                    string = "root";
                    break;
                }
                case 1: {
                    string = "relative";
                    break;
                }
                case 2: {
                    string = "expr";
                }
            }
            this.printStr("path {init-context:" + string + ",");
            if (xPathPathExpr.init_context == 2) {
                this.printStr(" init-expr:{");
                this.print(xPathPathExpr.filtExpr);
                this.printStr(" }");
            }
            if (xPathPathExpr.steps.length == 0) {
                this.printStr(" steps {none}");
                this.printStr("}");
            } else {
                this.printStr(" steps {{");
                for (int i = 0; i < xPathPathExpr.steps.length; ++i) {
                    this.print(xPathPathExpr.steps[i]);
                    if (i >= xPathPathExpr.steps.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (object instanceof XPathFilterExpr) {
            XPathFilterExpr xPathFilterExpr = (XPathFilterExpr)object;
            this.printStr("filter-expr:{{");
            this.print(xPathFilterExpr.x);
            if (xPathFilterExpr.predicates.length == 0) {
                this.printStr(" } predicates {none}}");
            } else {
                this.printStr(" } predicates {{");
                for (int i = 0; i < xPathFilterExpr.predicates.length; ++i) {
                    this.print(xPathFilterExpr.predicates[i]);
                    if (i >= xPathFilterExpr.predicates.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr(" }}}");
            }
        } else if (object instanceof XPathStep) {
            XPathStep xPathStep = (XPathStep)object;
            String string = null;
            String string2 = null;
            string = XPathStep.axisStr(xPathStep.axis);
            string2 = xPathStep.testStr();
            if (xPathStep.predicates.length == 0) {
                this.printStr("step {axis:" + string + " test:" + string2 + " predicates {none}}");
            } else {
                this.printStr("step {axis:" + string + " test:" + string2 + " predicates {{");
                for (int i = 0; i < xPathStep.predicates.length; ++i) {
                    this.print(xPathStep.predicates[i]);
                    if (i >= xPathStep.predicates.length - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        }
        --this.indent;
    }
}

