/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFilterExpr;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStep;

public class XPathPathExpr
extends XPathExpression {
    public static final int INIT_CONTEXT_ROOT = 0;
    public static final int INIT_CONTEXT_RELATIVE = 1;
    public static final int INIT_CONTEXT_EXPR = 2;
    public int init_context;
    public XPathStep[] steps;
    public XPathFilterExpr filtExpr;

    public XPathPathExpr() {
    }

    public XPathPathExpr(int n, XPathStep[] xPathStepArray) {
        this.init_context = n;
        this.steps = xPathStepArray;
    }

    public XPathPathExpr(XPathFilterExpr xPathFilterExpr, XPathStep[] xPathStepArray) {
        this(2, xPathStepArray);
        this.filtExpr = xPathFilterExpr;
    }

    public TreeReference getReference() throws XPathUnsupportedException {
        return this.getReference(false);
    }

    public TreeReference getReference(boolean bl) throws XPathUnsupportedException {
        boolean bl2;
        TreeReference treeReference = new TreeReference();
        switch (this.init_context) {
            case 0: {
                treeReference.setRefLevel(-1);
                bl2 = false;
                break;
            }
            case 1: {
                treeReference.setRefLevel(0);
                bl2 = true;
                break;
            }
            default: {
                throw new XPathUnsupportedException("filter expression");
            }
        }
        for (int i = 0; i < this.steps.length; ++i) {
            XPathStep xPathStep = this.steps[i];
            if (!bl && xPathStep.predicates.length > 0) {
                throw new XPathUnsupportedException("predicates");
            }
            if (xPathStep.axis == 10) {
                if (xPathStep.test == 3) continue;
                throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
            }
            if (xPathStep.axis == 2) {
                if (!bl2 || xPathStep.test != 3) {
                    throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
                }
                treeReference.incrementRefLevel();
                continue;
            }
            if (xPathStep.axis == 8) {
                if (xPathStep.test == 0) {
                    treeReference.add(xPathStep.name.toString(), -4);
                    bl2 = false;
                    continue;
                }
                throw new XPathUnsupportedException("attribute step other than 'attribute::name");
            }
            if (xPathStep.axis == 0) {
                if (xPathStep.test == 0) {
                    treeReference.add(xPathStep.name.toString(), -1);
                    bl2 = false;
                    continue;
                }
                if (xPathStep.test == 1) {
                    treeReference.add("*", -1);
                    bl2 = false;
                    continue;
                }
                throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
            }
            throw new XPathUnsupportedException("step other than 'child::name', '.', '..'");
        }
        return treeReference;
    }

    public XPathNodeset eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        TreeReference treeReference = this.getReference();
        if (treeReference.isAbsolute() && formInstance.getTemplatePath(treeReference) == null) {
            throw new XPathTypeMismatchException("Node " + treeReference.toString() + " does not exist!");
        }
        TreeReference treeReference2 = treeReference.contextualize(evaluationContext.getContextRef());
        Vector vector = formInstance.expandReference(treeReference2);
        for (int i = 0; i < vector.size(); ++i) {
            if (formInstance.resolveReference((TreeReference)vector.elementAt(i)).isRelevant()) continue;
            vector.removeElementAt(i);
            --i;
        }
        return new XPathNodeset(vector, formInstance, evaluationContext);
    }

    public static Object getRefValue(FormInstance formInstance, EvaluationContext evaluationContext, TreeReference treeReference) {
        if (evaluationContext.isConstraint && treeReference.equals(evaluationContext.getContextRef())) {
            return XPathPathExpr.unpackValue(evaluationContext.candidateValue);
        }
        TreeElement treeElement = formInstance.resolveReference(treeReference);
        if (treeElement == null) {
            throw new XPathTypeMismatchException("Node " + treeReference.toString() + " does not exist!");
        }
        return XPathPathExpr.unpackValue(treeElement.isRelevant() ? treeElement.getValue() : null);
    }

    public static Object unpackValue(IAnswerData iAnswerData) {
        if (iAnswerData == null) {
            return "";
        }
        if (iAnswerData instanceof UncastData) {
            return iAnswerData.getValue();
        }
        if (iAnswerData instanceof IntegerData) {
            return new Double(((Integer)iAnswerData.getValue()).doubleValue());
        }
        if (iAnswerData instanceof DecimalData) {
            return iAnswerData.getValue();
        }
        if (iAnswerData instanceof StringData) {
            return iAnswerData.getValue();
        }
        if (iAnswerData instanceof SelectOneData) {
            return ((Selection)iAnswerData.getValue()).getValue();
        }
        if (iAnswerData instanceof SelectMultiData) {
            return new XFormAnswerDataSerializer().serializeAnswerData(iAnswerData);
        }
        if (iAnswerData instanceof DateData) {
            return iAnswerData.getValue();
        }
        if (iAnswerData instanceof BooleanData) {
            return iAnswerData.getValue();
        }
        System.out.println("warning: unrecognized data type in xpath expr: " + iAnswerData.getClass().getName());
        return iAnswerData.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{path-expr:");
        switch (this.init_context) {
            case 0: {
                stringBuffer.append("abs");
                break;
            }
            case 1: {
                stringBuffer.append("rel");
                break;
            }
            case 2: {
                stringBuffer.append(this.filtExpr.toString());
            }
        }
        stringBuffer.append(",{");
        for (int i = 0; i < this.steps.length; ++i) {
            stringBuffer.append(this.steps[i].toString());
            if (i >= this.steps.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof XPathPathExpr) {
            XPathPathExpr xPathPathExpr = (XPathPathExpr)object;
            if (this.init_context != xPathPathExpr.init_context || this.steps.length != xPathPathExpr.steps.length) {
                return false;
            }
            return ExtUtil.arrayEquals(this.steps, xPathPathExpr.steps) && (this.init_context != 2 || this.filtExpr.equals(xPathPathExpr.filtExpr));
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.init_context = ExtUtil.readInt(dataInputStream);
        if (this.init_context == 2) {
            this.filtExpr = (XPathFilterExpr)ExtUtil.read(dataInputStream, XPathFilterExpr.class, prototypeFactory);
        }
        Vector vector = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(XPathStep.class), prototypeFactory);
        this.steps = new XPathStep[vector.size()];
        for (int i = 0; i < this.steps.length; ++i) {
            this.steps[i] = (XPathStep)vector.elementAt(i);
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.init_context);
        if (this.init_context == 2) {
            ExtUtil.write(dataOutputStream, this.filtExpr);
        }
        Vector<XPathStep> vector = new Vector<XPathStep>();
        for (int i = 0; i < this.steps.length; ++i) {
            vector.addElement(this.steps[i]);
        }
        ExtUtil.write(dataOutputStream, new ExtWrapList(vector));
    }

    public static XPathPathExpr fromRef(TreeReference treeReference) {
        XPathPathExpr xPathPathExpr = new XPathPathExpr();
        xPathPathExpr.init_context = treeReference.isAbsolute() ? 0 : 1;
        xPathPathExpr.steps = new XPathStep[treeReference.size()];
        for (int i = 0; i < xPathPathExpr.steps.length; ++i) {
            xPathPathExpr.steps[i] = treeReference.getName(i).equals("*") ? new XPathStep(0, 1) : new XPathStep(0, new XPathQName(treeReference.getName(i)));
        }
        return xPathPathExpr;
    }
}

