/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeBinaryOp;
import org.javarosa.xpath.parser.ast.ASTNodeFilterExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;
import org.javarosa.xpath.parser.ast.ASTNodeLocPath;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;
import org.javarosa.xpath.parser.ast.ASTNodePredicate;
import org.javarosa.xpath.parser.ast.ASTNodeUnaryOp;

public class Parser {
    public static XPathExpression parse(Vector vector) throws XPathSyntaxException {
        ASTNode aSTNode = Parser.buildParseTree(vector);
        return aSTNode.build();
    }

    public static ASTNode buildParseTree(Vector vector) throws XPathSyntaxException {
        ASTNodeAbstractExpr aSTNodeAbstractExpr = new ASTNodeAbstractExpr();
        for (int i = 0; i < vector.size(); ++i) {
            aSTNodeAbstractExpr.content.addElement(vector.elementAt(i));
        }
        Parser.parseFuncCalls(aSTNodeAbstractExpr);
        Parser.parseParens(aSTNodeAbstractExpr);
        Parser.parsePredicates(aSTNodeAbstractExpr);
        Parser.parseOperators(aSTNodeAbstractExpr);
        Parser.parsePathExpr(aSTNodeAbstractExpr);
        Parser.verifyBaseExpr(aSTNodeAbstractExpr);
        return aSTNodeAbstractExpr;
    }

    private static void parseOperators(ASTNode aSTNode) {
        int[] nArray = new int[]{22};
        int[] nArray2 = new int[]{1};
        int[] nArray3 = new int[]{9, 19};
        int[] nArray4 = new int[]{14, 15, 10, 11};
        int[] nArray5 = new int[]{23, 16};
        int[] nArray6 = new int[]{18, 7, 17};
        int[] nArray7 = new int[]{30};
        Parser.parseBinaryOp(aSTNode, nArray, 2);
        Parser.parseBinaryOp(aSTNode, nArray2, 2);
        Parser.parseBinaryOp(aSTNode, nArray3, 1);
        Parser.parseBinaryOp(aSTNode, nArray4, 1);
        Parser.parseBinaryOp(aSTNode, nArray5, 1);
        Parser.parseBinaryOp(aSTNode, nArray6, 1);
        Parser.parseUnaryOp(aSTNode, 29);
        Parser.parseBinaryOp(aSTNode, nArray7, 1);
    }

    private static void parseFuncCalls(ASTNode aSTNode) throws XPathSyntaxException {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr) {
            object = (ASTNodeAbstractExpr)aSTNode;
            for (int i = 0; i < ((ASTNodeAbstractExpr)object).content.size() - 1; ++i) {
                if (((ASTNodeAbstractExpr)object).getTokenType(i + 1) != 13 || ((ASTNodeAbstractExpr)object).getTokenType(i) != 24) continue;
                Parser.condenseFuncCall((ASTNodeAbstractExpr)object, i);
            }
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.parseFuncCalls((ASTNode)object.nextElement());
        }
    }

    private static void condenseFuncCall(ASTNodeAbstractExpr aSTNodeAbstractExpr, int n) throws XPathSyntaxException {
        ASTNodeFunctionCall aSTNodeFunctionCall = new ASTNodeFunctionCall((XPathQName)aSTNodeAbstractExpr.getToken((int)n).val);
        int n2 = aSTNodeAbstractExpr.indexOfBalanced(n + 1, 26, 13, 26);
        if (n2 == -1) {
            throw new XPathSyntaxException();
        }
        ASTNodeAbstractExpr.Partition partition = aSTNodeAbstractExpr.partitionBalanced(3, n + 1, 13, 26);
        if (partition.pieces.size() != 1 || ((ASTNodeAbstractExpr)partition.pieces.elementAt((int)0)).content.size() != 0) {
            aSTNodeFunctionCall.args = partition.pieces;
        }
        aSTNodeAbstractExpr.condense(aSTNodeFunctionCall, n, n2 + 1);
    }

    private static void parseParens(ASTNode aSTNode) throws XPathSyntaxException {
        Parser.parseBalanced(aSTNode, new SubNodeFactory(){

            public ASTNode newNode(ASTNodeAbstractExpr aSTNodeAbstractExpr) {
                return aSTNodeAbstractExpr;
            }
        }, 13, 26);
    }

    private static void parsePredicates(ASTNode aSTNode) throws XPathSyntaxException {
        Parser.parseBalanced(aSTNode, new SubNodeFactory(){

            public ASTNode newNode(ASTNodeAbstractExpr aSTNodeAbstractExpr) {
                ASTNodePredicate aSTNodePredicate = new ASTNodePredicate();
                aSTNodePredicate.expr = aSTNodeAbstractExpr;
                return aSTNodePredicate;
            }
        }, 12, 25);
    }

    private static void parseBalanced(ASTNode aSTNode, SubNodeFactory subNodeFactory, int n, int n2) throws XPathSyntaxException {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr) {
            object = (ASTNodeAbstractExpr)aSTNode;
            for (int i = 0; i < ((ASTNodeAbstractExpr)object).content.size(); ++i) {
                int n3 = ((ASTNodeAbstractExpr)object).getTokenType(i);
                if (n3 == n2) {
                    throw new XPathSyntaxException();
                }
                if (n3 != n) continue;
                int n4 = ((ASTNodeAbstractExpr)object).indexOfBalanced(i, n2, n, n2);
                if (n4 == -1) {
                    throw new XPathSyntaxException();
                }
                ((ASTNodeAbstractExpr)object).condense(subNodeFactory.newNode(((ASTNodeAbstractExpr)object).extract(i + 1, n4)), i, n4 + 1);
            }
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.parseBalanced((ASTNode)object.nextElement(), subNodeFactory, n, n2);
        }
    }

    private static void parseBinaryOp(ASTNode aSTNode, int[] nArray, int n) {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr) {
            object = (ASTNodeAbstractExpr)aSTNode;
            ASTNodeAbstractExpr.Partition partition = ((ASTNodeAbstractExpr)object).partition(nArray, 0, ((ASTNodeAbstractExpr)object).content.size());
            if (partition.separators.size() != 0) {
                ASTNodeBinaryOp aSTNodeBinaryOp = new ASTNodeBinaryOp();
                aSTNodeBinaryOp.associativity = n;
                aSTNodeBinaryOp.exprs = partition.pieces;
                aSTNodeBinaryOp.ops = partition.separators;
                ((ASTNodeAbstractExpr)object).condense(aSTNodeBinaryOp, 0, ((ASTNodeAbstractExpr)object).content.size());
            }
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.parseBinaryOp((ASTNode)object.nextElement(), nArray, n);
        }
    }

    private static void parseUnaryOp(ASTNode aSTNode, int n) {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr) {
            object = (ASTNodeAbstractExpr)aSTNode;
            if (((ASTNodeAbstractExpr)object).content.size() > 0 && ((ASTNodeAbstractExpr)object).getTokenType(0) == n) {
                ASTNodeUnaryOp aSTNodeUnaryOp = new ASTNodeUnaryOp();
                aSTNodeUnaryOp.op = n;
                aSTNodeUnaryOp.expr = ((ASTNodeAbstractExpr)object).content.size() > 1 ? ((ASTNodeAbstractExpr)object).extract(1, ((ASTNodeAbstractExpr)object).content.size()) : new ASTNodeAbstractExpr();
                ((ASTNodeAbstractExpr)object).condense(aSTNodeUnaryOp, 0, ((ASTNodeAbstractExpr)object).content.size());
            }
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.parseUnaryOp((ASTNode)object.nextElement(), n);
        }
    }

    private static void parsePathExpr(ASTNode aSTNode) throws XPathSyntaxException {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr) {
            ASTNode aSTNode2;
            object = (ASTNodeAbstractExpr)aSTNode;
            int[] nArray = new int[]{27, 6};
            ASTNodeAbstractExpr.Partition partition = ((ASTNodeAbstractExpr)object).partition(nArray, 0, ((ASTNodeAbstractExpr)object).content.size());
            if (partition.separators.size() == 0) {
                if (Parser.isStep((ASTNodeAbstractExpr)object)) {
                    aSTNode2 = Parser.parseStep((ASTNodeAbstractExpr)object);
                    ASTNodeLocPath aSTNodeLocPath = new ASTNodeLocPath();
                    aSTNodeLocPath.clauses.addElement(aSTNode2);
                    ((ASTNodeAbstractExpr)object).condense(aSTNodeLocPath, 0, ((ASTNodeAbstractExpr)object).content.size());
                } else {
                    aSTNode2 = Parser.parseFilterExp((ASTNodeAbstractExpr)object);
                    if (aSTNode2 != null) {
                        ((ASTNodeAbstractExpr)object).condense(aSTNode2, 0, ((ASTNodeAbstractExpr)object).content.size());
                    }
                }
            } else {
                aSTNode2 = new ASTNodeLocPath();
                aSTNode2.separators = partition.separators;
                if (partition.separators.size() != 1 || ((ASTNodeAbstractExpr)object).content.size() != 1 || Parser.vectInt(partition.separators, 0) != 27) {
                    for (int i = 0; i < partition.pieces.size(); ++i) {
                        ASTNode aSTNode3;
                        ASTNodeAbstractExpr aSTNodeAbstractExpr = (ASTNodeAbstractExpr)partition.pieces.elementAt(i);
                        if (Parser.isStep(aSTNodeAbstractExpr)) {
                            aSTNode3 = Parser.parseStep(aSTNodeAbstractExpr);
                            aSTNode2.clauses.addElement(aSTNode3);
                            continue;
                        }
                        if (i == 0) {
                            if (aSTNodeAbstractExpr.content.size() == 0) continue;
                            aSTNode3 = Parser.parseFilterExp(aSTNodeAbstractExpr);
                            if (aSTNode3 != null) {
                                aSTNode2.clauses.addElement(aSTNode3);
                                continue;
                            }
                            aSTNode2.clauses.addElement(aSTNodeAbstractExpr);
                            continue;
                        }
                        throw new XPathSyntaxException();
                    }
                }
                ((ASTNodeAbstractExpr)object).condense(aSTNode2, 0, ((ASTNodeAbstractExpr)object).content.size());
            }
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.parsePathExpr((ASTNode)object.nextElement());
        }
    }

    private static boolean isStep(ASTNodeAbstractExpr aSTNodeAbstractExpr) {
        if (aSTNodeAbstractExpr.content.size() > 0) {
            int n = aSTNodeAbstractExpr.getTokenType(0);
            if (n == 24 || n == 32 || n == 20 || n == 2 || n == 8 || n == 5) {
                return true;
            }
            if (aSTNodeAbstractExpr.content.elementAt(0) instanceof ASTNodeFunctionCall) {
                String string = ((ASTNodeFunctionCall)aSTNodeAbstractExpr.content.elementAt((int)0)).name.toString();
                return string.equals("node") || string.equals("text") || string.equals("comment") || string.equals("processing-instruction");
            }
            return false;
        }
        return false;
    }

    private static ASTNodePathStep parseStep(ASTNodeAbstractExpr aSTNodeAbstractExpr) throws XPathSyntaxException {
        ASTNodePathStep aSTNodePathStep = new ASTNodePathStep();
        if (aSTNodeAbstractExpr.content.size() == 1 && aSTNodeAbstractExpr.getTokenType(0) == 8) {
            aSTNodePathStep.axisType = 3;
            aSTNodePathStep.nodeTestType = 4;
        } else if (aSTNodeAbstractExpr.content.size() == 1 && aSTNodeAbstractExpr.getTokenType(0) == 5) {
            aSTNodePathStep.axisType = 3;
            aSTNodePathStep.nodeTestType = 5;
        } else {
            int n = 0;
            if (aSTNodeAbstractExpr.content.size() > 0 && aSTNodeAbstractExpr.getTokenType(0) == 2) {
                aSTNodePathStep.axisType = 1;
                ++n;
            } else if (aSTNodeAbstractExpr.content.size() > 1 && aSTNodeAbstractExpr.getTokenType(0) == 24 && aSTNodeAbstractExpr.getTokenType(1) == 4) {
                int n2 = ASTNodePathStep.validateAxisName(((XPathQName)aSTNodeAbstractExpr.getToken((int)0).val).toString());
                if (n2 == -1) {
                    throw new XPathSyntaxException();
                }
                aSTNodePathStep.axisType = 2;
                aSTNodePathStep.axisVal = n2;
                n += 2;
            } else {
                aSTNodePathStep.axisType = 3;
            }
            if (aSTNodeAbstractExpr.content.size() > n && aSTNodeAbstractExpr.getTokenType(n) == 32) {
                aSTNodePathStep.nodeTestType = 2;
            } else if (aSTNodeAbstractExpr.content.size() > n && aSTNodeAbstractExpr.getTokenType(n) == 20) {
                aSTNodePathStep.nodeTestType = 3;
                aSTNodePathStep.nodeTestNamespace = (String)aSTNodeAbstractExpr.getToken((int)n).val;
            } else if (aSTNodeAbstractExpr.content.size() > n && aSTNodeAbstractExpr.getTokenType(n) == 24) {
                aSTNodePathStep.nodeTestType = 1;
                aSTNodePathStep.nodeTestQName = (XPathQName)aSTNodeAbstractExpr.getToken((int)n).val;
            } else if (aSTNodeAbstractExpr.content.size() > n && aSTNodeAbstractExpr.content.elementAt(n) instanceof ASTNodeFunctionCall) {
                if (!ASTNodePathStep.validateNodeTypeTest((ASTNodeFunctionCall)aSTNodeAbstractExpr.content.elementAt(n))) {
                    throw new XPathSyntaxException();
                }
                aSTNodePathStep.nodeTestType = 6;
                aSTNodePathStep.nodeTestFunc = (ASTNodeFunctionCall)aSTNodeAbstractExpr.content.elementAt(n);
            } else {
                throw new XPathSyntaxException();
            }
            ++n;
            while (n < aSTNodeAbstractExpr.content.size()) {
                if (!(aSTNodeAbstractExpr.content.elementAt(n) instanceof ASTNodePredicate)) {
                    throw new XPathSyntaxException();
                }
                aSTNodePathStep.predicates.addElement(aSTNodeAbstractExpr.content.elementAt(n));
                ++n;
            }
        }
        return aSTNodePathStep;
    }

    private static ASTNodeFilterExpr parseFilterExp(ASTNodeAbstractExpr aSTNodeAbstractExpr) throws XPathSyntaxException {
        int n;
        ASTNodeFilterExpr aSTNodeFilterExpr = new ASTNodeFilterExpr();
        for (n = aSTNodeAbstractExpr.content.size() - 1; n >= 0 && aSTNodeAbstractExpr.content.elementAt(n) instanceof ASTNodePredicate; --n) {
            aSTNodeFilterExpr.predicates.insertElementAt(aSTNodeAbstractExpr.content.elementAt(n), 0);
        }
        if (aSTNodeFilterExpr.predicates.size() == 0) {
            return null;
        }
        aSTNodeFilterExpr.expr = aSTNodeAbstractExpr.extract(0, n + 1);
        return aSTNodeFilterExpr;
    }

    public static void verifyBaseExpr(ASTNode aSTNode) throws XPathSyntaxException {
        Object object;
        if (aSTNode instanceof ASTNodeAbstractExpr && !((ASTNodeAbstractExpr)(object = (ASTNodeAbstractExpr)aSTNode)).isNormalized()) {
            throw new XPathSyntaxException();
        }
        object = aSTNode.getChildren().elements();
        while (object.hasMoreElements()) {
            Parser.verifyBaseExpr((ASTNode)object.nextElement());
        }
    }

    public static int vectInt(Vector vector, int n) {
        return (Integer)vector.elementAt(n);
    }

    private static abstract class SubNodeFactory {
        private SubNodeFactory() {
        }

        public abstract ASTNode newNode(ASTNodeAbstractExpr var1);
    }
}

