/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.parser.Parser;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeBinaryOp;
import org.javarosa.xpath.parser.ast.ASTNodeFilterExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;
import org.javarosa.xpath.parser.ast.ASTNodeLocPath;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;
import org.javarosa.xpath.parser.ast.ASTNodePredicate;
import org.javarosa.xpath.parser.ast.ASTNodeUnaryOp;

public abstract class ASTNode {
    int indent;

    public abstract Vector getChildren();

    public abstract XPathExpression build() throws XPathSyntaxException;

    private void printStr(String string) {
        for (int i = 0; i < 2 * this.indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(string);
    }

    public void print() {
        this.indent = -1;
        this.print(this);
    }

    public void print(Object object) {
        ++this.indent;
        if (object instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr aSTNodeAbstractExpr = (ASTNodeAbstractExpr)object;
            this.printStr("abstractexpr {");
            for (int i = 0; i < aSTNodeAbstractExpr.content.size(); ++i) {
                if (aSTNodeAbstractExpr.getType(i) == 1) {
                    this.print(aSTNodeAbstractExpr.content.elementAt(i));
                    continue;
                }
                this.printStr(aSTNodeAbstractExpr.getToken(i).toString());
            }
            this.printStr("}");
        } else if (object instanceof ASTNodePredicate) {
            ASTNodePredicate aSTNodePredicate = (ASTNodePredicate)object;
            this.printStr("predicate {");
            this.print(aSTNodePredicate.expr);
            this.printStr("}");
        } else if (object instanceof ASTNodeFunctionCall) {
            ASTNodeFunctionCall aSTNodeFunctionCall = (ASTNodeFunctionCall)object;
            if (aSTNodeFunctionCall.args.size() == 0) {
                this.printStr("func {" + aSTNodeFunctionCall.name.toString() + ", args {none}}");
            } else {
                this.printStr("func {" + aSTNodeFunctionCall.name.toString() + ", args {{");
                for (int i = 0; i < aSTNodeFunctionCall.args.size(); ++i) {
                    this.print(aSTNodeFunctionCall.args.elementAt(i));
                    if (i >= aSTNodeFunctionCall.args.size() - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (object instanceof ASTNodeBinaryOp) {
            ASTNodeBinaryOp aSTNodeBinaryOp = (ASTNodeBinaryOp)object;
            this.printStr("opexpr {");
            block25: for (int i = 0; i < aSTNodeBinaryOp.exprs.size(); ++i) {
                this.print(aSTNodeBinaryOp.exprs.elementAt(i));
                if (i >= aSTNodeBinaryOp.exprs.size() - 1) continue;
                switch (Parser.vectInt(aSTNodeBinaryOp.ops, i)) {
                    case 1: {
                        this.printStr("and:");
                        continue block25;
                    }
                    case 22: {
                        this.printStr("or:");
                        continue block25;
                    }
                    case 9: {
                        this.printStr("eq:");
                        continue block25;
                    }
                    case 19: {
                        this.printStr("neq:");
                        continue block25;
                    }
                    case 14: {
                        this.printStr("lt:");
                        continue block25;
                    }
                    case 15: {
                        this.printStr("lte:");
                        continue block25;
                    }
                    case 10: {
                        this.printStr("gt:");
                        continue block25;
                    }
                    case 11: {
                        this.printStr("gte:");
                        continue block25;
                    }
                    case 23: {
                        this.printStr("plus:");
                        continue block25;
                    }
                    case 16: {
                        this.printStr("minus:");
                        continue block25;
                    }
                    case 7: {
                        this.printStr("div:");
                        continue block25;
                    }
                    case 17: {
                        this.printStr("mod:");
                        continue block25;
                    }
                    case 18: {
                        this.printStr("mult:");
                        continue block25;
                    }
                    case 30: {
                        this.printStr("union:");
                    }
                }
            }
            this.printStr("}");
        } else if (object instanceof ASTNodeUnaryOp) {
            ASTNodeUnaryOp aSTNodeUnaryOp = (ASTNodeUnaryOp)object;
            this.printStr("opexpr {");
            switch (aSTNodeUnaryOp.op) {
                case 29: {
                    this.printStr("num-neg:");
                }
            }
            this.print(aSTNodeUnaryOp.expr);
            this.printStr("}");
        } else if (object instanceof ASTNodeLocPath) {
            ASTNodeLocPath aSTNodeLocPath = (ASTNodeLocPath)object;
            this.printStr("pathexpr {");
            int n = aSTNodeLocPath.isAbsolute() ? 1 : 0;
            block26: for (int i = 0; i < aSTNodeLocPath.clauses.size() + n; ++i) {
                if (n == 0 || i > 0) {
                    this.print(aSTNodeLocPath.clauses.elementAt(i - n));
                }
                if (i >= aSTNodeLocPath.separators.size()) continue;
                switch (Parser.vectInt(aSTNodeLocPath.separators, i)) {
                    case 6: {
                        this.printStr("dbl-slash:");
                        continue block26;
                    }
                    case 27: {
                        this.printStr("slash:");
                    }
                }
            }
            this.printStr("}");
        } else if (object instanceof ASTNodePathStep) {
            ASTNodePathStep aSTNodePathStep = (ASTNodePathStep)object;
            this.printStr("step {axis: " + aSTNodePathStep.axisType + " node test type: " + aSTNodePathStep.nodeTestType);
            if (aSTNodePathStep.axisType == 2) {
                this.printStr("  axis type: " + aSTNodePathStep.axisVal);
            }
            if (aSTNodePathStep.nodeTestType == 1) {
                this.printStr("  node test name: " + aSTNodePathStep.nodeTestQName.toString());
            }
            if (aSTNodePathStep.nodeTestType == 6) {
                this.print(aSTNodePathStep.nodeTestFunc);
            }
            this.printStr("predicates...");
            Enumeration enumeration = aSTNodePathStep.predicates.elements();
            while (enumeration.hasMoreElements()) {
                this.print(enumeration.nextElement());
            }
            this.printStr("}");
        } else if (object instanceof ASTNodeFilterExpr) {
            ASTNodeFilterExpr aSTNodeFilterExpr = (ASTNodeFilterExpr)object;
            this.printStr("filter expr {");
            this.print(aSTNodeFilterExpr.expr);
            this.printStr("predicates...");
            Enumeration enumeration = aSTNodeFilterExpr.predicates.elements();
            while (enumeration.hasMoreElements()) {
                this.print(enumeration.nextElement());
            }
            this.printStr("}");
        }
        --this.indent;
    }
}

