/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;

public class ASTNodePathStep
extends ASTNode {
    public static final int AXIS_TYPE_ABBR = 1;
    public static final int AXIS_TYPE_EXPLICIT = 2;
    public static final int AXIS_TYPE_NULL = 3;
    public static final int NODE_TEST_TYPE_QNAME = 1;
    public static final int NODE_TEST_TYPE_WILDCARD = 2;
    public static final int NODE_TEST_TYPE_NSWILDCARD = 3;
    public static final int NODE_TEST_TYPE_ABBR_DOT = 4;
    public static final int NODE_TEST_TYPE_ABBR_DBL_DOT = 5;
    public static final int NODE_TEST_TYPE_FUNC = 6;
    public int axisType;
    public int axisVal;
    public int nodeTestType;
    public ASTNodeFunctionCall nodeTestFunc;
    public XPathQName nodeTestQName;
    public String nodeTestNamespace;
    public Vector predicates = new Vector();

    public Vector getChildren() {
        return this.predicates;
    }

    public XPathExpression build() {
        return null;
    }

    public XPathStep getStep() throws XPathSyntaxException {
        int n;
        XPathExpression[] xPathExpressionArray;
        XPathStep xPathStep;
        if (this.nodeTestType == 4) {
            return XPathStep.ABBR_SELF();
        }
        if (this.nodeTestType == 5) {
            return XPathStep.ABBR_PARENT();
        }
        if (this.axisType == 3) {
            this.axisVal = 0;
        } else if (this.axisType == 1) {
            this.axisVal = 8;
        }
        if (this.nodeTestType == 1) {
            xPathStep = new XPathStep(this.axisVal, this.nodeTestQName);
        } else if (this.nodeTestType == 2) {
            xPathStep = new XPathStep(this.axisVal, 1);
        } else if (this.nodeTestType == 3) {
            xPathStep = new XPathStep(this.axisVal, this.nodeTestNamespace);
        } else {
            xPathExpressionArray = this.nodeTestFunc.name.toString();
            if (xPathExpressionArray.equals("node")) {
                n = 3;
            } else if (xPathExpressionArray.equals("text")) {
                n = 4;
            } else if (xPathExpressionArray.equals("comment")) {
                n = 5;
            } else if (xPathExpressionArray.equals("processing-instruction")) {
                n = 6;
            } else {
                throw new RuntimeException();
            }
            xPathStep = new XPathStep(this.axisVal, n);
            if (this.nodeTestFunc.args.size() > 0) {
                xPathStep.literal = (String)((ASTNodeAbstractExpr)this.nodeTestFunc.args.elementAt((int)0)).getToken((int)0).val;
            }
        }
        xPathExpressionArray = new XPathExpression[this.predicates.size()];
        for (n = 0; n < xPathExpressionArray.length; ++n) {
            xPathExpressionArray[n] = ((ASTNode)this.predicates.elementAt(n)).build();
        }
        xPathStep.predicates = xPathExpressionArray;
        return xPathStep;
    }

    public static int validateAxisName(String string) {
        int n = -1;
        if (string.equals("child")) {
            n = 0;
        } else if (string.equals("descendant")) {
            n = 1;
        } else if (string.equals("parent")) {
            n = 2;
        } else if (string.equals("ancestor")) {
            n = 3;
        } else if (string.equals("following-sibling")) {
            n = 4;
        } else if (string.equals("preceding-sibling")) {
            n = 5;
        } else if (string.equals("following")) {
            n = 6;
        } else if (string.equals("preceding")) {
            n = 7;
        } else if (string.equals("attribute")) {
            n = 8;
        } else if (string.equals("namespace")) {
            n = 9;
        } else if (string.equals("self")) {
            n = 10;
        } else if (string.equals("descendant-or-self")) {
            n = 11;
        } else if (string.equals("ancestor-or-self")) {
            n = 12;
        }
        return n;
    }

    public static boolean validateNodeTypeTest(ASTNodeFunctionCall aSTNodeFunctionCall) {
        String string = aSTNodeFunctionCall.name.toString();
        if (string.equals("node") || string.equals("text") || string.equals("comment") || string.equals("processing-instruction")) {
            if (aSTNodeFunctionCall.args.size() == 0) {
                return true;
            }
            if (string.equals("processing-instruction") && aSTNodeFunctionCall.args.size() == 1) {
                ASTNodeAbstractExpr aSTNodeAbstractExpr = (ASTNodeAbstractExpr)aSTNodeFunctionCall.args.elementAt(0);
                return aSTNodeAbstractExpr.content.size() == 1 && aSTNodeAbstractExpr.getTokenType(0) == 28;
            }
            return false;
        }
        return false;
    }
}

