/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import javax.xml.rpc.ServiceException;

public class GetFileCatalogWS
extends WSTool {
    protected static final String MR_FLAG = "s";
    protected static final String DEST_FLAG = "f";

    public void loadHelpText() {
        super.loadHelpText();
        this.helpText.put(MR_FLAG, "MR Session ID");
        this.helpText.put(DEST_FLAG, "File to Output (i.e. './catalog.xml')");
    }

    public void displayHelp() {
        System.out.println("\nRequest File Catalog for MRSession Web Service\n");
        this.displayCommonHelp();
        this.printHelpLine(MR_FLAG);
        this.printHelpLine(DEST_FLAG);
    }

    public static void main(String[] args) {
        GetFileCatalogWS serv = new GetFileCatalogWS();
        serv.perform(args);
    }

    public void process() {
        if (this.arguments.get(MR_FLAG) == null) {
            this.displayHelp();
            System.exit(5);
        }
        if (this.arguments.get(DEST_FLAG) == null) {
            this.displayHelp();
            System.exit(6);
        }
        try {
            String service_session = this.createServiceSession();
            String mr = (String)this.arguments.get(MR_FLAG);
            String dest = (String)this.arguments.get(DEST_FLAG);
            String urlString = String.valueOf(this.host) + "app/template/GetFileCatalog.vm/search_element/xnat:mrSessionData/search_field/xnat:mrSessionData.ID/search_value/" + mr;
            try {
                int bytesRead;
                URLConnection url = new URL(urlString).openConnection();
                url.setRequestProperty("Cookie", "JSESSIONID=" + service_session);
                InputStream bis = null;
                BufferedOutputStream bos = null;
                File outFile = new File(dest);
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    bis = url.getInputStream();
                }
                catch (FileNotFoundException e) {
                    this.error(39, "File not found on server.  Please review the -s parameter", e);
                }
                bos = new BufferedOutputStream(out);
                byte[] buff = new byte[256];
                int loaded = 0;
                NumberFormat nf = NumberFormat.getInstance();
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                    bos.flush();
                    loaded += bytesRead;
                }
                bis.close();
                bos.flush();
                bos.close();
                out.close();
                if (!this.quiet) {
                    System.out.println(outFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                this.error(37, e.getMessage(), e);
            }
            catch (IOException e) {
                this.error(38, e.getMessage(), e);
            }
        }
        catch (MalformedURLException e) {
            this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
        }
        catch (RemoteException ex) {
            this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            this.error(11, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
    }
}

