/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class WSTool {
    protected String userName = null;
    protected String password = null;
    protected String host = null;
    protected String proxy = "";
    protected String proxyPort = "";
    protected String userSessionID = null;
    protected boolean quiet = false;
    protected Hashtable arguments = null;
    private Service service = new Service();
    private File propFile = null;
    private Properties props = null;
    private String defaultUser = null;
    private String defaultHost = null;
    private String defaultPswd = null;
    protected HashMap helpText = null;
    private boolean usingDefaultHost = false;
    private boolean usingDefaultUser = false;
    protected boolean proxySet = false;
    protected boolean proxyPortSet = false;
    protected boolean externalSessionID = false;
    protected static final String PROP_FILE_NAME = ".xnatPass";
    protected static final String HOST_FLAG = "host";
    protected static final String USER_FLAG = "u";
    protected static final String PASSWORD_FLAG = "p";
    protected static final String UNZIP_FLAG = "z";
    protected static final String README_FLAG = "readme";
    protected static final String DECOMPRESS_FLAG = "di";
    protected static final String PROXY_FLAG = "proxy";
    protected static final String PROXY_PORT_FLAG = "proxyPort";
    protected static final String HELP_FLAG = "h";
    protected static final String QUIET_FLAG = "quiet";
    protected static final String DASH = "-";
    protected static final String USER_SESSION_FLAG = "user_session";
    protected static final char DEFAULT_CHAR = '+';
    protected static final int HELP_SPACES = 12;
    protected static final boolean DEBUG = false;

    public WSTool() {
        this.loadHelpText();
    }

    public WSTool(String[] args) {
        this();
        this.perform(args);
    }

    public void perform(String[] args) {
        try {
            this.convertArguments(args);
            if (this.arguments.containsKey(HELP_FLAG)) {
                this.displayHelp();
                return;
            }
            try {
                this.manageLogin();
            }
            catch (MalformedURLException e) {
                this.error(12, "Unknown URL: " + this.host, e);
            }
            catch (IOException e) {
                this.error(13, "Unable to connect to Web Service Server: " + this.host, e);
            }
            this.process();
        }
        catch (RuntimeException e) {
            this.error(40, "Unknown Exception. Contact technical support", e);
        }
    }

    protected void loadProperties() {
        String fileName = "." + File.separator + PROP_FILE_NAME;
        this.propFile = new File(fileName);
        if (!this.propFile.exists()) {
            String home = this.addFinalChar(System.getProperty("user.home"), File.separator);
            this.propFile = new File(String.valueOf(home) + PROP_FILE_NAME);
        }
        if (this.propFile.exists()) {
            try {
                FileInputStream f = new FileInputStream(this.propFile);
                this.props = new Properties();
                this.props.load(f);
                ((InputStream)f).close();
                this.setDefaults();
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    protected void setDefaults() {
        Enumeration<?> names = this.props.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            char firstCh = key.charAt(0);
            if (firstCh != '+') continue;
            String[] hostUser = key.split("@");
            this.defaultUser = hostUser[0].substring(1);
            this.defaultHost = this.addFinalChar(hostUser[1], "/");
            this.defaultPswd = this.props.getProperty(key);
        }
    }

    protected void error(int errNo, String msg, Throwable e) {
        System.out.println("ERROR CODE " + errNo + ": " + msg + ".");
        if (e == null) {
            this.displayHelp();
        } else {
            this.logError(e);
        }
        System.exit(errNo);
    }

    protected void findHost() {
        if (this.arguments.containsKey(HOST_FLAG)) {
            Object o = this.arguments.get(HOST_FLAG);
            if (o instanceof ArrayList) {
                this.host = (String)((ArrayList)o).get(((ArrayList)o).size() - 1);
                System.out.println("Using host: " + this.host);
            } else {
                this.host = (String)o;
            }
        } else {
            this.host = this.defaultHost;
            this.usingDefaultHost = true;
            if (!this.quiet) {
                System.out.println("Connecting to " + this.host);
            }
        }
        if (this.host == null) {
            System.out.println("Missing Host.");
            this.displayHelp();
            System.exit(1);
        }
        if (!this.host.startsWith("http://")) {
            this.host = "http://" + this.host;
        }
        this.host = this.addFinalChar(this.host, "/");
    }

    protected void findProxy() {
        if (this.arguments.containsKey(PROXY_FLAG)) {
            this.proxy = (String)this.arguments.get(PROXY_FLAG);
            this.proxySet = true;
        }
    }

    protected void findProxyPort() {
        if (this.arguments.containsKey(PROXY_PORT_FLAG)) {
            this.proxyPort = (String)this.arguments.get(PROXY_PORT_FLAG);
            this.proxyPortSet = true;
        }
    }

    protected String addFinalChar(String s, String terminal) {
        if (!s.endsWith(terminal)) {
            s = String.valueOf(s) + terminal;
        }
        return s;
    }

    protected void findUser() throws IOException {
        if (this.arguments.containsKey(USER_FLAG)) {
            Object o = this.arguments.get(USER_FLAG);
            if (o instanceof ArrayList) {
                this.error(8, "Multiple usernames defined", null);
            }
            this.userName = (String)o;
        } else if (this.usingDefaultHost) {
            this.userName = this.defaultUser;
            this.usingDefaultUser = true;
        }
        if (this.userName == null && this.userSessionID == null) {
            System.out.println("Enter username for " + this.host + ":");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            this.userName = in.readLine();
            if (this.userName == null || this.userName.equals("")) {
                this.error(2, "Missing Username", null);
            }
        }
    }

    public boolean manageServiceSessionID() {
        if (this.arguments.containsKey(USER_SESSION_FLAG)) {
            this.userSessionID = (String)this.arguments.get(USER_SESSION_FLAG);
            return true;
        }
        return false;
    }

    public void manageLogin() throws MalformedURLException, IOException {
        this.loadProperties();
        String q = (String)this.arguments.get(QUIET_FLAG);
        if (q != null && !(q instanceof ArrayList) && q.equalsIgnoreCase("true")) {
            this.quiet = true;
        }
        this.manageServiceSessionID();
        this.findHost();
        this.findUser();
        this.findPassword();
        this.findProxy();
        this.findProxyPort();
        if (this.proxySet) {
            Properties systemSettings = System.getProperties();
            ((Hashtable)systemSettings).put("http.proxyHost", this.proxy);
            if (this.proxyPortSet) {
                ((Hashtable)systemSettings).put("http.proxyPort", this.proxyPort);
            }
            System.setProperties(systemSettings);
        }
        URL url = new URL(String.valueOf(this.host) + "axis/XMLSearch.jws");
        url.getContent();
    }

    public void logError(String message) {
        File outFile = null;
        FileOutputStream outFileStream = null;
        PrintWriter outPrintWriter = null;
        outFile = new File("error.log");
        try {
            outFileStream = new FileOutputStream(outFile, true);
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
        outPrintWriter = new PrintWriter(outFileStream);
        outPrintWriter.print(Calendar.getInstance().getTime() + " " + this.userName + "@" + this.host + ": ");
        outPrintWriter.println(message);
        outPrintWriter.flush();
        outPrintWriter.close();
        System.out.println("Error logged in " + outFile.getAbsolutePath());
        try {
            outFileStream.close();
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
    }

    public void logError(Throwable e) {
        File outFile = null;
        FileOutputStream outFileStream = null;
        PrintWriter outPrintWriter = null;
        outFile = new File("error.log");
        try {
            outFileStream = new FileOutputStream(outFile, true);
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
        outPrintWriter = new PrintWriter(outFileStream);
        outPrintWriter.print(Calendar.getInstance().getTime() + " " + this.userName + "@" + this.host + ":");
        e.printStackTrace(outPrintWriter);
        outPrintWriter.flush();
        outPrintWriter.close();
        System.out.println("Error logged in " + outFile.getAbsolutePath());
        try {
            outFileStream.close();
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
    }

    public static void outputToFile(String content, String filePath, boolean append) {
        File outFile = null;
        FileOutputStream outFileStream = null;
        PrintWriter outPrintWriter = null;
        outFile = new File(filePath);
        try {
            outFileStream = new FileOutputStream(outFile, append);
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
        outPrintWriter = new PrintWriter(outFileStream);
        outPrintWriter.println(content);
        outPrintWriter.flush();
        outPrintWriter.close();
        try {
            outFileStream.close();
        }
        catch (IOException except) {
            System.out.println(except.getMessage());
        }
    }

    public abstract void displayHelp();

    public abstract void process();

    protected void findPassword() throws IOException {
        String formattedHost = this.host;
        if (this.arguments.containsKey(PASSWORD_FLAG)) {
            Object o = this.arguments.get(PASSWORD_FLAG);
            if (o instanceof ArrayList) {
                this.password = (String)((ArrayList)o).get(((ArrayList)o).size() - 1);
                System.out.println("Using host: " + this.host);
            } else {
                this.password = (String)o;
            }
        } else if (this.password == null) {
            if (this.props != null) {
                this.password = this.props.getProperty(String.valueOf(this.userName) + "@" + formattedHost);
                if (this.password == null) {
                    this.password = this.props.getProperty("+" + this.userName + "@" + formattedHost);
                }
                if (this.password == null) {
                    this.password = this.props.getProperty("*@" + formattedHost);
                }
                if (this.password == null && this.host.startsWith("http://")) {
                    formattedHost = formattedHost.substring(7);
                    this.password = this.props.getProperty(String.valueOf(this.userName) + "@" + formattedHost);
                }
                if (this.password == null) {
                    this.password = this.props.getProperty("+" + this.userName + "@" + formattedHost);
                }
                if (this.password == null) {
                    this.password = this.props.getProperty("*@" + formattedHost);
                }
                if (this.password == null) {
                    formattedHost = formattedHost.replace(':', '.');
                    this.password = this.props.getProperty(String.valueOf(this.userName) + "@" + formattedHost);
                }
                if (this.password == null) {
                    this.password = this.props.getProperty("+" + this.userName + "@" + formattedHost);
                }
                if (this.password == null) {
                    this.password = this.props.getProperty(String.valueOf(this.userName) + "@*");
                }
            }
            if (this.password == null && this.usingDefaultUser) {
                this.password = this.defaultPswd;
            }
            if (this.password == null && this.userSessionID == null) {
                char[] inputPassword = this.readPassword(System.in, "Enter " + this.userName + "'s Password\n");
                if (inputPassword == null) {
                    this.error(3, "Missing Password", null);
                } else {
                    this.password = String.valueOf(inputPassword);
                }
            }
        }
    }

    protected Hashtable convertArguments(String[] args) {
        this.arguments = new Hashtable();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith(DASH)) {
                arg = arg.substring(1);
                if (i + 1 < args.length) {
                    String value = args[i + 1];
                    if (this.arguments.get(arg) == null) {
                        if (value.startsWith(DASH)) {
                            this.arguments.put(arg, "true");
                        } else {
                            this.arguments.put(arg, value);
                            ++i;
                        }
                    } else {
                        Object o = this.arguments.get(arg);
                        ArrayList<Object> al = null;
                        if (o instanceof ArrayList) {
                            al = (ArrayList<Object>)o;
                        } else {
                            al = new ArrayList<Object>();
                            al.add(o);
                        }
                        if (value.startsWith(DASH)) {
                            al.add("true");
                        } else {
                            al.add(value);
                            ++i;
                        }
                        this.arguments.put(arg, al);
                    }
                } else if (this.arguments.get(arg) == null) {
                    this.arguments.put(arg, "true");
                } else {
                    Object o = this.arguments.get(arg);
                    ArrayList<Object> al = null;
                    if (o instanceof ArrayList) {
                        al = (ArrayList<Object>)o;
                    } else {
                        al = new ArrayList<Object>();
                        al.add(o);
                    }
                    al.add("true");
                    this.arguments.put(arg, al);
                }
            } else {
                this.arguments.put(arg, arg);
            }
            ++i;
        }
        return this.arguments;
    }

    protected Service getService() {
        this.service.setMaintainSession(true);
        return this.service;
    }

    protected Call createCall(String session) throws ServiceException {
        Call call = (Call)this.getService().createCall();
        call.setMaintainSession(true);
        if (this.userName != null) {
            call.setUsername(this.userName);
        }
        if (this.password != null) {
            call.setPassword(this.password);
        }
        if (session != null) {
            call.setProperty("Cookie", (Object)("JSESSIONID=" + session));
        }
        return call;
    }

    public String createServiceSession() throws ServiceException, MalformedURLException, RemoteException {
        if (this.userSessionID == null) {
            Call call = this.createCall(null);
            URL requestSessionURL = new URL(String.valueOf(this.host) + "axis/CreateServiceSession.jws");
            call.setTargetEndpointAddress(requestSessionURL);
            call.setOperationName("execute");
            Object[] params = new Object[]{};
            this.userSessionID = (String)call.invoke(params);
            return this.userSessionID;
        }
        this.externalSessionID = true;
        String service_session = this.userSessionID;
        this.userSessionID = this.refreshServiceSession(service_session);
        service_session.equals(this.userSessionID);
        return this.userSessionID;
    }

    public String getJSessionID(Message message) {
        String[] header = message.getMimeHeaders().getHeader("set-cookie");
        if (header != null) {
            String value = header[0];
            int start = value.indexOf("=");
            int end = value.indexOf(";");
            if (start == -1) {
                return value;
            }
            if (end == -1) {
                return value.substring(start + 1);
            }
            return value.substring(start + 1, end);
        }
        return null;
    }

    public String refreshServiceSession(String service_session) throws ServiceException, MalformedURLException, RemoteException {
        Call call = this.createCall(this.userSessionID);
        call.setMaintainSession(true);
        URL requestSessionURL = new URL(String.valueOf(this.host) + "axis/RefreshServiceSession.jws");
        call.setTargetEndpointAddress(requestSessionURL);
        call.setOperationName("execute");
        Object[] params = new Object[]{service_session};
        this.userSessionID = (String)call.invoke(params);
        return this.userSessionID;
    }

    public void closeServiceSession(String service_session) throws ServiceException, MalformedURLException, RemoteException {
        if (service_session != null && !this.externalSessionID) {
            Call call = this.createCall(this.userSessionID);
            URL requestSessionURL = new URL(String.valueOf(this.host) + "axis/CloseServiceSession.jws");
            call.setTargetEndpointAddress(requestSessionURL);
            call.setOperationName("execute");
            Object[] params = new Object[]{service_session};
            call.invoke(params);
        }
    }

    public void writeXMLtoOS(String host, String service_session, Object id, String dataType, String dir, boolean quiet, OutputStream out) throws FileNotFoundException, MalformedURLException, IOException, SAXException, ParserConfigurationException {
        int bytesRead;
        if (!quiet) {
            System.out.println("Requesting xml for " + id);
        }
        long startTime = Calendar.getInstance().getTimeInMillis();
        String urlString = String.valueOf(host) + "app/template/XMLSearch.vm/session/" + service_session + "/id/" + id + "/data_type/" + dataType;
        URLConnection url = new URL(urlString).openConnection();
        url.setRequestProperty("Cookie", "JSESSIONID=" + service_session);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(url.getInputStream());
        }
        catch (FileNotFoundException e) {
            this.error(39, "File not found on server.  Please review the search parameters", e);
        }
        bos = new BufferedOutputStream(out);
        byte[] buff = new byte[2048];
        while (-1 != (bytesRead = ((InputStream)bis).read(buff, 0, buff.length))) {
            bos.write(buff, 0, bytesRead);
        }
        bos.flush();
        if (!quiet) {
            System.out.println("Response Received (" + (Calendar.getInstance().getTimeInMillis() - startTime) + " ms)");
        }
    }

    public boolean isValidXMLFile(File data) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            sp.parse(data, new DefaultHandler());
            return true;
        }
        catch (Exception e) {
            this.logError(e);
            return false;
        }
    }

    public Object[] getIdentifiers(String service_session, String field, String comparison, String value, String dataType) throws ServiceException, MalformedURLException, RemoteException {
        URL url = new URL(String.valueOf(this.host) + "axis/GetIdentifiers.jws");
        Call call = this.createCall(this.userSessionID);
        call.setTargetEndpointAddress(url);
        call.setOperationName("search");
        Object[] params = new Object[]{service_session, field, comparison, value, dataType};
        if (!this.quiet) {
            System.out.println("Requesting matching IDs...");
        }
        long startTime = Calendar.getInstance().getTimeInMillis();
        Object[] o = (Object[])call.invoke(params);
        long duration = Calendar.getInstance().getTimeInMillis() - startTime;
        if (!this.quiet) {
            System.out.println("Response Received (" + duration + " ms)");
        }
        return o;
    }

    public final char[] readPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public void printHelpLine(String flag) {
        int spaces = 12 - flag.length();
        String spacing = "";
        int i = 0;
        while (i < spaces) {
            spacing = String.valueOf(spacing) + " ";
            ++i;
        }
        System.out.println(DASH + flag + spacing + this.helpText.get(flag));
    }

    protected void loadHelpText() {
        this.helpText = new HashMap();
        this.helpText.put(USER_FLAG, "USERNAME");
        this.helpText.put(PASSWORD_FLAG, "PASSWORD");
        this.helpText.put(USER_SESSION_FLAG, "User Session ID: replaces username/password, available from CreateUserSession");
        this.helpText.put(HOST_FLAG, "URL to XNAT based website.  (i.e. http://localhost/xnat).");
        this.helpText.put(UNZIP_FLAG, "Unzip directory VALUES(true,false) (defaults to false).");
        this.helpText.put(README_FLAG, "Whether or not to download the readme file for this session.");
        this.helpText.put(DECOMPRESS_FLAG, "Decompress images. (By default images within the archive are compressed).");
        this.helpText.put(PROXY_FLAG, "Proxy server.");
        this.helpText.put(PROXY_PORT_FLAG, "Proxy server port. (defaults to 80).");
        this.helpText.put(HELP_FLAG, "Print help.");
        this.helpText.put(QUIET_FLAG, "Suppress messages.");
    }

    protected void displayCommonHelp() {
        System.out.println("");
        System.out.println("Parameters:");
        this.printHelpLine(USER_FLAG);
        this.printHelpLine(PASSWORD_FLAG);
        this.printHelpLine(USER_SESSION_FLAG);
        this.printHelpLine(HOST_FLAG);
        this.printHelpLine(PROXY_FLAG);
        this.printHelpLine(PROXY_PORT_FLAG);
        this.printHelpLine(HELP_FLAG);
        this.printHelpLine(QUIET_FLAG);
    }

    public void debug(String msg) {
    }

    public void debug(String method, String msg) {
        this.debug(String.valueOf(method) + ":: " + msg);
    }

    public static ArrayList FileLinesToArrayList(File f) throws FileNotFoundException, IOException {
        ArrayList<String> al = new ArrayList<String>();
        FileInputStream in = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(in);
        StringBuffer sb = new StringBuffer();
        while (dis.available() != 0) {
            String s = dis.readLine();
            if (s.indexOf(44) == -1) {
                al.add(s.trim());
                continue;
            }
            al.addAll(WSTool.DelimitedStringToArrayList(s, ","));
        }
        dis.close();
        return al;
    }

    public static ArrayList DelimitedStringToArrayList(String s, String delimiter) {
        ArrayList<String> al = new ArrayList<String>();
        while (s.indexOf(delimiter) != -1) {
            al.add(s.substring(0, s.indexOf(delimiter)).trim());
            s = s.substring(s.indexOf(delimiter) + 1);
        }
        if (s.length() > 0) {
            al.add(s.trim());
        }
        return al;
    }

    public class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)42;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    try {
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

