/*
 * Decompiled with CFR 0.152.
 */
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;

public class RefreshUserSession
extends WSTool {
    public void loadHelpText() {
        this.helpText = new HashMap();
        this.helpText.put("u", "USERNAME");
        this.helpText.put("p", "PASSWORD");
        this.helpText.put("user_session", "User Session ID to refresh");
        this.helpText.put("host", "URL to XNAT based website.  (i.e. http://localhost/xnat).");
        this.helpText.put("z", "Unzip directory VALUES(true,false) (defaults to false).");
        this.helpText.put("readme", "Whether or not to download the readme file for this session.");
        this.helpText.put("di", "Decompress images. (By default images within the archive are compressed).");
        this.helpText.put("proxy", "Proxy server.");
        this.helpText.put("proxyPort", "Proxy server port. (defaults to 80).");
        this.helpText.put("h", "Print help.");
        this.helpText.put("quiet", "Suppress messages.");
    }

    public void displayHelp() {
        System.out.println("\nRefresh User Web Service Session\n");
        this.displayCommonHelp();
    }

    public static void main(String[] args) {
        RefreshUserSession serv = new RefreshUserSession();
        serv.perform(args);
    }

    public void process() {
        if (this.arguments.get("user_session") == null) {
            this.displayHelp();
            System.exit(4);
        }
        try {
            String service_session = (String)this.arguments.get("user_session");
            service_session = this.refreshServiceSession(service_session);
            System.out.println(service_session);
        }
        catch (MalformedURLException e) {
            this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
        }
        catch (AxisFault ex2) {
            String fault = ex2.getFaultString();
            if (fault == null) {
                this.error(33, "Web Service Exception: " + this.host + "\n" + ((RemoteException)((Object)ex2)).getMessage(), ex2);
            } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                this.error(99, "Invalid Password.", ex2);
            } else if (fault.indexOf("FailedLoginException") != -1) {
                this.error(98, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("UserNotFoundException") != -1) {
                this.error(97, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("EnabledException") != -1) {
                this.error(96, "Failed Login. Account disabled.", ex2);
            } else {
                this.error(32, "Web Service Exception @ " + this.host + "\n" + fault, ex2);
            }
        }
        catch (RemoteException ex) {
            this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            this.error(11, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
    }
}

