/*
 * Decompiled with CFR 0.152.
 */
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;

public class CreateUserSession
extends WSTool {
    public void loadHelpText() {
        super.loadHelpText();
    }

    public void displayHelp() {
        System.out.println("\nCreate User Web Service Session\n");
        System.out.println("");
        System.out.println("Parameters:");
        this.printHelpLine("u");
        this.printHelpLine("p");
        this.printHelpLine("host");
        this.printHelpLine("proxy");
        this.printHelpLine("proxyPort");
        this.printHelpLine("h");
        this.printHelpLine("quiet");
    }

    public static void main(String[] args) {
        CreateUserSession serv = new CreateUserSession();
        serv.perform(args);
    }

    public void process() {
        try {
            String service_session = this.createServiceSession();
            System.out.println(service_session);
        }
        catch (MalformedURLException e) {
            this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
        }
        catch (AxisFault ex2) {
            String fault = ex2.getFaultString();
            if (fault == null) {
                this.error(33, "Web Service Exception: " + this.host + "\n" + ((RemoteException)((Object)ex2)).getMessage(), ex2);
            } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                this.error(99, "Invalid Password.", ex2);
            } else if (fault.indexOf("FailedLoginException") != -1) {
                this.error(98, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("UserNotFoundException") != -1) {
                this.error(97, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("EnabledException") != -1) {
                this.error(96, "Failed Login. Account disabled.", ex2);
            } else {
                this.error(32, "Web Service Exception @ " + this.host + "\n" + fault, ex2);
            }
        }
        catch (RemoteException ex) {
            this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            this.error(11, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
    }
}

