/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;

public class ArcPutWS
extends WSTool {
    protected static final String FILE_FLAG = "f";
    protected static final String SESSION_FLAG = "s";

    public void process() {
        String f = null;
        if (this.arguments.get(FILE_FLAG) == null) {
            this.displayHelp();
            System.exit(4);
        }
        if (this.arguments.get(SESSION_FLAG) == null) {
            this.displayHelp();
            System.exit(5);
        }
        try {
            f = (String)this.arguments.get(FILE_FLAG);
            File file = new File(f);
            if (!file.exists()) {
                throw new FileNotFoundException(f);
            }
            String mr_session_id = (String)this.arguments.get(SESSION_FLAG);
            String service_session = this.createServiceSession();
            try {
                this.execute(this.host, service_session, file, this.quiet, mr_session_id);
            }
            catch (AxisFault ex2) {
                String fault = ex2.getFaultString();
                if (fault == null) {
                    this.error(33, "Web Service Exception: " + this.host + "\n" + ((RemoteException)((Object)ex2)).getMessage(), ex2);
                } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                    this.error(99, "Invalid Password.", ex2);
                } else if (fault.indexOf("FailedLoginException") != -1) {
                    this.error(98, "Failed Login. Review username and password.", ex2);
                } else if (fault.indexOf("UserNotFoundException") != -1) {
                    this.error(97, "Failed Login. Review username and password.", ex2);
                } else if (fault.indexOf("EnabledException") != -1) {
                    this.error(96, "Failed Login. Account disabled.", ex2);
                } else {
                    this.error(32, "Web Service Exception @ " + this.host + "\n" + fault, ex2);
                }
            }
            catch (RemoteException ex) {
                this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
            }
            catch (MalformedURLException e) {
                this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
            }
            catch (Throwable e) {
                this.error(13, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
            }
            this.closeServiceSession(service_session);
        }
        catch (MalformedURLException e) {
            this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
        }
        catch (AxisFault ex2) {
            String fault = ex2.getFaultString();
            if (fault == null) {
                this.error(33, "Web Service Exception: " + this.host + "\n" + ((RemoteException)((Object)ex2)).getMessage(), ex2);
            } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                this.error(99, "Invalid Password.", ex2);
            } else if (fault.indexOf("FailedLoginException") != -1) {
                this.error(98, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("UserNotFoundException") != -1) {
                this.error(97, "Failed Login. Review username and password.", ex2);
            } else if (fault.indexOf("EnabledException") != -1) {
                this.error(96, "Failed Login. Account disabled.", ex2);
            } else {
                this.error(32, "Web Service Exception @ " + this.host + "\n" + fault, ex2);
            }
        }
        catch (RemoteException ex) {
            this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            this.error(11, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (FileNotFoundException ex) {
            this.error(34, "File Not Found: " + f, ex);
        }
    }

    public void execute(String host, String service_session, File file, boolean quiet, String mr_session_id) throws FileNotFoundException, MalformedURLException, IOException {
        boolean counter = false;
        long startTime = System.currentTimeMillis();
        String urlString = String.valueOf(host) + "app/template/ArcPut.vm";
        URL url = new URL(urlString);
        String boundary = MultiPartFormOutputStream.createBoundary();
        URLConnection urlConn = MultiPartFormOutputStream.createConnection(url);
        urlConn.setRequestProperty("Cookie", "JSESSIONID=" + service_session);
        urlConn.setRequestProperty("Accept", "*/*");
        urlConn.setRequestProperty("Content-Type", MultiPartFormOutputStream.getContentType(boundary));
        urlConn.setRequestProperty("Connection", "Keep-Alive");
        urlConn.setRequestProperty("Cache-Control", "no-cache");
        MultiPartFormOutputStream out = new MultiPartFormOutputStream(urlConn.getOutputStream(), boundary);
        out.writeField("session", service_session);
        out.writeField("mr_session_id", mr_session_id);
        out.writeFile("archive", "application/zip", file);
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        StringBuffer response = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            response.append(line).append("\n");
        }
        UploadResponse ur = new UploadResponse(response.toString());
        if (ur.getStatus().equals("COMPLETE")) {
            System.out.println("Upload Completed.");
            System.exit(0);
        } else {
            System.out.println("Error: " + ur.getMessage());
            System.exit(ur.getCode());
        }
    }

    public void loadHelpText() {
        super.loadHelpText();
        this.helpText.put(FILE_FLAG, "File to upload.");
        this.helpText.put(SESSION_FLAG, "MRSession ID.");
    }

    public void displayHelp() {
        System.out.println("\nArc-Put Web Service\n");
        this.displayCommonHelp();
        this.printHelpLine(SESSION_FLAG);
        this.printHelpLine(FILE_FLAG);
    }

    public static void main(String[] args) {
        ArcPutWS arcGet = new ArcPutWS();
        arcGet.perform(args);
    }

    public class UploadResponse {
        private int code = 0;
        private String message = "";
        private String status = "";

        public UploadResponse(String content) {
            if (content != null) {
                String _code;
                int end;
                int start;
                if (content.indexOf("status=\"") != -1) {
                    start = content.indexOf("status=\"") + 8;
                    end = content.indexOf("\"", start);
                    this.setStatus(content.substring(start, end));
                }
                if (content.indexOf("CODE=\"") != -1 && (_code = content.substring(start = content.indexOf("code=\"") + 6, end = content.indexOf("\"", start))) != "") {
                    try {
                        int i = Integer.parseInt(_code);
                        this.setCode(i);
                    }
                    catch (NumberFormatException e) {
                        this.setCode(99);
                    }
                }
                if (content.indexOf("<message>") != -1) {
                    start = content.indexOf("<message>") + 9;
                    end = content.indexOf("</message>", start);
                    this.setMessage(content.substring(start, end));
                }
            }
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

