/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSearchWS
extends WSTool {
    @Override
    public void process() {
        String dir = null;
        Object d = this.arguments.get("dir");
        if (d == null) {
            dir = "." + File.separator;
        } else {
            if (d instanceof ArrayList) {
                dir = (String)((ArrayList)d).get(((ArrayList)d).size() - 1);
                System.out.println("Exporting to " + dir + ".\n Ignoring other -dir tags.");
            } else {
                dir = (String)d;
            }
            if (!dir.endsWith(File.separator)) {
                dir = String.valueOf(dir) + File.separator;
            }
        }
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdir();
        }
        int _return = 0;
        try {
            String dataType;
            String value;
            String comparison;
            String service_session = this.createServiceSession();
            String field = (String)this.arguments.get("field");
            if (field == null) {
                System.out.println("ERROR CODE 27: Missing search field.");
                this.displayHelp();
                System.exit(27);
            }
            if ((comparison = (String)this.arguments.get("c")) == null) {
                comparison = "=";
            }
            if ((value = (String)this.arguments.get("v")) == null) {
                System.out.println("ERROR CODE 28: Missing search value.");
                this.displayHelp();
                System.exit(28);
            }
            if ((dataType = (String)this.arguments.get("dataType")) == null) {
                int index = -1;
                index = field.indexOf(46);
                if (index == -1) {
                    index = field.indexOf(47);
                } else {
                    int other = field.indexOf(47);
                    if (other != -1 && other < index) {
                        index = other;
                    }
                }
                if (index == -1) {
                    System.out.println("ERROR CODE 41: Invalid field format.");
                    this.displayHelp();
                    System.exit(41);
                }
                dataType = field.substring(0, index);
            }
            Object[] sessions = this.getIdentifiers(service_session, field, comparison, value, dataType);
            if (!this.quiet) {
                System.out.println(String.valueOf(sessions.length) + " Matching Item(s) Found.");
            }
            int i = 0;
            while (i < sessions.length) {
                Object id = sessions[i];
                try {
                    String createdFile = this.execute(this.host, service_session, id, dataType, dir, this.quiet);
                    System.out.println(createdFile);
                }
                catch (SAXException e) {
                    System.out.println("ERROR CODE 30: Invalid XML Received.");
                    System.out.println("This could be do to network instability. Please re-try your request.  If the problem persists contact your IT Management.");
                    _return = 30;
                }
                catch (ParserConfigurationException e) {
                    this.logError(e);
                }
                ++i;
            }
            this.closeServiceSession(service_session);
        }
        catch (AxisFault ex2) {
            String fault = ex2.getFaultString();
            if (fault == null) {
                System.out.println("ERROR CODE 33: \nWeb Service Exception: " + this.host + "\n" + ex2.getMessage());
                this.logError(ex2);
                System.exit(33);
            } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                System.out.println("ERROR CODE 99: \nInvalid Password.");
                this.logError(ex2);
                System.exit(99);
            } else if (fault.indexOf("FailedLoginException") != -1) {
                System.out.println("ERROR CODE 98: \nFailed Login. Review username and password.");
                this.logError(ex2);
                System.exit(98);
            } else if (fault.indexOf("UserNotFoundException") != -1) {
                System.out.println("ERROR CODE 97: \nFailed Login. Review username and password.");
                this.logError(ex2);
                System.exit(98);
            } else if (fault.indexOf("EnabledException") != -1) {
                System.out.println("ERROR CODE 96: \nFailed Login. Account disabled.");
                this.logError(ex2);
                System.exit(98);
            } else {
                System.out.println("ERROR CODE 32: \nWeb Service Exception @ " + this.host + "\n" + fault);
                this.logError(ex2);
                System.exit(32);
            }
        }
        catch (RemoteException ex) {
            System.out.println("ERROR CODE 33: " + ex.getMessage());
            this.logError(ex);
            _return = 33;
        }
        catch (ServiceException ex) {
            System.out.println("ERROR CODE: 11\nWeb Service Exception: " + this.host + "\n" + ex.getMessage());
            this.logError(ex);
            _return = 11;
        }
        catch (MalformedURLException e) {
            System.out.println("ERROR CODE: 12\nUnknown URL: " + this.host);
            this.logError(e);
            System.exit(12);
        }
        catch (IOException e) {
            System.out.println("ERROR CODE: 13\nWeb Service Exception @ " + this.host + "\n" + e.getMessage());
            this.logError(e);
            System.exit(13);
        }
        System.exit(_return);
    }

    public String execute(String host, String service_session, Object id, String dataType, String dir, boolean quiet) throws FileNotFoundException, MalformedURLException, IOException, SAXException, ParserConfigurationException {
        int counter = 0;
        String finalName = id + ".xml";
        File outFile = new File(dir, finalName);
        while (outFile.exists()) {
            finalName = id + "_v" + counter++ + ".xml";
            outFile = new File(dir, finalName);
        }
        FileOutputStream out = new FileOutputStream(outFile);
        this.writeXMLtoOS(host, service_session, id, dataType, dir, quiet, out);
        out.close();
        XMLSearchWS.parse(outFile);
        return String.valueOf(dir) + finalName;
    }

    public static void parse(File data) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser sp = spf.newSAXParser();
        sp.parse(data, new DefaultHandler());
    }

    @Override
    public void displayHelp() {
        System.out.println("\nXML Search Web Service\n");
        System.out.println("");
        System.out.println("Parameters:");
        System.out.println("-userName          USERNAME");
        System.out.println("-password          PASSWORD");
        System.out.println("-host       URL to XNAT based website.  (i.e. http://localhost/xnat)");
        System.out.println("-field      (REQUIRED) field to search on - Must be specified using dot syntax from the parent element. (i.e. ClinicalAssessment.neuro.CDR.memory");
        System.out.println("-c          (i.e. '=','<','<=','>','>=', or 'LIKE').");
        System.out.println("-v          (REQUIRED) value to search for. ");
        System.out.println("-dataType   Root level data type to return.");
        System.out.println("-dir        Output directory.");
        System.out.println("-quiet      Minimize system output.");
        System.out.println("-h          Print help.");
    }

    public static void main(String[] args) {
        XMLSearchWS xmlSearch = new XMLSearchWS();
        xmlSearch.perform(args);
    }
}

