/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.zip.GZIPInputStream;
import javax.xml.rpc.ServiceException;

public class GetFileWS
extends WSTool {
    protected static final String SRC_FLAG = "src";
    protected static final String DEST_FLAG = "dest";

    public void loadHelpText() {
        super.loadHelpText();
        this.helpText.put("user_session", "User Session ID");
        this.helpText.put(SRC_FLAG, "Source File (REMOTE_PATH)");
        this.helpText.put(DEST_FLAG, "Destinating File (LOCAL_PATH)");
    }

    public void displayHelp() {
        System.out.println("\nClose User Web Service Session\n");
        this.displayCommonHelp();
        this.printHelpLine(SRC_FLAG);
        this.printHelpLine(DEST_FLAG);
        this.printHelpLine("di");
    }

    public static void main(String[] args) {
        GetFileWS serv = new GetFileWS();
        serv.perform(args);
    }

    public void process() {
        if (this.arguments.get(SRC_FLAG) == null) {
            this.displayHelp();
            System.exit(5);
        }
        if (this.arguments.get(DEST_FLAG) == null) {
            this.displayHelp();
            System.exit(6);
        }
        try {
            String service_session = this.createServiceSession();
            String src = (String)this.arguments.get(SRC_FLAG);
            String dest = (String)this.arguments.get(DEST_FLAG);
            try {
                int bytesRead;
                File outFile;
                URLConnection url = new URL(src).openConnection();
                url.setRequestProperty("Cookie", "JSESSIONID=" + service_session);
                InputStream bis = null;
                OutputStream os = null;
                String decompressS = (String)this.arguments.get("di");
                boolean decompress = false;
                if (decompressS != null && decompressS.equalsIgnoreCase("true") && dest.endsWith(".gz")) {
                    dest = dest.substring(0, dest.length() - 3);
                    decompress = true;
                }
                if (!(outFile = new File(dest)).getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                os = new FileOutputStream(outFile);
                try {
                    bis = url.getInputStream();
                }
                catch (FileNotFoundException e) {
                    this.error(39, "File not found on server.  Please review the -src parameter", e);
                }
                if (decompress) {
                    bis = new GZIPInputStream(bis);
                }
                os = new BufferedOutputStream(os);
                byte[] buff = new byte[256];
                int loaded = 0;
                NumberFormat nf = NumberFormat.getInstance();
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    os.write(buff, 0, bytesRead);
                    os.flush();
                    loaded += bytesRead;
                }
                bis.close();
                os.flush();
                os.close();
                if (!this.quiet) {
                    System.out.println(outFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                this.error(37, e.getMessage(), e);
            }
            catch (IOException e) {
                this.error(38, e.getMessage(), e);
            }
        }
        catch (MalformedURLException e) {
            this.error(12, "Web Service Exception: " + this.host + "\n" + e.getMessage(), e);
        }
        catch (RemoteException ex) {
            this.error(33, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
        catch (ServiceException ex) {
            this.error(11, "Web Service Exception: " + this.host + "\n" + ex.getMessage(), ex);
        }
    }
}

