/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;

public class ArcSimWS
extends WSTool {
    public void process() {
        int _return = 0;
        try {
            URL url = new URL(String.valueOf(this.host) + "axis/GetIdentifiers.jws");
            String service_session = this.createServiceSession();
            Call call = this.createCall(service_session);
            call.setTargetEndpointAddress(url);
            call.setOperationName("search");
            String field = "xnat:mrSessionData.ID";
            String comparison = "LIKE";
            String value = (String)this.arguments.get("s");
            if (value == null) {
                System.out.println("ERROR CODE 28: Missing partial session id.");
                this.displayHelp();
                System.exit(28);
            }
            String dataType = "xnat:mrSessionData";
            Object[] params = new Object[]{service_session, field, comparison, value, dataType};
            Object[] o = (Object[])call.invoke(params);
            String outFile = (String)this.arguments.get("o");
            int i = 0;
            while (i < o.length) {
                Object id = o[i];
                if (outFile == null) {
                    System.out.println(id);
                } else {
                    WSTool.outputToFile((String)id, outFile, true);
                }
                ++i;
            }
            if (outFile != null && new File(outFile).exists()) {
                System.out.println("\nCreated file: " + outFile);
            }
        }
        catch (AxisFault ex2) {
            String fault = ex2.getFaultString();
            if (fault == null) {
                System.out.println("ERROR CODE 33: \nWeb Service Exception: " + this.host + "\n" + ((RemoteException)((Object)ex2)).getMessage());
                this.logError(ex2);
                System.exit(33);
            } else if (fault.indexOf("PasswordAuthenticationException") != -1) {
                System.out.println("ERROR CODE 99: \nInvalid Password.");
                this.logError(ex2);
                System.exit(99);
            } else if (fault.indexOf("FailedLoginException") != -1) {
                System.out.println("ERROR CODE 98: \nFailed Login. Review username and password.");
                this.logError(ex2);
                System.exit(98);
            } else if (fault.indexOf("UserNotFoundException") != -1) {
                System.out.println("ERROR CODE 97: \nFailed Login. Review username and password.");
                this.logError(ex2);
                System.exit(98);
            } else if (fault.indexOf("EnabledException") != -1) {
                System.out.println("ERROR CODE 96: \nFailed Login. Account disabled.");
                this.logError(ex2);
                System.exit(98);
            } else {
                System.out.println("ERROR CODE 32: \nWeb Service Exception @ " + this.host + "\n" + fault);
                this.logError(ex2);
                System.exit(32);
            }
        }
        catch (RemoteException ex) {
            System.out.println("ERROR CODE 33: " + ex.getMessage());
            this.logError(ex);
            _return = 33;
        }
        catch (ServiceException ex) {
            System.out.println("ERROR CODE: 11\nWeb Service Exception: " + this.host + "\n" + ex.getMessage());
            this.logError(ex);
            _return = 11;
        }
        catch (MalformedURLException e) {
            System.out.println("ERROR CODE: 12\nUnknown URL: " + this.host);
            this.logError(e);
            System.exit(12);
        }
        System.exit(_return);
    }

    public void displayHelp() {
        System.out.println("\nArc-Sim Web Service\n");
        System.out.println("");
        System.out.println("Parameters:");
        System.out.println("-u          USERNAME");
        System.out.println("-p          PASSWORD");
        System.out.println("-host       URL to XNAT based website.  (i.e. http://localhost/xnat)");
        System.out.println("-h          Print help.");
        System.out.println("-s          Partial session id.");
        System.out.println("-o          Name of file to output to.");
    }

    public static void main(String[] args) {
        ArcSimWS arcSim = new ArcSimWS();
        arcSim.perform(args);
    }
}

