"""Initial schema

Revision ID: 3608147bbfb
Revises: None
Create Date: 2013-01-08 18:51:34.433179

"""

# revision identifiers, used by Alembic.
revision = '3608147bbfb'
down_revision = None

from alembic import op
import sqlalchemy as sa

from sqlalchemy.sql.expression import *



def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('qtimer_persistentvars',
    sa.Column('name', sa.Unicode(length=256), nullable=False),
    sa.Column('value', sa.PickleType(), nullable=False),
    sa.PrimaryKeyConstraint('name')
    )
    op.create_table('qtimer_projects',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Unicode(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qtimer_tickets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Unicode(length=256), nullable=False),
    sa.Column('ticket_id', sa.Integer(), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['project_id'], ['qtimer_projects.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qtimer_timers',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Unicode(length=256), nullable=False),
    sa.Column('posted', sa.Boolean(), nullable=False),
    sa.Column('billable_status', sa.Integer(), nullable=True),
    sa.Column('ticket_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['ticket_id'], ['qtimer_tickets.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('qtimer_sessions',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('start', sa.DateTime(), nullable=False),
    sa.Column('end', sa.DateTime(), nullable=True),
    sa.Column('timer_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['timer_id'], ['qtimer_timers.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('qtimer_sessions')
    op.drop_table('qtimer_timers')
    op.drop_table('qtimer_tickets')
    op.drop_table('qtimer_projects')
    op.drop_table('qtimer_persistentvars')
    ### end Alembic commands ###
