from tier import Tier
from qds_ops.tparty.knife import Knife

class Web(Tier):
  def __init__(self, subparser):
    self.tier = "web"
    super(Web, self).__init__(subparser)

    #CMD
    cli = self.tier_parser.add_parser("cli",
        help = "Show all cli.py processes or commands running on ALL web nodes")
    cli.set_defaults(func = self.cli)
    
    #CMD Count
    cli_count = self.tier_parser.add_parser("cli-count",
        help = "Count number of cli.py or commands running on ALL web nodes")
    cli_count.set_defaults(func = self.cli_count)
    
    #DJ
    dj = self.tier_parser.add_parser("dj", help="List all Delayed jobs running on web nodes")
    dj.set_defaults(func = self.dj)
    
    #DJ Count
    dj_count = self.tier_parser.add_parser("dj-count", help="Count all DJs on each web node")
    dj_count.set_defaults(func = self.dj_count)

  def cli(self, args):
    knife = Knife()
    output = knife.ssh(args.environment, self.tier, 
        "ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep ")
    print output
  
  def cli_count(self, args):
    knife = Knife()
    output = knife.ssh(args.environment, self.tier, 
        "ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep | wc -l")
    print output

  def dj(self, args):
    knife = Knife()
    output = knife.ssh(args.environment, self.tier, 
        "ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep ")
    print output
  
  def dj_count(self, args):
    knife = Knife()
    output = knife.ssh(args.environment, self.tier, 
        "ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep | wc -l")
    print output
