from qds_ops.tparty.knife import Knife
import json
import subprocess

class RDS():
  def __init__(self, subparser):
    parser = subparser.add_parser("rds",
        help = "Commands to monitor and control RDS Mysql servers")
    rds_subparser = parser.add_subparsers()

    # hostnames
    hn_parser = rds_subparser.add_parser("hostnames",
        help = "List hostnames of the primary Mysql server and read replica if any")
    hn_parser.set_defaults(func=self.hostnames)

    #connect
    cn_parser = rds_subparser.add_parser("connect",
        help = "Connect to the primary or replica Mysql server")
    cn_parser.add_argument("-r", "--replica", dest="replica", 
        action = "store_true", help="Login into read replica")
    cn_parser.set_defaults(func=self.connect)

  def hostnames(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    output = {}
    output["primary"] = creds["host"]
    output["read_replica"] = creds["rr_host"]

    print json.dumps(output, indent=4, sort_keys=True)

  def connect(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    hostname = ""
    if args.replica:
      hostname = creds["rr_host"]
    else:
      hostname = creds["host"]
    subprocess.check_output(["mysql", "-u", creds["username"],
        "-p%s" % creds["password"],"-h", hostname], stderr=None)

