#!/bin/env python

import os
import sys
import traceback
import logging
from qds_ops.entities.web import Web
from qds_ops.entities.oozie_master import OozieMaster
from qds_ops.entities.oozie_slave import OozieSlave
from qds_ops.entities.oozie import Oozie
from qds_ops.entities.chef import Chef
from qds_ops.entities.rds import RDS
from qds_ops.utils import argparse
from qds_ops import __version__
from inflection import camelize
import yaml

def main():
    argparser = argparse.ArgumentParser(description="Operational tool for Qubole Data Service.")
    argparser.add_argument("-e", "--env", dest="environment",
        help="Qubole environment")
    argparser.add_argument('--version', action='version', version=__version__)
    subparsers = argparser.add_subparsers()

    chef = Chef(subparsers)
    web = Web(subparsers)
    master = OozieMaster(subparsers)
    slave = OozieSlave(subparsers)
    oozie = Oozie(subparsers)
    rds = RDS(subparsers)

    args = argparser.parse_args()
    args.func(args)

if __name__ == '__main__':
    try:
        sys.exit(main())
    except Exception:
        traceback.print_exc(file=sys.stderr)
        sys.exit(3)
