from qds_ops.tparty.knife import Knife
import json
from subprocess import Popen, PIPE
import inspect, os

class Chef():
  def __init__(self, subparser):
    parser = subparser.add_parser("chef",
        help = "Commands to get an overview of the installation")
    chef_subparser = parser.add_subparsers()

    #roles
    roles_parser = chef_subparser.add_parser("roles")
    roles_parser.set_defaults(func=self.roles)
    
    #upload cookbook
    upload_parser = chef_subparser.add_parser("upload-cookbook",
        help = "Upload cookbook for specified env")
    upload_parser.add_argument("-v", "--version", dest="version", 
        help="Version of cookbook to upload to specified environment")
    upload_parser.add_argument("-s", "--srcpath", dest="src_path", 
        default="~/src/", help="Root src directory")
    upload_parser.set_defaults(func=self.upload_cookbook)

  def roles(self, args):
    knife = Knife()
    list = knife.roles()
    print json.dumps(list, indent=4, sort_keys=True) 
  
  def upload_cookbook(self, args):
    base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    upload_cmd = ["/bin/bash",base_path+"/../scripts/upload_cookbook.sh", "-e", args.environment, "-v",
        args.version, "-s", args.src_path]
    print str((upload_cmd))
    p = Popen(" ".join(upload_cmd), shell = True)
    retCode = p.wait()
    print "Return Code is: " + str(retCode)
    
