from qds_ops.tparty.knife import Knife
import json
from subprocess import Popen, PIPE
import inspect, os
import MySQLdb
from qds_ops.utils.ssh_tunnel import SSHTunnel

class Chef():
  def __init__(self, subparser):
    parser = subparser.add_parser("chef",
        help = "Commands to get an overview of the installation")
    chef_subparser = parser.add_subparsers()
   
    #Describe
    desc_parser = chef_subparser.add_parser("describe",
        help = "Describe environment attributes like cookbook version")
    desc_parser.set_defaults(func=self.describe)

    #Deploy Lock
    lock_parser = chef_subparser.add_parser("deploy-lock",
        help = "Check, lock or unlock deploy lock")
    lock_parser.add_argument("-a", "--action", dest="action", choices=["check", "lock", "unlock"], default="check", 
        help="Action to apply to the lock")
    lock_parser.add_argument("-t", "--tunnel", dest="tunnel", 
        action = "store_true", help="Setup a tunnel to RDS", default="False")
    lock_parser.set_defaults(func=self.deploy_lock)

    #roles
    roles_parser = chef_subparser.add_parser("roles")
    roles_parser.set_defaults(func=self.roles)
    
    #upload cookbook
    upload_parser = chef_subparser.add_parser("upload-cookbook",
        help = "Upload cookbook for specified env")
    upload_parser.add_argument("-v", "--version", dest="version", 
        help="The cookbook version of the form x.y.z, generated by create-package-chef.sh. You can also specify a branch name in which case the tip of branch is uploaded.")
    upload_parser.add_argument("-s", "--srcpath", dest="src_path", 
        default="~/src/", help="Root src directory")
    upload_parser.set_defaults(func=self.upload_cookbook)

  def roles(self, args):
    knife = Knife()
    list = knife.roles()
    print json.dumps(list, indent=4, sort_keys=True) 
  
  def upload_cookbook(self, args):
    base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    upload_cmd = ["/bin/bash",base_path+"/../scripts/upload_cookbook.sh", "-e", args.environment, "-v",
        args.version, "-s", args.src_path]
    print str((upload_cmd))
    p = Popen(" ".join(upload_cmd), shell = True)
    retCode = p.wait()
    print "Return Code is: " + str(retCode)

  def deploy_lock(self, args):
    knife = Knife()
    temp = knife.get_pemfile(args.environment)
    list = knife.search(args.environment, "web")
    creds = knife.get_credentials(args.environment)
    hostname = creds["host"]
    port = 3306
    # Setup a tunnel
    if args.tunnel:
      tunnel = SSHTunnel("ec2-user", list[0], hostname, temp, 22, 3306, 33306)
      hostname = "127.0.0.1"
      port = 33306

    #Connect to DB and run query
    try:
      con = MySQLdb.connect(hostname, creds["username"], creds["password"], 'rstore', port);

      if args.action == "check":
        sql_query = "select running from rstore.deploy_statuses"
        cur = con.cursor(MySQLdb.cursors.DictCursor)
        cur.execute(sql_query)
        rows = cur.fetchone()
        print str(rows)
        if rows["running"] == 0:
          print "Unlocked"
        else:
          print "Locked"
      elif args.action == "lock":
        sql_query = "update rstore.deploy_statuses set running = true where running = false"
        cur = con.cursor()
        cur.execute(sql_query)
        if cur.rowcount > 0:
          print "Deploy-Lock locked successfully"
        else:
          print "Deploy-Lock could not be locked"
        con.commit()
      elif args.action == "unlock":
        sql_query = "update rstore.deploy_statuses set running = false where running = true"
        cur = con.cursor()
        cur.execute(sql_query)
        if cur.rowcount > 0:
          print "Deploy-Lock unlocked successfully"
        else:
          print "Deploy-Lock could not be unlocked"
        con.commit()
    except MySQLdb.Error, e:
      print "Error %d: %s" % (e.args[0],e.args[1])
    finally:    
      if con:    
        con.close()
    
  def describe(self, args):
    knife = Knife()
    info = knife.describe(args.environment)
    print json.dumps(info, indent=4, sort_keys=True) 
