from qds_ops.tparty.knife import Knife
import json
from qds_ops.utils.ssh_tunnel import SSHTunnel
from subprocess import PIPE, check_call
import os

class RDS():
  def __init__(self, subparser):
    parser = subparser.add_parser("rds",
        help = "Commands to monitor and control RDS Mysql servers")
    rds_subparser = parser.add_subparsers()

    # hostnames
    hn_parser = rds_subparser.add_parser("hostnames",
        help = "List hostnames of the primary Mysql server and read replica if any")
    hn_parser.set_defaults(func=self.hostnames)

    #connect
    cn_parser = rds_subparser.add_parser("connect",
        help = "Connect to the primary or replica Mysql server")
    cn_parser.add_argument("-r", "--replica", dest="replica", 
        action = "store_true", help="Login into read replica")
    cn_parser.set_defaults(func=self.connect)
    
    #tunnel
    tn_parser = rds_subparser.add_parser("tunnel",
        help = "Connect to the primary or replica Mysql server through a tunnel on a web node")
    tn_parser.add_argument("-r", "--replica", dest="replica", 
        action = "store_true", help="Login into read replica")
    tn_parser.set_defaults(func=self.tunnel)

  def hostnames(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    output = {}
    output["primary"] = creds["host"]
    output["read_replica"] = creds["rr_host"]

    print json.dumps(output, indent=4, sort_keys=True)

  def connect(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    hostname = ""
    if args.replica:
      hostname = creds["rr_host"]
    else:
      hostname = creds["host"]
    mysql  = check_call(["mysql", "-u", creds["username"],
        "-p%s" % creds["password"],"-h", hostname]) 
  
  def tunnel(self, args):
    knife = Knife()
    temp = knife.get_pemfile(args.environment)
    list = knife.search(args.environment, "web")
    creds = knife.get_credentials(args.environment)
    hostname = ""
    if args.replica:
      hostname = creds["rr_host"]
    else:
      hostname = creds["host"]
    tunnel = SSHTunnel("ec2-user", list[0], hostname, temp, 22, 3306, 33306)
    mysql  = check_call(["mysql", "-u", creds["username"],
        "-p%s" % creds["password"],"-h", "127.0.0.1", "-P", "33306"]) 
    os.unlink(temp)
