#!/bin/bash -e


usage() {
    cat <<EOF
Usage: $0 -b <branch name> [-s <hive|fb-hadoop-20|qbol|sqoop|oozie|mongo-hadoop> ]
Use this tool to get the latest source code for any branch on a repo. Error if
the branch does not exist.
EOF
    exit $1
}

branch=""
d=`dirname $0`
d=`cd "$d"; pwd`

source ${d}/deploy-common.sh

while getopts "hb:s:" opt; do
    case $opt in
        h) usage 0
            ;;
        b) branch=$OPTARG
            ;;
	s) allsrc=$OPTARG
	    ;;
        \?)
            echo "Invalid option: -$OPTARG" >&2
            usage 1
            ;;
        :)
            echo "Option -$OPTARG requires an argument." >&2
            usage 1
            ;;
    esac
done

if [ "$branch" == "" ]; then
    usage 1
fi

# check if all local changes have been committed
check_uncommitted() {
    src=$1
    cd ${out_path}/$src
    cmd="git diff"
    ret=`$cmd --shortstat`
    if ! [ "$ret" = "" ]
    then
	$cmd
	echo "You have uncommitted changes in src $src. Please commit them and push them to remote repository."
	exit 2
    fi
}

# check if all locally committed changes have been pushed to remote
check_unpushed() {
    b=$1
    src=$2
    cd ${out_path}/$src
    cmd="git diff origin/$b..$b"
    ret=`$cmd --shortstat`
    if ! [ "$ret" = "" ]
    then
	$cmd
	echo "You have unpushed changes in branch $b, src $src. Please push them to remote repository."
	exit 3
    fi
}

# pull a src
pull_src() {
    b=$1
    s=$2
    echo ${out_path}
    cd ${out_path}/$s
    echo "Pulling $s"
    check_uncommitted "$s"
    git checkout $b
    git pull
    check_unpushed "$b" "$s"
}

# keep chef-repo up to date
if ! [ "$allsrc" == "chef-repo" ]; then
    pull_src master "chef-repo"
fi

for s in $allsrc
do
    pull_src "$branch" "$s"
done

