from qds_ops.tparty.knife import Knife
import json
from subprocess import Popen, PIPE
import inspect, os

class Tier(object):
  def __init__(self, global_subparser):
    parser = global_subparser.add_parser(self.tier,
        help = "Commands to monitor and control %s tier" % self.tier)
    self.tier_parser = parser.add_subparsers()

    #List
    list_parser = self.tier_parser.add_parser("list", 
        help="List all nodes in %s tier" % self.tier)
    list_parser.set_defaults(func=self.list)

    #Package
    package_parser = self.tier_parser.add_parser("package",
        help = "List all packages in %s tier" % self.tier)
    package_parser.set_defaults(func=self.packages)

    #SSH
    ssh_parser = self.tier_parser.add_parser("ssh",
        help = "SSH and run any bash command on machines in %s tier" % self.tier)
    ssh_parser.add_argument("command", help="Bash command to run")
    ssh_parser.add_argument("-a", "--any", dest="any", 
        action = "store_true", help="Login into any node in %s" %(self.tier))
    ssh_parser.set_defaults(func=self.ssh)
  
    #Screen
    screen_parser = self.tier_parser.add_parser("screen",
        help = "Use GNU screen and open terminals on ALL machines in %s tier" % self.tier)
    screen_parser.set_defaults(func=self.screen)
  
    #Deploy
    deploy_parser = self.tier_parser.add_parser("deploy",
        help = "Run deploy in %s tier" % self.tier)
    deploy_parser.add_argument("-m", "--module", dest="module", 
        default=None, help="Deploy module to %s" %(self.tier))
    deploy_parser.add_argument("-r", "--no-rolling", dest="rolling", 
        default=True, action = "store_false", help="Do rolling deploy to %s" %(self.tier))
    deploy_parser.add_argument("-t", "--stop-djs-at-start", dest="stopdjs", 
        default=False, action = "store_true", help="At start of rolling deploy stop djs on current nodes")
    deploy_parser.add_argument("-c", "--run-common-stuff-recipe", dest="commstuff", 
        default=False, action = "store_true", help="Run common stuff at start of deploy")
    deploy_parser.add_argument("-d", "--no-djrestart", dest="djrestart", 
        default=True, action = "store_false", help="Dj Restart reqd: %s" %(self.tier))
    deploy_parser.add_argument("-s", "--srcpath", dest="src_path", 
        default="~/src/", help="Root src directory")
    deploy_parser.set_defaults(func=self.deploy)
 
  def deploy(self, args):
    deploy_cmd = ["/bin/bash"]
    base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    if self.tier == "web":
      deploy_cmd.extend([base_path + "/../scripts/chef_deploy_web.sh", "-e", args.environment])
      if args.commstuff == True:
        deploy_cmd.extend(["-c"])
      if args.stopdjs == True:
        deploy_cmd.extend(["-t"])
      if args.rolling == False:
        deploy_cmd.extend(["-r"])
      if args.djrestart == False:
        deploy_cmd.extend(["-d"])
    elif self.tier == "oozie-*":
      deploy_cmd.extend([base_path + "/../scripts/chef_deploy_oozie.sh", "-e", args.environment])
      if args.module is not None:
        deploy_cmd.extend(["-m", args.module])
    else:
      deploy_cmd.extend([base_path + "/../scripts/chef_deploy_oozie.sh", "-e", args.environment, "-t", self.tier])
    
    if args.module is not None:
      deploy_cmd.extend(["-m", args.module])
    deploy_cmd.extend(["-s", args.src_path])
    print str(deploy_cmd)
    p = Popen(" ".join(deploy_cmd),shell=True)
    retCode = p.wait()
    print "Return Code is: " + str(retCode)

  def list(self, args):
    knife_search = Knife()
    list = knife_search.search(args.environment, self.tier)
    print json.dumps(list, indent=4, sort_keys=True) 

  def packages(self, args):
    knife_search = Knife()
    list = knife_search.packages(args.environment, self.tier)
    print json.dumps(list, indent=4, sort_keys=True) 

  def ssh(self, args):
    knife = Knife()
    output = ""
    if args.any:
      output = knife.ssh_one(args.command, args.environment, self.tier)
    else:
      output = knife.ssh(args.command, args.environment, self.tier)
    print output
  
  def screen(self, args):
    knife = Knife()
    output = knife.ssh("screen", args.environment, self.tier)
    print output
