from qds_ops.tparty.knife import Knife
import json
from qds_ops.utils.ssh_tunnel import SSHTunnel
from subprocess import PIPE, check_call
import os
import random
import socket

class RDS():
  def __init__(self, subparser):
    parser = subparser.add_parser("rds",
        help = "Commands to monitor and control RDS Mysql servers")
    rds_subparser = parser.add_subparsers()

    # hostnames
    hn_parser = rds_subparser.add_parser("hostnames",
        help = "List hostnames of the primary Mysql server and read replica if any")
    hn_parser.set_defaults(func=self.hostnames)

    #connect
    cn_parser = rds_subparser.add_parser("connect",
        help = "Connect to the primary or replica Mysql server")
    cn_parser.add_argument("-a", "--autocomplete", dest="autocomplete",
        action = "store_true", help="enable tab-completion of table and column names (with slower startup)")
    cn_parser.add_argument("-r", "--replica", dest="replica",
        action = "store_true", help="Login into read replica")
    cn_parser.add_argument("-t", "--tunnel", dest="tunnel", 
        action = "store_true", help="Use a tunnel through a web node")
    cn_parser.set_defaults(func=self.connect)

    #tunnel
    tn_parser = rds_subparser.add_parser("tunnel",
        help = "Connect to the primary or replica Mysql server through a tunnel on a web node")
    tn_parser.add_argument("-a", "--autocomplete", dest="autocomplete",
        action = "store_true", help="enable tab-completion of table and column names (with slower startup)")
    tn_parser.add_argument("-r", "--replica", dest="replica",
        action = "store_true", help="Login into read replica")
    tn_parser.set_defaults(func=self.tunnel)

  def hostnames(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    output = {}
    output["primary"] = creds["host"]
    output["read_replica"] = creds["rr_host"]

    print json.dumps(output, indent=4, sort_keys=True)

  def checkport(self, port):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    result = s.connect_ex(('127.0.0.1', 3306))
    s.close()

    return result != 0

  def connect(self, args):
    knife = Knife()
    creds = knife.get_credentials(args.environment)
    hostname = ""
    if args.replica:
      hostname = creds["rr_host"]
    else:
      hostname = creds["host"]
    port = 3306
    pemfile = None

    if args.tunnel:
      pemfile = knife.get_pemfile(args.environment)
      list = knife.search(args.environment, "web")
      port = random.randrange(1,1000) + 33000
      counter = 1
      while not self.checkport(port) and counter < 5:
        port = random.randrange(1,1000) + 33000
        counter = counter + 1

      if counter > 5:
        raise RuntimeError("Could not find a free port")
      tunnel = SSHTunnel("ec2-user", list[0], hostname, pemfile, 22, 3306, port)
      hostname = "127.0.0.1"
    
    mysql_cmd = ["mysql", "-u", creds["username"],
      "-p%s" % creds["password"],"-h", hostname, "-P", str(port), "--prompt", "%s>\_" % args.environment]
    if not args.autocomplete:
      mysql_cmd.append("-A")
      
    mysql  = check_call(mysql_cmd)

    if pemfile is not None:
      os.unlink(pemfile)
  
  def tunnel(self, args):
    args.tunnel = True
    self.connect(args)
