#!/bin/bash

set -e

usage() {
    echo "Usage: `basename $0` [-e <staging|production>] [-v <master|golden>] [-m <module>] [-t <tier>]" >& 2
    echo "Options:" >& 2
    echo "  -e: aws environment to use for deployment inherited from $AWS_ENV by default" >& 2
    echo "  -m: specific module to push - pushes everything by default" >& 2
    echo "  -t: specific tier to push - pushes all tiers by default" >& 2
    echo >& 2
    echo "Module-Semantics: " >& 2
    echo "\tif everything is pushed (default) - then only modules that need to be installed are re-installed" >& 2
    echo "\tif specific modules are specified - then they are re-deployed regardless of whether they are up-to-date" >& 2
    echo "\tfor some modules (hadoop,hustler) - configuration files are reinitialized automatically on oozie-* tier" >& 2
    echo "Semantics: " >& 2
    exit $1
}


d=`dirname $0`
d=`cd "$d"; pwd`

sudo chmod 777 /media/ephemeral0
sudo chmod +t /media/ephemeral0

source ${d}/deploy-common.sh

module="all"
tier="oozie"

while getopts "he:v:m:s:t:pd" opt; do
    case $opt in
        h) usage 0
            ;;
        e) env_str=$OPTARG
            ;;
        s) out_path=$OPTARG
            ;;
        m) module=$OPTARG
            ;;
        t) tier=$OPTARG
            ;;
        \?)
            echo "Invalid option: -$OPTARG" >&2
            usage 1
            ;;
        :)
            echo "Option -$OPTARG requires an argument." >&2
            usage 1
            ;;
    esac
done

export out_path=$out_path

if [ "x${out_path}" == "x" ];then
  echo "please specify -s option"
  exit 1
fi


if [ $module != "all" ]; then
    validate_module $module
fi

#we dont need to validate env explicitly, because if env doesnot exist in chef
#then ssh will fail

if [ $tier != "oozie" -a $tier != "oozie-master" -a $tier != "oozie-slave" ]; then
  echo "-t option should be either oozie-master or oozie-slave or oozie or nothing"
  exit 1
fi

if [ $tier == "oozie" ]; then
  tier="oozie-*"
fi

selector="chef_environment:${env_str} AND qubole_tier:${tier}"

populate_creds
echo "Deploying module: $module  to tier: $tier on environment: ${env_str}" >& 2

if [ "$module" == "all" ]; then
    chef_command="sudo chef-client -j /etc/chef/first-boot.json -E ${env_str}"
else
    runlist='{"run_list":["recipe[webslave::deploy_'$module']"]}'
    chef_command="echo '${runlist}' > /tmp/runlist; sudo chef-client -j /tmp/runlist"
fi

# clean up dead nodes
cd ${out_path}/chef-repo
yes y | rake reap_instances
cd ${d}

set -ex

#Entering critical region. Interruption in this region causes a lot of grief
#and manual merging of chef version files is required
trap '' INT HUP TERM QUIT
knife ssh "$selector" "$chef_command" -x ec2-user -i $pemfile -a ec2.public_hostname --no-host-key-verify
trap - INT HUP TERM QUIT

rm -rf ${pemfile}

