#!/usr/bin/env ruby
require 'rubygems'
require 'aws/auto_scaling'
require 'aws/ec2'
require 'aws/elb'
require 'socket'
require 'yaml'
require 'dbi'

class HealthyNode
  def initialize(host, passwd, user, db, elb_name, env_str, pemfile, node)
    @env_str = env_str
    @host=host
    @passwd=passwd
    @user=user
    @db=db
    @node = node
    @elb_name = elb_name
    @pemfile=pemfile
    get_db_conn_handle
    sth = @db_conn_handle.prepare("SELECT var,value from settings where \
      var IN ('aws.root_access_key', 'aws.root_secret_key', 'aws.as_group_name')")
    sth.execute
    info = sth.to_a
    sth.finish
    @val = Hash.new
    info.each do |inf|
      @val[inf[0]]=inf[1]
    end    
  end
  
  def get_db_conn_handle
    return @db_conn_handle if !@db_conn_handle.nil?
    @db_conn_handle = nil
    # try to connect
    begin
      @db_conn_handle = DBI.connect("DBI:Mysql:#{@db}:#{@host}", @user, @passwd)
    rescue DBI::DatabaseError => e
      puts "#{Time.now.utc}: Failed to connect to DB"
      return 0
    end
  end
  
  def get_elb
    return @elb if !@elb.nil?
    access = @val['aws.root_access_key']
    secret = @val['aws.root_secret_key']
    @elb = AWS::ELB.new(:access_key_id => access, :secret_access_key => secret).load_balancers[@elb_name]
  end
  
  def wait_till_healthy_node
    health = ""
    while health != "InService"
      sleep 10
      health = get_elb.instances[@node].elb_health.state
      puts "Current elb health of instance :#{@node} is: #{health}" 
    end
  end
end

if __FILE__ == $0
  env_str= ARGV[0]
  host= ARGV[1]
  passwd= ARGV[2]
  user= ARGV[3]
  db= ARGV[4]
  elb= ARGV[5]
  pemfile= ARGV[6]
  node= ARGV[7]
  roll_deploy=HealthyNode.new(host, passwd, user, db, elb, env_str, pemfile, node).wait_till_healthy_node
end

