import json
import tempfile
import os

import yaml
import paramiko
from qds_ops.utils.fork import Fork


class Knife:
    def search(__self__, env, tier, extra_filters=None):
        search_string = "chef_environment:%s AND qubole_tier:%s" % (env, tier)
        if extra_filters is not None:
            filters = " AND ".join(extra_filters)
            search_string = "%s AND %s" % (search_string, filters)

        output = Fork.check_output(["knife", "search", "node", search_string,
                                    "-a", "ec2.public_hostname", "--format", "yaml"], stderr=None)
        nodes = yaml.load(output)
        nodelist = []
        for n in nodes[':rows']:
            nodelist.append(n['ec2.public_hostname'])
        return nodelist

    def packages(__self__, env, tier):
        ruby_code = """
nodeinfo = []; 
nodes.find(:chef_environment => "%s",:qubole_tier => "%s") { |n| 
  info={};
  info[:public_hostname] = n.ec2.public_hostname; 
  info[:packages]=n.default.qubole.to_hash;nodeinfo << info
}; 
puts nodeinfo.to_json""" % (env, tier)

        output = Fork.check_output(["knife", "exec", "-E", ruby_code], stderr=None)
        nodes = json.loads(output)
        return nodes

    def roles(__self__):
        output = Fork.check_output(["knife", "role", "list"], stderr=None)
        return output.split("\n")

    def describe(self, environment):
        output = Fork.check_output(["knife", "environment", "show", environment, "-f", "json"], stderr=None)
        info = json.loads(output)
        return info

    def get_credentials(self, environment):
        output = Fork.check_output(["knife", "data", "bag", "show", "creds",
                                    "env_%s" % (environment), "--secret-file", "/etc/chef/encrypted_data_bag_secret",
                                    "-f", "yaml"], stderr=None)
        creds = yaml.load(output)
        return creds

    def get_pemfile(self, env):
        creds = self.get_credentials(env)
        t = tempfile.NamedTemporaryFile(delete=False)
        t.write(creds["private_key"])
        t.close()
        return t.name

    def ssh(self, cmd, env, tier, extra_filters=None):
        temp = self.get_pemfile(env)
        search_string = "chef_environment:%s AND qubole_tier:%s" % (env, tier)
        if extra_filters is not None:
            filters = " AND ".join(extra_filters)
            search_string = "%s AND %s" % (search_string, filters)
        output = Fork.check_output(
            ["knife", "ssh", search_string, cmd, "-x", "ec2-user", "-i", temp, "-a", "ec2.public_hostname",
             "--no-host-key-verify"],
            stderr=None)
        os.unlink(temp)
        return output

    def ssh_one(self, cmd, env, tier):
        temp = self.get_pemfile(env)
        k = paramiko.RSAKey.from_private_key_file(temp)
        list = self.search(env, tier)
        print "Executing command on %s" % list[0]
        shell = paramiko.SSHClient()
        shell.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        shell.connect(list[0], username="ec2-user", pkey=k)
        stdin, stdout, stderr = shell.exec_command(cmd)
        os.unlink(temp)
        return stdout.read()

