import json
from subprocess import Popen
import os
import inspect

from tier import Tier
from qds_ops.tparty.knife import Knife


class Web(Tier):
    def __init__(self, subparser):
        self.tier = "web"
        self.modules = ["hive_scripts", "hadoop", "hustler", "hive", "sqoop", "oozie", "pig", "tapp2"]

        super(Web, self).__init__(subparser)

        #CMD
        cli = self.tier_parser.add_parser("cli",
                                          help="Show all cli.py processes or commands running on ALL web nodes")
        cli.set_defaults(func=self.cli)

        #CMD Count
        cli_count = self.tier_parser.add_parser("cli-count",
                                                help="Count number of cli.py or commands running on ALL web nodes")
        cli_count.set_defaults(func=self.cli_count)

        #DJ
        dj = self.tier_parser.add_parser("dj", help="List all Delayed jobs running on web nodes")
        dj.set_defaults(func=self.dj)

        #DJ Count
        dj_count = self.tier_parser.add_parser("dj-count", help="Count all DJs on each web node")
        dj_count.set_defaults(func=self.dj_count)

        #List Nodes
        list_zombies_parser = self.tier_parser.add_parser("list-zombies",
                                                          help="List nodes that will be shutdown after a rolling deploy in %s tier" % self.tier)
        list_zombies_parser.set_defaults(func=self.list_zombies)

        #List New Nodes
        list_new_parser = self.tier_parser.add_parser("list-new",
                                                      help="List nodes added after a rolling deploy in %s tier" % self.tier)
        list_new_parser.set_defaults(func=self.list_new)

        #SSH Zombie
        ssh_parser = self.tier_parser.add_parser("ssh-zombies",
                                                 help="SSH and run any bash command on machines that will be shutdown after a rolling deploy in %s tier" % self.tier)
        ssh_parser.add_argument("command", help="Bash command to run")
        ssh_parser.add_argument("-a", "--any", dest="any",
                                action="store_true", help="Login into any node in %s" % (self.tier))
        ssh_parser.set_defaults(func=self.ssh_zombies)

        #Screen Zombie
        screen_parser = self.tier_parser.add_parser("screen-zombies",
                                                    help="Use GNU screen and open terminals on ALL machines that will be shutdown in %s tier" % self.tier)
        screen_parser.set_defaults(func=self.screen_zombies)

        #SSH New
        ssh_parser = self.tier_parser.add_parser("ssh-new",
                                                 help="SSH and run any bash command on new machines after a rolling deploy in %s tier" % self.tier)
        ssh_parser.add_argument("command", help="Bash command to run")
        ssh_parser.add_argument("-a", "--any", dest="any",
                                action="store_true", help="Login into any node in %s" % (self.tier))
        ssh_parser.set_defaults(func=self.ssh_new)

        #Screen
        screen_parser = self.tier_parser.add_parser("screen-new",
                                                    help="Use GNU screen and open terminals on ALL machines added after a rolling deploy in %s tier" % self.tier)
        screen_parser.set_defaults(func=self.screen_new)

    def cli(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier)
        print output

    def cli_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier)
        print output

    def dj(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier)
        print output

    def dj_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier)
        print output

    def list_zombies(self, args):
        knife_search = Knife()
        list = knife_search.search(args.environment, self.tier, ["shutdown_gracefully:yes"])
        print json.dumps(list, indent=4, sort_keys=True)

    def list_new(self, args):
        knife_search = Knife()
        list = knife_search.search(args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print json.dumps(list, indent=4, sort_keys=True)

    def ssh_zombies(self, args):
        knife = Knife()
        output = ""
        if args.any:
            output = knife.ssh_one(args.command, args.environment, self.tier, ["shutdown_gracefully:yes"])
        else:
            output = knife.ssh(args.command, args.environment, self.tier, ["shutdown_gracefully:yes"])
        print output

    def screen_zombies(self, args):
        knife = Knife()
        output = knife.ssh("screen", args.environment, self.tier, ["shutdown_gracefully:yes"])
        print output

    def ssh_new(self, args):
        knife = Knife()
        output = ""
        if args.any:
            output = knife.ssh_one(args.command, args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        else:
            output = knife.ssh(args.command, args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print output

    def screen_new(self, args):
        knife = Knife()
        output = knife.ssh("screen", args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print output

    def deploy(self, args):
        deploy_cmd = ["/bin/bash"]
        base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
        deploy_cmd.extend([base_path + "/../scripts/chef_deploy_web.sh", "-e", args.environment])
        if args.commstuff == True:
            deploy_cmd.extend(["-c"])
        if args.stopdjs == True:
            deploy_cmd.extend(["-t"])
        if args.rolling == False:
            deploy_cmd.extend(["-r"])
        if args.djrestart == False:
            deploy_cmd.extend(["-d"])

        if args.module != "all":
            deploy_cmd.extend(["-m", args.module])
        deploy_cmd.extend(["-s", args.src_path])
        print str(deploy_cmd)
        p = Popen(" ".join(deploy_cmd), shell=True)
        retCode = p.wait()
        print "Return Code is: " + str(retCode)
