#!/bin/bash

set -e

usage() {
    echo "Usage: `basename $0` [-e <staging|production>] [-m <module>]" >& 2
    echo "Options:" >& 2
    echo "  -e: aws environment to use for deployment inherited from $AWS_ENV by default" >& 2
    echo "  -m: specific module to push - pushes everything by default" >& 2
    echo "  -d: specify -d if dj restart is not required. This options is valid only with -m tapp2." >& 2
    echo >& 2
    echo "Module-Semantics: " >& 2
    echo "\tif everything is pushed (default) - then only modules that need to be installed are re-installed" >& 2
    echo "\tif specific modules are specified - then they are re-deployed regardless of whether they are up-to-date" >& 2
    echo "\tfor some modules (hadoop,hustler) - configuration files are reinitialized automatically on oozie-* tier" >& 2
    echo "Semantics: " >& 2
    exit $1
}

d=`dirname $0`
d=`cd "$d"; pwd`

sudo chmod 777 /media/ephemeral0
sudo chmod +t /media/ephemeral0

source ${d}/deploy-common.sh

module="all"
tier="web"
djrestart=yes
rolling=yes
stop_djs_at_start=no
common_stuff_run=no

while getopts "he:v:m:s:drtc" opt; do
    case $opt in
        h) usage 0
            ;;
        e) env_str=$OPTARG
            ;;
        m) module=$OPTARG
            ;;
        s) out_path=$OPTARG
            ;;
        c) common_stuff_run=yes
            ;;
        r) rolling=no
            ;;
        t) stop_djs_at_start=yes
            ;;
        d) djrestart=no
            ;;
        \?)
            echo "Invalid option: -$OPTARG" >&2
            usage 1
            ;;
        :)
            echo "Option -$OPTARG requires an argument." >&2
            usage 1
            ;;
    esac
done

echo "Rolling Deploy is: $rolling"
echo "DJ is: $djrestart"
export out_path=$out_path
if [ "x${out_path}" == "x" ];then
  echo "please specify -s option"
  exit 1
fi

EXIT_STATUS=1
function clean_up {
  release_lock
  knife exec ${d}/set_node_attr.rb $env_str djrestart yes
  rm -rf /tmp/databag-${date}
  rm -rf ${pemfile}
  exit ${EXIT_STATUS}
}

if [ $module != "tapp2" ]; then
  if [ "$djrestart" == "no" ]; then
    echo "-d can be specified only with -m tapp2 option."
    exit 1
  fi
fi

if [ $module != "all" ]; then
    validate_module $module
fi

#we dont need to validate env explicitly, because if env doesnot exist in chef
#then ssh will fail

selector="chef_environment:${env_str} AND qubole_tier:${tier}"

populate_creds
try_lock

trap "clean_up" EXIT

# How will we get the pemfile for nokia
echo "Deploying module: $module  to tier: $tier on environment: ${env_str}" >& 2

#Running common stuff before running main deploy helps in transferring some config files to all nodes
if [ "$common_stuff_run" == "yes" ]; then
  runlist='{"run_list":["recipe[webslave::common_stuff]"]}'
  chef_command="echo '${runlist}' > /tmp/runlist12; sudo chef-client -j /tmp/runlist12"
  knife ssh "$selector" "$chef_command" -x ec2-user -i $pemfile -a ec2.public_hostname --no-host-key-verify
fi
  

if [ "$module" == "all" ]; then
    chef_command="sudo chef-client -j /etc/chef/first-boot.json -E ${env_str}"
else
    runlist='{"run_list":["recipe[webslave::deploy_'$module']"]}'
    chef_command="echo '${runlist}' > /tmp/runlist; sudo chef-client -j /tmp/runlist"
fi

cd ${d}

# set the target install version on all nodes in this environment
echo "setting install_branch on '$env_str' to $version" >& 2
set -ex

knife exec ${d}/set_node_attr.rb $env_str djrestart $djrestart

#Entering critical region. Interruption in this region causes a lot of grief
#and manual merging of chef version files is required
trap '' INT HUP TERM QUIT
#if dj restart is no => do normal deploy. This is possible iff -m tapp2 is used
if [ "x$djrestart" == "xno" ]; then
  master_selector="${selector} AND is_master:true AND NOT shutdown_gracefully:yes"
  slave_selector="${selector} AND is_master:false AND NOT shutdown_gracefully:yes"
  knife exec ${d}/set_single_master.rb $env_str true;
  sleep 10
  echo "Master Node is: "
  knife search node "$master_selector"
  ip=`knife exec ${d}/get_master.rb $env_str;`
  qbol_ssh ec2-user@${ip} "$chef_command" 
  echo "Waiting for master node to get Healthy under elb..."
  a=`knife search node "${master_selector}" -a name  | grep name`
  a=`echo $a | cut -d':' -f2 | tr -d [:space:]`
  echo "Master Node id: ${a}"
  /usr/bin/env ruby ${d}/wait_till_master_healthy.rb ${env_str} $host $password $username $database $lb_name ${pemfile} ${a}
  #use native ssh for master node as knife doesnot err on failure of chef_command. Master is only node where we want to err on failure
  #knife ssh "$master_selector" "$chef_command" -x ec2-user -i $pemfile -a ec2.public_hostname
  b=`knife search node "$slave_selector"`
  if [ "$b" !=  "0 items found" ]; then 
    knife ssh "$slave_selector" "$chef_command" -x ec2-user -i $pemfile -a ec2.public_hostname --no-host-key-verify
  else
    echo "No Slave Nodes found......"
  fi
elif [ \( "$module" == "all" -o "$module" == "tapp2" -o "$module" == "hive" \) -a "x$rolling" == "xyes" ]; then
  #do rolling upgrade if possible
  /usr/bin/env ruby ${d}/rolling_deploy.rb ${env_str} $host $password $username $database $lb_name ${pemfile} ${stop_djs_at_start}
else
  selectorfinal="${selector} AND NOT shutdown_gracefully:yes"
  knife ssh "$selectorfinal" "$chef_command" -x ec2-user -i $pemfile -a ec2.public_hostname --no-host-key-verify
fi
trap - INT HUP TERM QUIT

EXIT_STATUS=0


