#!/bin/bash -ex 
function usage()
{
    echo "Usage: `basename $0` [-v <chef cookbook version>] [-e <env>]" >& 2
    echo "Options:" >& 2
    echo "  -v: specify cookbook version generated by create-package-chef.sh. version should be of form x.y.0. We upload the version marked with tag created while you created a cookbook. You can specify a branch here, in this case we upload cookbook available at tip of branch" >& 2
    echo "  -e: specify env on which you want to deploy this cookbook" >& 2
    exit $1
}

d=`dirname $0`
d=`cd "$d"; pwd`
source ${d}/deploy-common.sh

version=""
env=""
while getopts "hv:e:s:" opt; do
    case $opt in
        h) usage 0
           ;;
        e)  env=$OPTARG
            ;;
        v)  version=$OPTARG
            ;;
        s)  out_path=$OPTARG
            ;;            
        \?)
            echo "Invalid option: -$OPTARG" >&2
            exit 1
            ;;
        :)
            echo "Option -$OPTARG requires an argument." >&2
            exit 1
            ;;
    esac
done

export out_path=$out_path
if [ "x${out_path}" == "x" ];then
  echo "please specify -s option"
  exit 1
fi

if [ "x${env}" == "x" ];then
  echo "please specify -e option"
  exit 1
fi

if [[ $version =~ ^[[:digit:]]+.[[:digit:]]+.[[:digit:]]+$ ]]; then 
  taged_version=yes
else 
  taged_version=no
fi

/bin/bash ${d}/git-pull.sh -b master -s chef-repo
if [ "$taged_version" == "yes" ]; then
  pushd ${out_path}/chef-repo/
  git checkout chef_${tagname}_${version}
  popd
  #validate that cookbook version mentione in metadata.rb == value passed
  cbook_version=`/usr/bin/env ruby ${d}/get_cbook_version.rb ${out_path}`
  if [ "x${cbook_version}" != "x${version}" ]; then
    echo "Value of version in cbook is: ${cbook_version}. The expected value is: ${version}. Exiting..."
    exit 1
  fi
else
  /bin/bash ${d}/git-pull.sh -b ${version} -s chef-repo
fi

#We cant do this validation as of now because we don't have qbol src tree in nokia
#${d}/validate_chef_attributes_versions.rb ${out_path} ${releases_dir} ${tagname}

#set the prev version that we were using till now just for reference. This
#will help us figure out how we changed the versions overtime.
knife exec ${d}/prev_webslave_version.rb $env
knife cookbook upload webslave -E $env --force --cookbook-path ${out_path}/chef-repo/cookbooks
echo "Done"

