import json
import os
import inspect
import logging
from qds_ops.entities.tier import Tier
from qds_ops.utils.fork import Fork
from qds_ops.utils.rolling_deploy import RollingDeploy
from qds_ops.utils.deploy_utils import DeployUtils
from qds_ops.tparty.knife import Knife
from qds_ops.entities.rds import RDS


class Web(Tier):
    tier = "web"
    modules = ["hive_scripts", "hadoop", "hustler", "hive", "sqoop", "pig", "tapp2"]
    worker = "qpal_worker"

    def __init__(self, subparser):
        super(Web, self).__init__(subparser)

        #CMD
        cli = self.tier_parser.add_parser("cli",
                                          help="Show all cli.py processes or commands running on ALL web nodes")
        cli.set_defaults(func=self.cli)

        #CMD Count
        cli_count = self.tier_parser.add_parser("cli-count",
                                                help="Count number of cli.py or commands running on ALL web nodes")
        cli_count.set_defaults(func=self.cli_count)

        #DJ
        dj = self.tier_parser.add_parser("dj", help="List all Delayed jobs running on web nodes")
        dj.set_defaults(func=self.dj)

        #DJ Count
        dj_count = self.tier_parser.add_parser("dj-count", help="Count all DJs on each web node")
        dj_count.set_defaults(func=self.dj_count)

        #List Nodes
        list_zombies_parser = self.tier_parser.add_parser("list-zombies",
                                                          help="List nodes that will be shutdown after a rolling deploy in %s tier" % self.tier)
        list_zombies_parser.set_defaults(func=self.list_zombies)

        #List New Nodes
        list_new_parser = self.tier_parser.add_parser("list-new",
                                                      help="List nodes added after a rolling deploy in %s tier" % self.tier)
        list_new_parser.set_defaults(func=self.list_new)

        #SSH Zombie
        ssh_parser = self.tier_parser.add_parser("ssh-zombies",
                                                 help="SSH and run any bash command on machines that will be shutdown after a rolling deploy in %s tier" % self.tier)
        ssh_parser.add_argument("command", help="Bash command to run")
        ssh_parser.add_argument("-a", "--any", dest="any",
                                action="store_true", help="Login into any node in %s" % (self.tier))
        ssh_parser.set_defaults(func=self.ssh_zombies)

        #Screen Zombie
        screen_parser = self.tier_parser.add_parser("screen-zombies",
                                                    help="Use GNU screen and open terminals on ALL machines that will be shutdown in %s tier" % self.tier)
        screen_parser.set_defaults(func=self.screen_zombies)

        #SSH New
        ssh_parser = self.tier_parser.add_parser("ssh-new",
                                                 help="SSH and run any bash command on new machines after a rolling deploy in %s tier" % self.tier)
        ssh_parser.add_argument("command", help="Bash command to run")
        ssh_parser.add_argument("-a", "--any", dest="any",
                                action="store_true", help="Login into any node in %s" % (self.tier))
        ssh_parser.set_defaults(func=self.ssh_new)

        #Screen
        screen_parser = self.tier_parser.add_parser("screen-new",
                                                    help="Use GNU screen and open terminals on ALL machines added after a rolling deploy in %s tier" % self.tier)
        screen_parser.set_defaults(func=self.screen_new)

        # Login - add --new argument
        self.login_parser.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        self.login_parser.set_defaults(func=self.web_login)
        
        #add new args for deploy_parser
        self.deploy_parser.add_argument("-r", "--no-rolling", dest="rolling",
                                   default=True, action="store_false",
                                   help="Don't do rolling deploy to %s" % (self.tier))
        self.deploy_parser.add_argument("-t", "--stop-djs-at-start", dest="stopdjs",
                                   default=False, action="store_true",
                                   help="At start of rolling deploy, stop DJs on current nodes")
        self.deploy_parser.add_argument("-c", "--run-common-stuff-recipe", dest="commstuff",
                                   default=False, action="store_true", help="Run common stuff at start of deploy")
        self.deploy_parser.add_argument("-d", "--no-djrestart", dest="djrestart",
                                   default=True, action="store_false", help="Don't do DJ restart on %s" % (self.tier))
        self.deploy_parser.set_defaults(func=self.web_deploy)

        #Deploy Lock
        lock_parser = self.tier_parser.add_parser("deploy-lock",
                                                help="Check, lock or unlock deploy lock")
        lock_parser.add_argument("-a", "--action", dest="action", choices=["check", "lock", "unlock"], default="check",
                                 help="Action to apply to the lock")
        lock_parser.add_argument("-t", "--tunnel", dest="tunnel",
                                 action="store_true", help="Setup a tunnel to RDS", default="False")
        lock_parser.set_defaults(func=self.deploy_lock)

    def cli(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier)
        print output

    def cli_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier)
        print output

    def dj(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier)
        print output

    def dj_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier)
        print output

    def list_zombies(self, args):
        knife_search = Knife()
        list = knife_search.search(args.environment, self.tier, ["shutdown_gracefully:yes"])
        print json.dumps(list, indent=4, sort_keys=True)

    def list_new(self, args):
        knife_search = Knife()
        list = knife_search.search(args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print json.dumps(list, indent=4, sort_keys=True)

    def ssh_zombies(self, args):
        knife = Knife()
        output = ""
        if args.any:
            output = knife.ssh_one(args.command, args.environment, self.tier, ["shutdown_gracefully:yes"])
        else:
            output = knife.ssh(args.command, args.environment, self.tier, ["shutdown_gracefully:yes"])
        print output

    def screen_zombies(self, args):
        knife = Knife()
        output = knife.ssh("screen", args.environment, self.tier, ["shutdown_gracefully:yes"])
        print output

    def ssh_new(self, args):
        knife = Knife()
        output = ""
        if args.any:
            output = knife.ssh_one(args.command, args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        else:
            output = knife.ssh(args.command, args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print output

    def screen_new(self, args):
        knife = Knife()
        output = knife.ssh("screen", args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
        print output
    
    def get_elb(self, env):
        creds = knife.get_credentials(env) 
        return creds["lb_name"]

    def as_name(self, env):
        return RDS.run_query(env, False, "SELECT value from settings where var IN ('aws.as_group_name')")['value']

    def web_deploy(self, args):
        if args.djrestart == False and args.module != "tapp2":
            raise Exception("-d argument can be specified only with -m tapp2")
        
        logging.info("Trying to take a lock for deploy on " + args.environment)
        knife = Knife()
        success = knife.deploy_lock(args.environment, False, self.tier, "lock")
        if success == False:
            raise Exception("Failed to take lock for deploy. Exiting...")
        
        try: 
            knife.reap_instances(args)
            temp = knife.get_pemfile(args.environment)
            creds = knife.get_credentials(args.environment) 
            
            if (args.commstuff == True):
                DeployUtils.run_common_stuff(args.environment, self.tier, temp)

            djrestart = "yes"
            if args.djrestart == False:
                djrestart = "no"

            elb_name = self.get_elb(args.environment)
            base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
            out = Fork.check_output(["knife", "exec", base_path + "/../scripts/set_node_attr.rb", args.environment, "djrestart", djrestart, self.tier ], stderr=None)
            print out

            if args.djrestart == False:
              DeployUtils.do_master_slave_deploy(args.environment, self.tier, temp, args.module, creds["access"], creds["secret"], elb_name)
            elif ((args.module == "all" or args.module == "tapp2" or args.module == "hive") and args.rolling == True):
                logging.info("Doing Rolling deploy")
                rd = RollingDeploy(creds["host"], creds["password"], creds["username"], creds["database"], elb_name, args.environment, temp, args.stopdjs, creds['access'], creds['secret'], self.as_name(args.environment), self.tier, self.worker).deploy()
            else:
                chef_command = DeployUtils.get_chef_command_for_module(args.module, args.environment)
                DeployUtils.run_chef_command(chef_command, args.environment, self.tier, temp, "AND NOT shutdown_gracefully:yes")
            logging.info("-------Done with deploy--------")
        finally:
            success = knife.deploy_lock(args.environment, False, self.tier, "unlock")

    def web_login(self, args):
        if args.host is None:
            knife_search = Knife()
            if args.zombies:
                list = knife_search.search(args.environment, self.tier, ["shutdown_gracefully:yes"])
                args.host = list[0]
            else:
                list = knife_search.search(args.environment, self.tier, [" NOT shutdown_gracefully:yes"])
                args.host = list[0]
        self.login(args)


    def deploy_lock(self, args):
        knife = Knife()
        knife.deploy_lock(args.environment, args.tunnel, self.tier, args.action)
