#!/bin/bash -ex

source ${d}/deploy-vars.sh

populate_creds(){
  date=`date +%s`
  knife data bag show creds env_${env_str} --secret-file /etc/chef/encrypted_data_bag_secret -f yaml > /tmp/databag-${date}
  host=`${d}/get_yaml_var.py /tmp/databag-${date} host`
  password=`${d}/get_yaml_var.py /tmp/databag-${date} password`
  username=`${d}/get_yaml_var.py /tmp/databag-${date} username`
  database=`${d}/get_yaml_var.py /tmp/databag-${date} database`
  lb_name=`${d}/get_yaml_var.py /tmp/databag-${date} lb_name`
  pemfile=/tmp/${env_str}_pem-${date}.pem
  ${d}/get_yaml_var.py /tmp/databag-${date} private_key > ${pemfile}
  chmod 600 ${pemfile}
}

#To use release lock and try lock directly, do following steps:
#d=.
#env_str=<env>
#source deploy-common.sh
#populate_creds
#release_lock or try_lock
release_lock() {
  a=`mysql -u${username} -p${password} -h${host} -D${database} -e 'update rstore.deploy_statuses set running = false where running = true' -vv`
  echo "Released DbLock for deploy"
}

try_lock() {
  echo "Try obtain DbLock for deploy"
  a=`mysql -u${username} -p${password} -h${host} -D${database} -e 'update rstore.deploy_statuses set running = true where running = false'  -vv  | grep "Query"`
  if [ "$a" == "Query OK, 0 rows affected" ]; then
    echo "Db seems to be already locked"
    exit 1
  fi
  echo "Obtained DbLock for deploy"
}

legal_modules="hive_scripts hadoop hustler hive sqoop pig tapp2"
validate_module() {
    module=$1
    found=false
    for t in $legal_modules;
    do
        if [ $t == $module ]; then
            found=true
        fi
    done
    
    if [ $found == "false" ]; then
        echo "module: $module not one of $legal_modules" >& 2
      	exit 1
    fi
}

validate_aws_env() {
    legal_env_aws=`knife environment list`
    env_str=$1
    found=false
    for t in $legal_env_aws
    do
	      if [ $t == $env_str ]; then
	          found=true
	      fi
    done

    if [ $found == "false" ]; then
        echo "aws environment must be one of $legal_env_aws" >& 2
	exit 1
    fi
}

qbol_ssh() {
    if [ "x$pemfile" == "x" ]; then
        echo "No pemfile passed to qbol_scp!" >& 2
        exit 1
    fi
    ssh -o 'StrictHostKeyChecking=no' -t -t -i $pemfile $@
}


