from qds_ops.entities.web import Web

class DefaultDJ(Web):

    def __init__(self):
        tier = "defaultdj"
        worker = "pju_worker"
        ami = "ami-1327167a"
        instance_type = "r3.xlarge"
        run_list = '{"run_list":["recipe[webslave::deploy_dj]"],"qubole_tier":"%s", "worker_name":"%s"}'
        modules = ["hive_scripts", "hadoop", "hadoop2", "hustler", "hive", "sqoop", "pig", "tapp2", "cloudman"]
        region = "us-east-1"
        az = "us-east-1b"
        security_groups = ['default']

        self.set_ami(ami), self.set_az(az), self.set_region(region)
        self.set_instance_type(instance_type), self.set_run_list(run_list)
        self.set_tier(tier), self.set_worker(worker), self.set_modules(modules),
        self.set_security_groups(security_groups)
        self.is_autoscalable = True

    def configure_parsers(self):
        # DefaultDJ needs the parsers of Web tier
        super(DefaultDJ, self).configure_parsers()
        # Create
        create = self.tier_parser.add_parser("create", help="Create Cron Tier. "
                                                            "Command will return after instance is in running state")
        create.add_argument("-a", "--ami-id", help="AMI ID to use for the CRON tier",
                            default=self.ami, dest="ami")
        create.add_argument("-z", "--zone", help="AWS Availibility Zone",
                            default=self.az, dest="zone")
        create.add_argument("-r", "--region", help="Region where the tier will be located",
                            default=self.region, dest="region")
        create.add_argument("-i", "--instance-type", help="Instance Type of the machine",
                            choices=["m3.large", "m3.xlarge", "r3.large", "r3.xlarge", "r3.2xlarge"], dest="instance_type",
                            default=self.instance_type)
        create.add_argument("-t", "--tunnel", dest="tunnel",
                            action="store_true", help="Use a tunnel through a web node")
        create.set_defaults(func=self.asg)
    
    def get_elb(self, env):
        return None

    def as_name(self, env):
        default_as_group = super(DefaultDJ, self).as_name(env)
        return "%s-%s" % (default_as_group, self.tier)

