#!/bin/env python

import sys
import traceback
import logging
from qds_ops.utils import argparse
from qds_ops import __version__
from qds_ops.tparty.knife import Knife

from entities import Chef, RDS, Web, Log, OozieSlave,\
    OozieMaster, Oozie, Scheduler, DefaultDJ, ExperimentalDJ,\
    Redis

def main():

    root = logging.getLogger()
    root.setLevel(logging.INFO)

    ch = logging.StreamHandler(sys.stdout)
    ch.setLevel(logging.INFO)
    formatter = logging.Formatter('%(asctime)s - %(module)s - %(levelname)s - %(message)s')
    ch.setFormatter(formatter)
    root.addHandler(ch)

    argparser = argparse.ArgumentParser(description="Operational tool for Qubole Data Service.")
    argparser.add_argument("-e", "--env", dest="environment",
        help="Qubole environment")
    argparser.add_argument("-d", "--debug", action = "store_true", default=False,
                           help="Turn on debug logging")
    argparser.add_argument('--version', action='version', version=__version__)
    subparsers = argparser.add_subparsers()

    # chef and rds are externally managed tiers not qubole managed
    chef = Chef()
    rds = RDS()
    chef.configure_parsers(subparsers)
    rds.configure_parsers(subparsers)

    # qubole managed tiers
    tiers = \
        [Web(), Log(), OozieMaster(), OozieSlave(), Oozie(), Scheduler(), DefaultDJ(), ExperimentalDJ(), Redis()]

    # configure common parsers
    [
        p.configure_common_parsers(subparsers) for p in tiers
    ]

    # configure tier specific parsers
    [
        p.configure_parsers() for p in tiers
    ]

    args = argparser.parse_args()
    if args.debug:
        ch.setLevel(logging.DEBUG)
        root.setLevel(logging.DEBUG)
        logging.debug("Debug is ON!")
    try:
        args.func(args)
    finally:
        logging.debug("Cleaning up")
        Knife().cleanup()

if __name__ == '__main__':
    try:
        sys.exit(main())
    except Exception:
        traceback.print_exc(file=sys.stderr)
        sys.exit(3)

